/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.util;

import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.dvs.HostDistributedVirtualSwitchManager;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.SriovInfo;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceOption;
import com.vmware.vim.binding.vim.vm.device.VirtualE1000;
import com.vmware.vim.binding.vim.vm.device.VirtualE1000e;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualPCNet32;
import com.vmware.vim.binding.vim.vm.device.VirtualPCNet32Option;
import com.vmware.vim.binding.vim.vm.device.VirtualSriovEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet2;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet3;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.dvpg.api.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.modules.api.network.HostNetworkCapability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkUtil {
    private static final Log _logger = LogFactory.getLog(NetworkUtil.class);
    public static final int VLAN_NONE_ID = 0;
    private static final String OUT_RANGE_DELIMITER = ", ";
    private static final String OUT_RANGE_DIVIDER = "-";
    private static final String VMWARE_VENDOR = "VMware";
    private static final String VMWARE_VENDOR_INC = "VMware, Inc.";
    public static final long DEFAULT_BANDWIDTH = 100000L;
    public static final int MAX_NUM_PORTS = 8192;
    public static final long DEFAULT_BURST_SIZE = 102400L;
    public static final String BASIC_LACP_SUPPORT = "singleLag";

    public static String getVlanIdBySpec(VmwareDistributedVirtualSwitch.VlanSpec spec, VmwareDistributedVirtualSwitch.PvlanMapEntry[] entries) {
        if (spec == null) {
            return null;
        }
        String vlanId = null;
        String vlanType = NetworkStringUtil.getString("NetworkUtil.noVLAN");
        if (spec instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            if (entries == null) {
                return null;
            }
            VmwareDistributedVirtualSwitch.PvlanSpec pVlanSpec = (VmwareDistributedVirtualSwitch.PvlanSpec)spec;
            vlanId = NetworkUtil.getPvlanId(pVlanSpec, entries);
            vlanType = NetworkStringUtil.getString("NetworkUtil.privateVLAN");
        } else if (spec instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            vlanType = NetworkStringUtil.getString("NetworkUtil.vlanTrunk");
            VmwareDistributedVirtualSwitch.TrunkVlanSpec trunkVlanSpec = (VmwareDistributedVirtualSwitch.TrunkVlanSpec)spec;
            vlanId = NetworkUtil.formatVlanTrunkRange(trunkVlanSpec.vlanId);
        } else if (spec instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            VmwareDistributedVirtualSwitch.VlanIdSpec vlanIdSpec = (VmwareDistributedVirtualSwitch.VlanIdSpec)spec;
            vlanType = NetworkStringUtil.getString("NetworkUtil.vlanAccess");
            vlanId = Integer.toString(vlanIdSpec.vlanId);
        }
        return NetworkStringUtil.getString("NetworkUtil.vlanIdFormat", vlanType, vlanId);
    }

    public static String getPvlanId(VmwareDistributedVirtualSwitch.PvlanSpec pVlanSpec, VmwareDistributedVirtualSwitch.PvlanMapEntry[] entries) {
        for (VmwareDistributedVirtualSwitch.PvlanMapEntry entry : entries) {
            if (entry.secondaryVlanId != pVlanSpec.pvlanId) continue;
            return NetworkStringUtil.getString("NetworkUtil.privateVlanFormat", NetworkUtil.getPrivateVlanPortType(entry.pvlanType), Integer.toString(entry.primaryVlanId), Integer.toString(entry.secondaryVlanId));
        }
        return "";
    }

    public static String formatVlanTrunkRange(NumericRange[] vlanTrunkRange) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < vlanTrunkRange.length; ++i) {
            NumericRange range = vlanTrunkRange[i];
            if (range != null) {
                builder.append(range.start);
                if (range.start != range.end) {
                    builder.append(String.format("-%d", range.end));
                }
            }
            if (i >= vlanTrunkRange.length - 1) continue;
            builder.append(OUT_RANGE_DELIMITER);
        }
        return builder.toString();
    }

    public static String getPrivateVlanPortType(String type2) {
        try {
            switch (VmwareDistributedVirtualSwitch.PvlanPortType.valueOf((String)type2)) {
                case community: {
                    return NetworkStringUtil.getString("NetworkUtil.pVlan.community");
                }
                case isolated: {
                    return NetworkStringUtil.getString("NetworkUtil.pVlan.isolated");
                }
                case promiscuous: {
                    return NetworkStringUtil.getString("NetworkUtil.pVlan.promiscuous");
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String getNumericRangeAsString(NumericRange[] ranges) {
        if (ranges == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String outRangeDelimiter = "";
        for (NumericRange range : ranges) {
            result.append(outRangeDelimiter);
            if (range.getStart() == range.getEnd()) {
                result.append(Integer.toString(range.getStart()));
            } else {
                result.append(Integer.toString(range.getStart()));
                result.append(OUT_RANGE_DIVIDER);
                result.append(Integer.toString(range.getEnd()));
            }
            outRangeDelimiter = OUT_RANGE_DELIMITER;
        }
        return result.toString();
    }

    public static boolean isVmwareVendor(String vendor) {
        return VMWARE_VENDOR.equals(vendor) || VMWARE_VENDOR_INC.equals(vendor);
    }

    public static <T> T requestPropertyWithParam(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, Object mor, String propertyName, Object param) throws Exception {
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.propertyName = propertyName;
        paramSpec.parameter = param;
        QuerySpec querySpec = querySpecBuilder.buildQuerySpec(mor, new String[]{propertyName});
        querySpec.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{paramSpec};
        ResultSet resultSet = queryExecutor.getData(querySpec);
        if (resultSet != null && resultSet.error != null) {
            _logger.error((Object)String.format("Failed to retrieve property '%s': %s", propertyName, resultSet.error.getMessage()), (Throwable)resultSet.error);
        }
        if (resultSet != null && resultSet.items != null && resultSet.items.length > 0 && resultSet.items[0].properties != null) {
            for (PropertyValue propValue : resultSet.items[0].properties) {
                if (!propertyName.equals(propValue.propertyName)) continue;
                return (T)propValue.value;
            }
        }
        return null;
    }

    public static VirtualSwitch getVswitchByName(String vSwitchName, VirtualSwitch[] vSwitches) {
        if (vSwitches == null || StringUtils.isEmpty((String)vSwitchName)) {
            return null;
        }
        for (VirtualSwitch vs : vSwitches) {
            if (!vs.name.equals(vSwitchName)) continue;
            return vs;
        }
        return null;
    }

    public static List<PhysicalNic> getSwitchPnics(VirtualSwitch vSwitch, PhysicalNic[] pnics) {
        ArrayList<PhysicalNic> switchPnics = new ArrayList<PhysicalNic>();
        if (vSwitch != null && vSwitch.pnic != null && pnics != null) {
            for (PhysicalNic pnic : pnics) {
                for (String pnicKey : vSwitch.pnic) {
                    if (!pnicKey.equals(pnic.key)) continue;
                    switchPnics.add(pnic);
                }
            }
        }
        return switchPnics;
    }

    public static boolean isPnicAttachedToVss(PhysicalNic pnic, VirtualSwitch[] vSwitches) {
        if (pnic == null || vSwitches == null) {
            return false;
        }
        for (VirtualSwitch vSwitch : vSwitches) {
            if (vSwitch.pnic == null) continue;
            for (String pnicKey : vSwitch.pnic) {
                if (!pnicKey.equals(pnic.key)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPnicAttachedToOvs(PhysicalNic pnic, OpaqueSwitch[] opaqueSwitches) {
        if (pnic == null || opaqueSwitches == null) {
            return false;
        }
        for (OpaqueSwitch opaqueSwitch : opaqueSwitches) {
            if (opaqueSwitch.pnic == null) continue;
            for (String pnicKey : opaqueSwitch.pnic) {
                if (!pnicKey.equals(pnic.key)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLastManagementVmnic(NetworkInfo networkInfo, String virtualNicName) {
        VirtualNic[] defaultNetStackVnics = NetworkUtil.getDefaultNetStackVnics(networkInfo);
        return defaultNetStackVnics.length == 1 && defaultNetStackVnics[0].getDevice().equals(virtualNicName);
    }

    public static VirtualNic[] getDefaultNetStackVnics(NetworkInfo networkInfo) {
        return NetworkUtil.getNetStackVnic(NetStackInstance.SystemStackKey.defaultTcpipStack.toString(), networkInfo.vnic, networkInfo.netStackInstance);
    }

    public static VirtualNic[] getNetStackVnic(String netStackKey, VirtualNic[] virtualNics, NetStackInstance[] netStackInstance) {
        List<Object> netStackVnic = new ArrayList();
        if (!ArrayUtil.isNullOrEmpty((Object[])netStackInstance)) {
            for (VirtualNic vnic : virtualNics) {
                if (!StringUtil.isNullOrEmpty((String)vnic.spec.netStackInstanceKey)) {
                    if (!vnic.spec.netStackInstanceKey.equals(netStackKey)) continue;
                    netStackVnic.add(vnic);
                    continue;
                }
                if (!netStackKey.equals(NetStackInstance.SystemStackKey.defaultTcpipStack.toString())) continue;
                netStackVnic.add(vnic);
            }
        } else if (netStackKey.equals(NetStackInstance.SystemStackKey.defaultTcpipStack.toString())) {
            netStackVnic = Arrays.asList(virtualNics);
        }
        return netStackVnic.toArray(new VirtualNic[netStackVnic.size()]);
    }

    public static boolean areAllVnicsBelongingTo(String vSwitchName, NetworkInfo networkInfo, VirtualNic[] vnics) {
        PortGroup[] vswitchPortgroups = NetworkUtil.getVswitchPortgroups(vSwitchName, networkInfo);
        return NetworkUtil.areAllVnicsConnectedToPortgroups(vnics, vswitchPortgroups);
    }

    public static VirtualNic getVirtualNicByPortGroupName(String portGroupName, VirtualNic[] virtualNics) {
        VirtualNic portGroupVirtualNic = null;
        if (portGroupName != null && virtualNics != null) {
            for (VirtualNic vnic : virtualNics) {
                if (vnic == null || !portGroupName.equals(vnic.portgroup)) continue;
                portGroupVirtualNic = vnic;
                break;
            }
        }
        return portGroupVirtualNic;
    }

    public static PortGroup getPortgroupByKey(String key, PortGroup[] portgroups) {
        PortGroup portgroup = null;
        if (key != null && portgroups != null) {
            for (PortGroup pgroup : portgroups) {
                if (pgroup == null || !key.equals(pgroup.key)) continue;
                portgroup = pgroup;
                break;
            }
        }
        return portgroup;
    }

    public static PhysicalNic getPnicByName(String name, PhysicalNic[] pnics) {
        PhysicalNic physicalNic = null;
        if (name != null && pnics != null) {
            for (PhysicalNic pnic : pnics) {
                if (pnic == null || !name.equals(pnic.device)) continue;
                physicalNic = pnic;
                break;
            }
        }
        return physicalNic;
    }

    public static List<String> getActiveNics(NetworkPolicy.NicOrderPolicy nicOrder) {
        ArrayList<String> activeNics = new ArrayList<String>();
        if (nicOrder != null && nicOrder.activeNic != null) {
            activeNics = new ArrayList();
            activeNics.addAll(Arrays.asList(nicOrder.activeNic));
        }
        return activeNics;
    }

    public static List<String> getStandbyNics(NetworkPolicy.NicOrderPolicy nicOrder) {
        ArrayList<String> standbyNics = new ArrayList<String>();
        if (nicOrder != null && nicOrder.standbyNic != null) {
            standbyNics = new ArrayList();
            standbyNics.addAll(Arrays.asList(nicOrder.standbyNic));
        }
        return standbyNics;
    }

    public static List<String> getUnusedNics(NetworkPolicy.NicOrderPolicy nicOrder, VirtualSwitch vSwitch, PhysicalNic[] pnics) {
        List<String> active = NetworkUtil.getActiveNics(nicOrder);
        List<String> standby = NetworkUtil.getStandbyNics(nicOrder);
        ArrayList<String> unused = new ArrayList<String>();
        List<PhysicalNic> physycalAdapters = NetworkUtil.getSwitchPnics(vSwitch, pnics);
        for (PhysicalNic pnic : physycalAdapters) {
            if (active.contains(pnic.device) || standby.contains(pnic.device)) continue;
            unused.add(pnic.device);
        }
        return unused;
    }

    public static PortGroup[] getVswitchPortgroups(String virtualSwitchName, NetworkInfo networkInfo) {
        if (virtualSwitchName == null || networkInfo == null || networkInfo.portgroup == null) {
            return new PortGroup[0];
        }
        ArrayList<PortGroup> portgroups = new ArrayList<PortGroup>();
        for (PortGroup portgroup : networkInfo.portgroup) {
            if (!virtualSwitchName.equals(portgroup.spec.vswitchName)) continue;
            portgroups.add(portgroup);
        }
        return portgroups.toArray(new PortGroup[portgroups.size()]);
    }

    public static boolean isSystemNetworkResourcePool(String nrpKey) {
        for (HostDistributedVirtualSwitchManager.NetworkResourcePoolKey key : HostDistributedVirtualSwitchManager.NetworkResourcePoolKey.values()) {
            if (!key.name().equals(nrpKey)) continue;
            return true;
        }
        return false;
    }

    public static int calculateAvailablePortsCountByNetworkInfo(HostNetworkCapability hostNetworkCapability, VirtualSwitch[] virtualSwitches, HostProxySwitch[] proxySwitches) {
        if (hostNetworkCapability == null || hostNetworkCapability.proxySwitchAutoScaleSupported) {
            return -1;
        }
        int portNumbersReserved = 0;
        if (proxySwitches != null) {
            for (HostProxySwitch hostProxySwitch : proxySwitches) {
                portNumbersReserved += hostProxySwitch.numPorts;
            }
        }
        if (virtualSwitches != null) {
            for (HostProxySwitch hostProxySwitch : virtualSwitches) {
                if (hostProxySwitch.spec == null) continue;
                portNumbersReserved += hostProxySwitch.spec.numPorts;
            }
        }
        return hostNetworkCapability.vssMaxPortLimit - portNumbersReserved > 0 ? hostNetworkCapability.vssMaxPortLimit - portNumbersReserved : 0;
    }

    private static boolean areAllVnicsConnectedToPortgroups(VirtualNic[] vnics, PortGroup[] portGroups) {
        Validate.notNull((Object)vnics);
        for (VirtualNic vnic : vnics) {
            if (NetworkUtil.isVnicConnectedToPortgroup(vnic, portGroups).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static Boolean isVnicConnectedToPortgroup(VirtualNic vnic, PortGroup[] portGroups) {
        Validate.notNull((Object)vnic);
        for (PortGroup portGroup : portGroups) {
            if (!vnic.portgroup.equals(portGroup.spec.name)) continue;
            return true;
        }
        return false;
    }

    public static HostNetworkDetailsData.PortPolicy getPortPolicy(VirtualSwitch vSwitch, PhysicalNic[] pnics) {
        return NetworkUtil.getPortPolicy(vSwitch, pnics, vSwitch.spec.policy, null);
    }

    public static HostNetworkDetailsData.PortPolicy getPortPolicy(VirtualSwitch vSwitch, PhysicalNic[] pnics, NetworkPolicy specPolicy, NetworkPolicy computedPolicy) {
        HostNetworkDetailsData.PortPolicy result = new HostNetworkDetailsData.PortPolicy();
        result.security = NetworkUtil.getSecurityPolicy(specPolicy, computedPolicy);
        result.trafficShaping = NetworkUtil.getTrafficShapingPolicy(specPolicy, computedPolicy);
        result.teamingAndFailover = NetworkUtil.getNicTeamingAndFailoverPolicy(vSwitch, pnics, specPolicy, computedPolicy);
        return result;
    }

    public static boolean isNicOrderOverridden(NetworkPolicy specPolicy) {
        return specPolicy != null && specPolicy.nicTeaming != null && specPolicy.nicTeaming.nicOrder != null;
    }

    public static NetworkPolicy.NicOrderPolicy getNicOrder(NetworkPolicy portgroupPolicy, NetworkPolicy vSwitchPolicy) {
        NetworkPolicy.NicOrderPolicy nicOrder = null;
        if (NetworkUtil.isNicOrderOverridden(portgroupPolicy)) {
            nicOrder = portgroupPolicy.nicTeaming.nicOrder;
        } else if (vSwitchPolicy != null && vSwitchPolicy.nicTeaming != null) {
            nicOrder = vSwitchPolicy.nicTeaming.nicOrder;
        }
        return nicOrder;
    }

    public static HostNetworkDetailsData.PortPolicy.Security getSecurityPolicy(NetworkPolicy specPolicy, NetworkPolicy computedPolicy) {
        NetworkPolicy.SecurityPolicy security = specPolicy.security;
        HostNetworkDetailsData.PortPolicy.Security securityPolicy = new HostNetworkDetailsData.PortPolicy.Security();
        if (security != null) {
            securityPolicy.allowPromiscuous = BooleanUtils.toBoolean((Boolean)security.allowPromiscuous);
            securityPolicy.forgedTransmits = BooleanUtils.toBoolean((Boolean)security.forgedTransmits);
            securityPolicy.macChanges = BooleanUtils.toBoolean((Boolean)security.macChanges);
        }
        if (computedPolicy != null && computedPolicy.security != null) {
            NetworkPolicy.SecurityPolicy computedSecurityPolicy = computedPolicy.security;
            securityPolicy.allowPromiscuous = securityPolicy.allowPromiscuous || BooleanUtils.toBoolean((Boolean)computedSecurityPolicy.allowPromiscuous);
            securityPolicy.forgedTransmits = securityPolicy.forgedTransmits || BooleanUtils.toBoolean((Boolean)computedSecurityPolicy.forgedTransmits);
            securityPolicy.macChanges = securityPolicy.macChanges || BooleanUtils.toBoolean((Boolean)computedSecurityPolicy.macChanges);
        }
        return securityPolicy;
    }

    private static HostNetworkDetailsData.PortPolicy.TrafficShaping getTrafficShapingPolicy(NetworkPolicy specPolicy, NetworkPolicy computedPolicy) {
        NetworkPolicy.TrafficShapingPolicy shapingPolicy = null;
        if (!NetworkUtil.isTrafficShapingPolicyNullOrEmpty(specPolicy.shapingPolicy)) {
            shapingPolicy = specPolicy.shapingPolicy;
        } else if (computedPolicy != null && !NetworkUtil.isTrafficShapingPolicyNullOrEmpty(computedPolicy.shapingPolicy)) {
            shapingPolicy = computedPolicy.shapingPolicy;
        }
        HostNetworkDetailsData.PortPolicy.TrafficShaping trafficShaping = new HostNetworkDetailsData.PortPolicy.TrafficShaping();
        if (shapingPolicy != null && shapingPolicy.enabled.booleanValue()) {
            trafficShaping.averageBandwidthSummary = FormatUtil.getBitRateFormatted((Number)NetworkUtil.getLongValue(shapingPolicy.averageBandwidth, 100000L * FormatUtil.KBPS), (int)0, (long)FormatUtil.BPS, (long)FormatUtil.KBPS, (boolean)true);
            trafficShaping.burstSizeSummary = FormatUtil.getDataSizeFormatted((Number)NetworkUtil.getLongValue(shapingPolicy.burstSize, 100000L * FormatUtil.KBPS), (int)0, (long)1L, (long)1024L, (boolean)true);
            trafficShaping.peakBandwidthSummary = FormatUtil.getBitRateFormatted((Number)NetworkUtil.getLongValue(shapingPolicy.peakBandwidth, 100000L * FormatUtil.KBPS), (int)0, (long)FormatUtil.BPS, (long)FormatUtil.KBPS, (boolean)true);
        }
        return trafficShaping;
    }

    private static HostNetworkDetailsData.PortPolicy.TeamingAndFailover getNicTeamingAndFailoverPolicy(VirtualSwitch vSwitch, PhysicalNic[] pnics, NetworkPolicy specPolicy, NetworkPolicy computedPolicy) {
        boolean computedPolicyAvailable;
        HostNetworkDetailsData.PortPolicy.TeamingAndFailover teamingAndFailover = new HostNetworkDetailsData.PortPolicy.TeamingAndFailover();
        NetworkPolicy.NicTeamingPolicy nicTeaming = specPolicy.nicTeaming;
        NetworkPolicy.NicTeamingPolicy computedNicTeaming = null;
        boolean policyAvailable = specPolicy.nicTeaming != null;
        boolean bl = computedPolicyAvailable = computedPolicy != null && computedPolicy.nicTeaming != null;
        if (computedPolicyAvailable) {
            computedNicTeaming = computedPolicy.nicTeaming;
        }
        if (policyAvailable && nicTeaming.policy != null) {
            teamingAndFailover.loadBalancing = nicTeaming.policy;
        } else if (computedPolicyAvailable && computedNicTeaming.policy != null) {
            teamingAndFailover.loadBalancing = computedNicTeaming.policy;
        }
        if (policyAvailable && nicTeaming.failureCriteria != null && nicTeaming.failureCriteria.checkBeacon != null) {
            teamingAndFailover.failureDetection = nicTeaming.failureCriteria.checkBeacon;
        } else if (computedPolicyAvailable && computedNicTeaming.failureCriteria != null && computedNicTeaming.failureCriteria.checkBeacon != null) {
            teamingAndFailover.failureDetection = computedNicTeaming.failureCriteria.checkBeacon;
        }
        if (policyAvailable && nicTeaming.notifySwitches != null) {
            teamingAndFailover.notifySwitches = nicTeaming.notifySwitches;
        } else if (computedPolicyAvailable && computedNicTeaming.notifySwitches != null) {
            teamingAndFailover.notifySwitches = computedNicTeaming.notifySwitches;
        }
        if (policyAvailable && specPolicy.nicTeaming.rollingOrder != null) {
            teamingAndFailover.failback = specPolicy.nicTeaming.rollingOrder == false;
        } else if (computedPolicyAvailable && computedNicTeaming.rollingOrder != null) {
            teamingAndFailover.failback = computedNicTeaming.rollingOrder == false;
        }
        NetworkPolicy.NicOrderPolicy nicOrder = NetworkUtil.getNicOrder(specPolicy, computedPolicy);
        teamingAndFailover.activeAdapters = NetworkUtil.getActiveNics(nicOrder);
        teamingAndFailover.standByAdapters = NetworkUtil.getStandbyNics(nicOrder);
        teamingAndFailover.unusedAdapters = NetworkUtil.getUnusedNics(nicOrder, vSwitch, pnics);
        return teamingAndFailover;
    }

    private static boolean isTrafficShapingPolicyNullOrEmpty(NetworkPolicy.TrafficShapingPolicy shapingPolicy) {
        return shapingPolicy == null || shapingPolicy.averageBandwidth == null && shapingPolicy.peakBandwidth == null && shapingPolicy.burstSize == null && shapingPolicy.enabled == null;
    }

    private static long getLongValue(Long longValue, long defaultValue) {
        return longValue != null ? longValue : defaultValue;
    }

    public static <T> T getPropertyValue(ResultItem resItem, String propName) {
        PropertyValue propValue = ResultUtil.getPropertyValue((ResultItem)resItem, (String)propName);
        if (propValue != null && propValue.value != null) {
            return (T)propValue.value;
        }
        return null;
    }

    public static SriovInfo getSriovByPnic(String pci, SriovInfo[] sriovInfos) {
        if (sriovInfos == null || sriovInfos.length == 0) {
            return null;
        }
        for (int i = 0; i < sriovInfos.length; ++i) {
            if (!pci.equals(sriovInfos[i].id)) continue;
            return sriovInfos[i];
        }
        return null;
    }

    public static String getUniqueName(PortGroup[] portGroups, String uniqueNamePrefix) {
        if (portGroups == null) {
            return uniqueNamePrefix;
        }
        HashSet<String> portGroupNames = new HashSet<String>();
        for (PortGroup portGroup : portGroups) {
            portGroupNames.add(portGroup.spec.name);
        }
        int i = 2;
        String uniqueName = uniqueNamePrefix;
        while (portGroupNames.contains(uniqueName)) {
            uniqueName = uniqueNamePrefix + " " + i;
            ++i;
        }
        return uniqueName;
    }

    public static int compareNicDevices(String nic1, String nic2, String nicPrefix) {
        if (nic1 == null && nic2 == null) {
            return 0;
        }
        if (nic1 == null) {
            return -1;
        }
        if (nic2 == null) {
            return 1;
        }
        String nic1Index = nic1.replace(nicPrefix, "");
        String nic2Index = nic2.replace(nicPrefix, "");
        Integer nic1Number = null;
        Integer nic2Number = null;
        try {
            nic1Number = Integer.parseInt(nic1Index);
            nic2Number = Integer.parseInt(nic2Index);
        }
        catch (NumberFormatException nfe) {
            return nic1.compareTo(nic2);
        }
        return nic1Number.compareTo(nic2Number);
    }

    public static String getAdapterType(VirtualEthernetCard adapter, VirtualDeviceOption[] vmDeviceConfigOption) {
        String adapterType;
        if (adapter instanceof VirtualVmxnet) {
            adapterType = adapter instanceof VirtualVmxnet3 ? NetworkStringUtil.getString("VnicType.vmxnet3") : (adapter instanceof VirtualVmxnet2 ? NetworkStringUtil.getString("VnicType.vmxnet2") : NetworkStringUtil.getString("VnicType.vmxnet"));
        } else if (adapter instanceof VirtualE1000) {
            adapterType = NetworkStringUtil.getString("VnicType.e1000");
        } else if (adapter instanceof VirtualPCNet32) {
            adapterType = NetworkStringUtil.getString("VnicType.pcNet32");
            if (vmDeviceConfigOption != null) {
                for (VirtualDeviceOption deviceOption : vmDeviceConfigOption) {
                    if (!(deviceOption instanceof VirtualPCNet32Option)) continue;
                    VirtualPCNet32Option vlanceOption = (VirtualPCNet32Option)deviceOption;
                    if (vlanceOption.supportsMorphing) {
                        adapterType = NetworkStringUtil.getString("VnicType.morphing");
                    }
                    break;
                }
            }
        } else {
            adapterType = adapter instanceof VirtualE1000e ? NetworkStringUtil.getString("VnicType.e1000e") : (adapter instanceof VirtualSriovEthernetCard ? NetworkStringUtil.getString("VnicType.sriovPassthru") : NetworkStringUtil.getString("VnicType.unrecognized"));
        }
        return adapterType;
    }
}

