/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.pbm.ServerObjectRef;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfileCreateSpec;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.mvc.serialize.ThrowableSerializer;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.QueryExecutorUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.commonservice.util.StorageUtil;
import com.vmware.vsphere.client.h5.spbm.data.StorageProfileContainerCompatibilityData;
import com.vmware.vsphere.client.h5.spbm.util.SpbmStringUtil;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.data.SpbmCompatibilityResult;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilePropertyProvider
implements PropertyProviderBean {
    public static final String PROPERTY_DATACENTER = "dc";
    public static final String PROPERTY_PARENT = "parent";
    public static final String PROPERTY_STORAGEPOD_DISPLAY_NAME = "summary.name";
    public static final String PROPERTY_STORAGEPOD_TYPE = "type";
    public static final String PROPERTY_STORAGEPOD_CAPACITY = "summary.capacity";
    public static final String PROPERTY_STORAGEPOD_FREE_SPACE = "summary.freeSpace";
    public static final String PROPERTY_DATASTORE_DISPLAY_NAME = "summary.name";
    public static final String PROPERTY_DATASTORE_TYPE = "specificType";
    public static final String PROPERTY_DATASTORE_CAPACITY = "summary.capacity";
    public static final String PROPERTY_DATASTORE_FREE_SPACE = "summary.freeSpace";
    public static final String PROPERTY_DATASTORE_ALIAS_OF = "info.aliasOf";
    public static final String PROPERTY_DATASTORE_CONTAINER_ID = "info.containerId";
    public static final String PROPERTY_DATACENTER_DISPLAY_NAME = "name";
    private static final String PROPERTY_SPBM_COMPATIBILITY_RESULTS_FOR_PROFILE = "spbmCompatibleResultsForProfile";
    private static final String PROPERTY_SPBM_COMPATIBILITY_RESULTS_FOR_CREATE_SPEC = "spbmCompatibilityResultsForCreateSpec";
    private static final String[] SYSTEM_READ_PRIVILEGE = new String[]{"System.Read"};
    public static final String LOCALICATION_KEY_UNKNOWN_DATACENTER_NAME = "datacenter.UnknownName";
    private static final String VM_TYPE = ServerObjectRef.ObjectType.virtualMachine.toString();
    private static final String VIRTUAL_DISK_ID_TYPE = ServerObjectRef.ObjectType.virtualDiskId.toString();
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;
    private final QueryService _queryService;
    private final PbmServiceFactory _pbmServiceFactory;
    private final ThrowableSerializer _throwableSerializer;
    private static final Log _logger = LogFactory.getLog(ProfilePropertyProvider.class);

    public ProfilePropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, QueryServiceFactory queryServiceFactory, PbmServiceFactory pbmServiceFactory, ThrowableSerializer throwableSerializer) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._queryService = queryServiceFactory.getQueryService();
        this._pbmServiceFactory = pbmServiceFactory;
        this._throwableSerializer = throwableSerializer;
    }

    @ModelMetadata(type={"PbmRequirementStorageProfile"}, propertyNamespace="storagePolicy", property="profileStorageContainersCompatibility")
    public StorageProfileContainerCompatibilityData getProfileStorageContainersCompatibility(URI storageProfile) throws Exception {
        Map<ManagedObjectReference, SpbmCompatibilityResult> spbmCompatibilityResponseMap = this.requestSpbmCompatibilityForProfile(storageProfile);
        return this.getProfileContainerCompatibilityData(spbmCompatibilityResponseMap);
    }

    @ModelMetadata(type={"Folder"}, propertyNamespace="storagePolicy", property="createSpecStorageContainersCompatibility")
    public StorageProfileContainerCompatibilityData getCreateSpecStorageContainersCompatibility(ManagedObjectReference vcRef, CapabilityBasedProfileCreateSpec spec) throws Exception {
        Map<ManagedObjectReference, SpbmCompatibilityResult> spbmCompatibilityResponseMap = this.requestSpbmCompatibilityForCreateSpec(vcRef, spec);
        return this.getProfileContainerCompatibilityData(spbmCompatibilityResponseMap);
    }

    @ModelMetadata(type={"PbmRequirementStorageProfile"}, propertyNamespace="storagePolicy", property="numberOfAssociatedVms")
    public int getNumberOfAssociatedVms(URI storageProfile) throws Exception {
        return this.getNumberVmsInUse(storageProfile);
    }

    private void filterOutManagedObjectsWithNoPrivilege(String[] desiredPrivilegeIds, Collection<ManagedObjectReference> mors) {
        Map grantedPrivilegesResponse = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, mors, (String[])new String[]{"grantedPrivileges"});
        Iterator<ManagedObjectReference> morIterator = mors.iterator();
        while (morIterator.hasNext()) {
            ManagedObjectReference mor = morIterator.next();
            String[] grantedPrivileges = (String[])((Map)grantedPrivilegesResponse.get(mor)).get("grantedPrivileges");
            if (AuthorizationUtil.isPrivilegeGranted((String[])desiredPrivilegeIds, (String[])grantedPrivileges)) continue;
            morIterator.remove();
        }
    }

    private Set<ManagedObjectReference> extractDatacenters(Map<ManagedObjectReference, Map<String, Object>> datastoresProperties, Map<ManagedObjectReference, Map<String, Object>> storagePodsProperties) {
        HashSet<ManagedObjectReference> datacenters = new HashSet<ManagedObjectReference>();
        for (Map<String, Object> storagePodProperties : storagePodsProperties.values()) {
            if (!storagePodProperties.containsKey(PROPERTY_DATACENTER) || storagePodProperties.get(PROPERTY_DATACENTER) == null) continue;
            datacenters.add((ManagedObjectReference)storagePodProperties.get(PROPERTY_DATACENTER));
        }
        for (Map<String, Object> datastoreProperties : datastoresProperties.values()) {
            if (!datastoreProperties.containsKey(PROPERTY_DATACENTER) || datastoreProperties.get(PROPERTY_DATACENTER) == null) continue;
            datacenters.add((ManagedObjectReference)datastoreProperties.get(PROPERTY_DATACENTER));
        }
        return datacenters;
    }

    private void extractDatastoresAndStoragePodsFromSpbmCompatibilityResponse(Map<ManagedObjectReference, SpbmCompatibilityResult> spbmCompatibilityResponseMap, Set<ManagedObjectReference> datastores, Set<ManagedObjectReference> storagePods) {
        for (SpbmCompatibilityResult spbmCompatibilityResult : spbmCompatibilityResponseMap.values()) {
            if (Datastore.class.getSimpleName().equals(spbmCompatibilityResult.storageContainer.getType())) {
                datastores.add(spbmCompatibilityResult.storageContainer);
                continue;
            }
            if (StoragePod.class.getSimpleName().equals(spbmCompatibilityResult.storageContainer.getType())) {
                storagePods.add(spbmCompatibilityResult.storageContainer);
                continue;
            }
            _logger.warn((Object)String.format("Propety %s returned Managed Object Reference %s. But expected to return either Datastore or StoragePod", PROPERTY_SPBM_COMPATIBILITY_RESULTS_FOR_PROFILE, spbmCompatibilityResult.storageContainer));
        }
    }

    private StorageProfileContainerCompatibilityData buildStorageProfileContainerCompatibilityData(Map<ManagedObjectReference, SpbmCompatibilityResult> storageContainerToCompatibilityMap, Map<ManagedObjectReference, Map<String, Object>> storagePodsProperties, Map<ManagedObjectReference, Map<String, Object>> datastoresProperties, Map<ManagedObjectReference, Map<String, Object>> dcProperties) {
        StorageProfileContainerCompatibilityData result = new StorageProfileContainerCompatibilityData();
        HashMap<ManagedObjectReference, StorageProfileContainerCompatibilityData.StoragePodContainerCompatibilityInfo> storagePodCompatibilities = new HashMap<ManagedObjectReference, StorageProfileContainerCompatibilityData.StoragePodContainerCompatibilityInfo>();
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> storagePodPropeties : storagePodsProperties.entrySet()) {
            if (!storageContainerToCompatibilityMap.containsKey(storagePodPropeties.getKey())) continue;
            StorageProfileContainerCompatibilityData.StoragePodContainerCompatibilityInfo storagePodCompatibility = this.buildStoragePodCompatibilityItem(storageContainerToCompatibilityMap, dcProperties, storagePodPropeties);
            storagePodCompatibilities.put(storagePodCompatibility.mor, storagePodCompatibility);
            result.storagePodCompatibility.add(storagePodCompatibility);
            if (storagePodCompatibility.capacityInBytes == null || storagePodCompatibility.freeSpaceBytes == null) continue;
            if (storagePodCompatibility.isCompatibile) {
                result.totalCompatibleCapacityInBytes += storagePodCompatibility.capacityInBytes.longValue();
                result.freeCompatibleCapacityInBytes += storagePodCompatibility.freeSpaceBytes.longValue();
                continue;
            }
            result.totalIncompatibleCapacityInBytes += storagePodCompatibility.capacityInBytes.longValue();
            result.freeIncompatibleCapacityInBytes += storagePodCompatibility.freeSpaceBytes.longValue();
        }
        HashSet<String> compatibleContainers = new HashSet<String>();
        HashSet<String> incompatibleContainers = new HashSet<String>();
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> datastorePropeties : datastoresProperties.entrySet()) {
            ManagedObjectReference datastoreMor = datastorePropeties.getKey();
            ManagedObjectReference datacenterMor = (ManagedObjectReference)datastorePropeties.getValue().get(PROPERTY_DATACENTER);
            ManagedObjectReference datastoreParent = (ManagedObjectReference)datastorePropeties.getValue().get(PROPERTY_PARENT);
            boolean isPartOfStoragePod = false;
            if (datastoreParent != null) {
                isPartOfStoragePod = StoragePod.class.getSimpleName().equals(datastoreParent.getType());
            }
            if (isPartOfStoragePod && !storagePodsProperties.containsKey(datastoreParent)) continue;
            StorageProfileContainerCompatibilityData.StorageContainerCompatibilityInfo datastoreCompatibility = this.buildDatastoreCompatibilityItem(storageContainerToCompatibilityMap, storagePodsProperties, dcProperties, datastorePropeties, datastoreMor, datacenterMor, datastoreParent, isPartOfStoragePod);
            if (!isPartOfStoragePod || !storagePodCompatibilities.containsKey(datastoreParent)) {
                if (datastoreCompatibility.capacityInBytes != null && datastoreCompatibility.freeSpaceBytes != null) {
                    String containerId = null;
                    containerId = (String)datastorePropeties.getValue().get(PROPERTY_DATASTORE_ALIAS_OF);
                    if (StringUtil.isNullOrEmpty((String)containerId)) {
                        containerId = (String)datastorePropeties.getValue().get(PROPERTY_DATASTORE_CONTAINER_ID);
                    }
                    if (datastoreCompatibility.isCompatibile) {
                        if (!compatibleContainers.contains(containerId)) {
                            if (!StringUtil.isNullOrEmpty((String)containerId)) {
                                compatibleContainers.add(containerId);
                            }
                            result.totalCompatibleCapacityInBytes += datastoreCompatibility.capacityInBytes.longValue();
                            result.freeCompatibleCapacityInBytes += datastoreCompatibility.freeSpaceBytes.longValue();
                        }
                    } else if (!incompatibleContainers.contains(containerId)) {
                        if (!StringUtil.isNullOrEmpty((String)containerId)) {
                            incompatibleContainers.add(containerId);
                        }
                        result.totalIncompatibleCapacityInBytes += datastoreCompatibility.capacityInBytes.longValue();
                        result.freeIncompatibleCapacityInBytes += datastoreCompatibility.freeSpaceBytes.longValue();
                    }
                }
                result.standaloneDatastoreCompatibility.add(datastoreCompatibility);
                continue;
            }
            ((StorageProfileContainerCompatibilityData.StoragePodContainerCompatibilityInfo)storagePodCompatibilities.get((Object)datastoreCompatibility.podMor)).datastoreCompatibility.add(datastoreCompatibility);
        }
        return result;
    }

    private StorageProfileContainerCompatibilityData.StorageContainerCompatibilityInfo buildDatastoreCompatibilityItem(Map<ManagedObjectReference, SpbmCompatibilityResult> storageContainerToCompatibilityMap, Map<ManagedObjectReference, Map<String, Object>> storagePodsProperties, Map<ManagedObjectReference, Map<String, Object>> dcProperties, Map.Entry<ManagedObjectReference, Map<String, Object>> datastorePropeties, ManagedObjectReference datastoreMor, ManagedObjectReference datacenterMor, ManagedObjectReference datastoreParent, boolean isPartOfStoragePod) {
        StorageProfileContainerCompatibilityData.StorageContainerCompatibilityInfo datastoreCompatibility = new StorageProfileContainerCompatibilityData.StorageContainerCompatibilityInfo();
        datastoreCompatibility.mor = datastoreMor;
        datastoreCompatibility.displayName = (String)datastorePropeties.getValue().get("summary.name");
        datastoreCompatibility.datacenterDisplayName = dcProperties.containsKey(datacenterMor) ? (String)dcProperties.get(datacenterMor).get(PROPERTY_DATACENTER_DISPLAY_NAME) : SpbmStringUtil.getString(LOCALICATION_KEY_UNKNOWN_DATACENTER_NAME);
        datastoreCompatibility.formattedType = StorageUtil.localizeDatastoreSpecificType((String)((String)datastorePropeties.getValue().get(PROPERTY_DATASTORE_TYPE)));
        datastoreCompatibility.capacityInBytes = (Long)datastorePropeties.getValue().get("summary.capacity");
        datastoreCompatibility.freeSpaceBytes = (Long)datastorePropeties.getValue().get("summary.freeSpace");
        SpbmCompatibilityResult compatibility = storageContainerToCompatibilityMap.get(datastoreMor);
        boolean isParentCompatible = true;
        if (isPartOfStoragePod) {
            SpbmCompatibilityResult storagePodCompatibility;
            datastoreCompatibility.podMor = datastoreParent;
            if (storagePodsProperties.containsKey(datastoreParent)) {
                Map<String, Object> podProperties = storagePodsProperties.get(datastoreParent);
                datastoreCompatibility.podDisplayName = (String)podProperties.get("summary.name");
            }
            isParentCompatible = (storagePodCompatibility = storageContainerToCompatibilityMap.get(datastoreParent)) == null || storagePodCompatibility.compatibilityErrors == null || storagePodCompatibility.compatibilityErrors.length == 0;
        }
        boolean hasErrors = compatibility.compatibilityErrors != null && compatibility.compatibilityErrors.length != 0;
        datastoreCompatibility.isCompatibile = !hasErrors && isParentCompatible;
        datastoreCompatibility.errors = this.extractCompatibilityErrorMessages(compatibility.compatibilityErrors);
        datastoreCompatibility.warnings = this.extractCompatibilityErrorMessages(compatibility.compatibilityWarnings);
        return datastoreCompatibility;
    }

    private StorageProfileContainerCompatibilityData.StoragePodContainerCompatibilityInfo buildStoragePodCompatibilityItem(Map<ManagedObjectReference, SpbmCompatibilityResult> storageContainerToCompatibilityMap, Map<ManagedObjectReference, Map<String, Object>> dcProperties, Map.Entry<ManagedObjectReference, Map<String, Object>> storagePodPropeties) {
        ManagedObjectReference storagePodMor = storagePodPropeties.getKey();
        ManagedObjectReference datacenterMor = (ManagedObjectReference)storagePodPropeties.getValue().get(PROPERTY_DATACENTER);
        StorageProfileContainerCompatibilityData.StoragePodContainerCompatibilityInfo storagePodCompatibility = new StorageProfileContainerCompatibilityData.StoragePodContainerCompatibilityInfo();
        storagePodCompatibility.mor = storagePodMor;
        storagePodCompatibility.displayName = (String)storagePodPropeties.getValue().get("summary.name");
        storagePodCompatibility.datacenterDisplayName = dcProperties.containsKey(datacenterMor) ? (String)dcProperties.get(datacenterMor).get(PROPERTY_DATACENTER_DISPLAY_NAME) : SpbmStringUtil.getString(LOCALICATION_KEY_UNKNOWN_DATACENTER_NAME);
        storagePodCompatibility.formattedType = (String)storagePodPropeties.getValue().get(PROPERTY_STORAGEPOD_TYPE);
        storagePodCompatibility.capacityInBytes = (Long)storagePodPropeties.getValue().get("summary.capacity");
        storagePodCompatibility.freeSpaceBytes = (Long)storagePodPropeties.getValue().get("summary.freeSpace");
        SpbmCompatibilityResult compatibility = storageContainerToCompatibilityMap.get(storagePodMor);
        boolean hasErrors = compatibility.compatibilityErrors != null && compatibility.compatibilityErrors.length != 0;
        storagePodCompatibility.isCompatibile = !hasErrors;
        storagePodCompatibility.errors = this.extractCompatibilityErrorMessages(compatibility.compatibilityErrors);
        storagePodCompatibility.warnings = this.extractCompatibilityErrorMessages(compatibility.compatibilityWarnings);
        return storagePodCompatibility;
    }

    private List<String> extractCompatibilityErrorMessages(Exception[] compatibilityErrors) {
        ArrayList<String> result = new ArrayList<String>();
        if (compatibilityErrors != null) {
            for (Exception error : compatibilityErrors) {
                result.add(this.getLocalizedFaultMessage(error));
            }
        }
        return result;
    }

    private String getLocalizedFaultMessage(Exception error) {
        try {
            return this._throwableSerializer.getDetailedFaultMessage((Object)error);
        }
        catch (IOException e) {
            _logger.error((Object)String.format("Failed to localize error message '%s'", e.getMessage()));
            return e.getLocalizedMessage();
        }
    }

    private Map<ManagedObjectReference, SpbmCompatibilityResult> requestSpbmCompatibilityForProfile(URI storageProfile) throws Exception {
        Map compatibilityResultsResponse = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)storageProfile, (String[])new String[]{PROPERTY_SPBM_COMPATIBILITY_RESULTS_FOR_PROFILE});
        HashMap<ManagedObjectReference, SpbmCompatibilityResult> result = new HashMap<ManagedObjectReference, SpbmCompatibilityResult>();
        SpbmCompatibilityResult[] compatibilityResults = (SpbmCompatibilityResult[])compatibilityResultsResponse.get(PROPERTY_SPBM_COMPATIBILITY_RESULTS_FOR_PROFILE);
        if (compatibilityResults != null) {
            for (SpbmCompatibilityResult compatibilityResult : compatibilityResults) {
                result.put(compatibilityResult.storageContainer, compatibilityResult);
            }
        } else {
            _logger.warn((Object)String.format("Failed to determine storage container compatibility. Propety %s for storage profile %s is null.", PROPERTY_SPBM_COMPATIBILITY_RESULTS_FOR_PROFILE, storageProfile));
        }
        return result;
    }

    private Map<ManagedObjectReference, SpbmCompatibilityResult> requestSpbmCompatibilityForCreateSpec(ManagedObjectReference vcRef, CapabilityBasedProfileCreateSpec spec) throws Exception {
        SpbmCompatibilityResult[] compatibilityResults = (SpbmCompatibilityResult[])QueryExecutorUtil.requestPropertyWithParam((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)vcRef, (String)PROPERTY_SPBM_COMPATIBILITY_RESULTS_FOR_CREATE_SPEC, (Object)spec);
        HashMap<ManagedObjectReference, SpbmCompatibilityResult> result = new HashMap<ManagedObjectReference, SpbmCompatibilityResult>();
        if (compatibilityResults != null) {
            for (SpbmCompatibilityResult compatibilityResult : compatibilityResults) {
                result.put(compatibilityResult.storageContainer, compatibilityResult);
            }
        } else {
            _logger.warn((Object)String.format("Failed to determine storage container compatibility. Propety %s for create spec %s is null.", PROPERTY_SPBM_COMPATIBILITY_RESULTS_FOR_CREATE_SPEC, spec));
        }
        return result;
    }

    private StorageProfileContainerCompatibilityData getProfileContainerCompatibilityData(Map<ManagedObjectReference, SpbmCompatibilityResult> spbmCompatibilityResponseMap) {
        StorageProfileContainerCompatibilityData result = new StorageProfileContainerCompatibilityData();
        if (spbmCompatibilityResponseMap == null) {
            return result;
        }
        HashSet<ManagedObjectReference> datastores = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> storagePods = new HashSet<ManagedObjectReference>();
        this.extractDatastoresAndStoragePodsFromSpbmCompatibilityResponse(spbmCompatibilityResponseMap, datastores, storagePods);
        this.filterOutManagedObjectsWithNoPrivilege(SYSTEM_READ_PRIVILEGE, datastores);
        Map datastoresProperties = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, datastores, (String[])new String[]{"summary.name", PROPERTY_DATASTORE_TYPE, "summary.capacity", "summary.freeSpace", PROPERTY_DATASTORE_ALIAS_OF, PROPERTY_DATASTORE_CONTAINER_ID, PROPERTY_DATACENTER, PROPERTY_PARENT});
        for (Map dsProps : datastoresProperties.values()) {
            if (dsProps == null || !(dsProps.get(PROPERTY_PARENT) instanceof ManagedObjectReference)) continue;
            ManagedObjectReference parentRef = (ManagedObjectReference)dsProps.get(PROPERTY_PARENT);
            if (!StoragePod.class.getSimpleName().equals(parentRef.getType())) continue;
            storagePods.add(parentRef);
        }
        this.filterOutManagedObjectsWithNoPrivilege(SYSTEM_READ_PRIVILEGE, storagePods);
        Map storagePodsProperties = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, storagePods, (String[])new String[]{"summary.name", PROPERTY_STORAGEPOD_TYPE, "summary.capacity", "summary.freeSpace", PROPERTY_DATACENTER});
        Set<ManagedObjectReference> datacenters = this.extractDatacenters(datastoresProperties, storagePodsProperties);
        this.filterOutManagedObjectsWithNoPrivilege(SYSTEM_READ_PRIVILEGE, datacenters);
        Map dcProperties = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, datacenters, (String[])new String[]{PROPERTY_DATACENTER_DISPLAY_NAME});
        result = this.buildStorageProfileContainerCompatibilityData(spbmCompatibilityResponseMap, storagePodsProperties, datastoresProperties, dcProperties);
        return result;
    }

    public int getNumberVmsInUse(URI profileUri) throws Exception {
        String vcServiceGuid = ManagedUtil.getVcGuid((URI)profileUri);
        PbmService pbmService = PbmSessionUtil.getService((String)vcServiceGuid, (PbmServiceFactory)this._pbmServiceFactory);
        ProfileId profileId = ManagedUtil.uriToProfileId((URI)profileUri);
        HashSet<ManagedObjectReference> associatedServerObj = new HashSet<ManagedObjectReference>();
        ProfileManager profileManager = pbmService.getProfileManager();
        ServerObjectRef[] associatedSoRefs = profileManager.queryAssociatedEntity(profileId, null);
        if (associatedSoRefs == null) {
            return 0;
        }
        for (ServerObjectRef associatedSoRef : associatedSoRefs) {
            ManagedObjectReference vmRef = ManagedUtil.serverObjectRefToVmMor((ServerObjectRef)associatedSoRef, (String)vcServiceGuid);
            if (vmRef == null) continue;
            associatedServerObj.add(vmRef);
        }
        return associatedServerObj.size();
    }
}

