/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.spbm.util.SpbmPrivilegeUtil;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SpbmActionResolverPropertyProvider {
    private static final String VIEW_PRIVILEGE = "StorageProfile.View";
    private static final String UPDATE_PRIVILEGE = "StorageProfile.Update";
    private static final String GRANTED_PRIVILEGES = "grantedPrivileges";
    private static final String[] UPDATE_PRIVILEGE_ARR = new String[]{"StorageProfile.Update"};
    private QueryService _queryService;

    public SpbmActionResolverPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="Datastore/isDrpEditAvailable")
    public Boolean getIsDrpEditAvailable(ManagedObjectReference dsRef) {
        return SpbmPrivilegeUtil.hasRequiredPrivileges(this._queryService, Arrays.asList(dsRef), VIEW_PRIVILEGE, UPDATE_PRIVILEGE).get(0);
    }

    @PropertyProvider(value="Datastore/isFcdNamespaceProfileEditAvailable")
    public Boolean getIsFcdNamespaceProfileEditAvailable(ManagedObjectReference dsRef) throws Exception {
        return SpbmPrivilegeUtil.hasRequiredPrivileges(this._queryService, Arrays.asList(dsRef), VIEW_PRIVILEGE).get(0);
    }

    @PropertyProvider(value="PbmDataServiceStorageProfile/hasSpbmUpdatePrivilegeOnVc")
    public List<Boolean> getHasSpbmUpdatePrivilegeOnVcDsp(Collection<URI> profileUris) {
        return this.hasSpbmUpdatePrivilegeOnVcInternal(profileUris);
    }

    @PropertyProvider(value="PbmRequirementStorageProfile/hasSpbmUpdatePrivilegeOnVc")
    public List<Boolean> getHasSpbmUpdatePrivilegeOnVc(Collection<URI> profileUris) {
        return this.hasSpbmUpdatePrivilegeOnVcInternal(profileUris);
    }

    @DerivedProperty(value="VirtualMachine/isComplianceActionAvailable")
    public static boolean getIsComplianceActionAvailable(@SourceProperty(value="VirtualMachine/vcGrantedPrivileges") String[] vcGrantedPrivileges) {
        boolean hasViewAndUpdatePrivilegesGrantedOnVc = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{VIEW_PRIVILEGE, UPDATE_PRIVILEGE}, (String[])vcGrantedPrivileges);
        return hasViewAndUpdatePrivilegesGrantedOnVc;
    }

    private List<Boolean> hasSpbmUpdatePrivilegeOnVcInternal(Collection<URI> profileUris) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        if (profileUris == null || profileUris.isEmpty()) {
            return result;
        }
        HashMap<URI, ManagedObjectReference> profileVcs = new HashMap<URI, ManagedObjectReference>(profileUris.size());
        HashSet<ManagedObjectReference> vcRefs = new HashSet<ManagedObjectReference>();
        for (URI profileUri : profileUris) {
            ManagedObjectReference vcRef = ManagedObjectUtil.getRootFolder((String)ManagedUtil.getVcGuid((URI)profileUri));
            profileVcs.put(profileUri, vcRef);
            vcRefs.add(vcRef);
        }
        Map vcsPrivileges = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, vcRefs, (String[])new String[]{GRANTED_PRIVILEGES});
        for (URI profileUri : profileUris) {
            ManagedObjectReference vcRef = (ManagedObjectReference)profileVcs.get(profileUri);
            String[] grantedPrivileges = (String[])((Map)vcsPrivileges.get(vcRef)).get(GRANTED_PRIVILEGES);
            result.add(AuthorizationUtil.isPrivilegeGranted((String[])UPDATE_PRIVILEGE_ARR, (String[])grantedPrivileges));
        }
        return result;
    }
}

