/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.impl;

import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.vm.DefinedProfileSpec;
import com.vmware.vim.binding.vim.vm.ProfileSpec;
import com.vmware.vim.binding.vim.vslm.InfrastructureObjectPolicySpec;
import com.vmware.vim.binding.vim.vslm.vcenter.VStorageObjectManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.h5.spbm.spec.UpdateFcdNamespaceProfileSpec;
import com.vmware.vsphere.client.h5.spbm.util.VStorageObjectManagerUtil;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpbmMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(SpbmMutationProvider.class);
    private final PbmServiceFactory _pbmServiceFactory;
    private final TaskMonitor _taskMonitor;

    public SpbmMutationProvider(PbmServiceFactory pbmServiceFactory, TaskMonitor taskMonitor) {
        this._pbmServiceFactory = pbmServiceFactory;
        this._taskMonitor = taskMonitor;
    }

    public OperationResult apply(ManagedObjectReference dsRef, UpdateFcdNamespaceProfileSpec spec) {
        OperationResult result = new OperationResult();
        if (spec.profileId == null) {
            _logger.error((Object)"Invalid arguments for updating FCD namespace profile.");
            return result;
        }
        result.entity = dsRef;
        try {
            VStorageObjectManager vStorageObjectManager = VStorageObjectManagerUtil.getVStorageObjectManager(dsRef.getServerGuid());
            if (vStorageObjectManager != null) {
                InfrastructureObjectPolicySpec policySpec = new InfrastructureObjectPolicySpec();
                policySpec.datastore = dsRef;
                DefinedProfileSpec definedProfileSpec = new DefinedProfileSpec();
                definedProfileSpec.profileId = spec.profileId.uniqueId;
                policySpec.profile = new ProfileSpec[]{definedProfileSpec};
                ManagedObjectReference updateProfileTask = vStorageObjectManager.updateVStorageInfrastructureObjectPolicy(policySpec);
                if (updateProfileTask != null) {
                    TaskInfo taskInfo = this._taskMonitor.monitorTask(updateProfileTask);
                    if (taskInfo.error != null) {
                        throw taskInfo.error;
                    }
                }
            } else {
                _logger.error((Object)("Failed to retrieve VStorageObjectManager for VC " + dsRef.getServerGuid()));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to update FCD namespace profile.", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }
}

