/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpbmPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String VC_GRANTED_PRIVILEGES = "vcGrantedPrivileges";
    private static final String PROFILE_MISMATCH = "vmSpbmProfileMismatch";
    private static final String MANAGE_VM_PROFILE = "isManageVmStorageProfilesActionAvailable";
    private static final String REAPPLY_VM_PROFILE = "isReapplyActionAvailable";
    private static final String VIEW_PRIVILEGE = "StorageProfile.View";
    private static final String UPDATE_PRIVILEGE = "StorageProfile.Update";
    private static final String[] REQUIRED_PRIVILEGES = new String[]{"StorageProfile.View", "StorageProfile.Update"};
    private QueryService _queryService;
    private static final Log _logger = LogFactory.getLog(SpbmPropertyProviderAdapter.class);

    public SpbmPropertyProviderAdapter(DataServiceExtensionRegistry registry, QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = VirtualMachine.class.getSimpleName();
        ti.properties = new String[]{MANAGE_VM_PROFILE, REAPPLY_VM_PROFILE};
        ti.derivedProperties = new DerivedPropertyInfo[]{SpbmPropertyProviderAdapter.newDerivedPropertyInfo(MANAGE_VM_PROFILE, new String[]{VC_GRANTED_PRIVILEGES}), SpbmPropertyProviderAdapter.newDerivedPropertyInfo(REAPPLY_VM_PROFILE, new String[]{VC_GRANTED_PRIVILEGES})};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        HashSet<String> reqPropSet = new HashSet<String>();
        for (PropertySpec propSpec : properties) {
            for (String propName : propSpec.propertyNames) {
                reqPropSet.add(propName);
            }
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        boolean areOnDistinctVcs = this.areOnDistinctVcs(objects);
        Map<ManagedObjectReference, Boolean> reapplyActionAvailabilityMap = null;
        if (reqPropSet.contains(REAPPLY_VM_PROFILE)) {
            reapplyActionAvailabilityMap = this.computeReapplyActionAvailability(sourcePropertyValues);
        }
        for (Object obj : objects) {
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(obj);
            if (sourcePropertyValuesMap == null) continue;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = obj;
            resultItem.properties = this.computePropertyValues(reqPropSet, sourcePropertyValuesMap, obj, areOnDistinctVcs, reapplyActionAvailabilityMap);
            resultItems.add(resultItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private PropertyValue[] computePropertyValues(Set<String> reqProps, Map<String, Object> propertyValuesMap, Object resourceObject, boolean onDistinctVcs, Map<ManagedObjectReference, Boolean> reapplyActionAvailabilityMap) {
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (reqProps.contains(MANAGE_VM_PROFILE)) {
            this.processManage(propertyValuesMap, result, resourceObject, onDistinctVcs);
        }
        if (reqProps.contains(REAPPLY_VM_PROFILE)) {
            this.processReapply(result, resourceObject, reapplyActionAvailabilityMap);
        }
        return result.toArray(new PropertyValue[result.size()]);
    }

    private void processManage(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject, boolean onDistinctVcs) {
        if (onDistinctVcs) {
            propValues.add(this.createPropValue(MANAGE_VM_PROFILE, false, resourceObject));
        } else {
            String[] vcPrivileges = (String[])propertyValuesMap.get(VC_GRANTED_PRIVILEGES);
            boolean propResult = AuthorizationUtil.isPrivilegeGranted((String[])REQUIRED_PRIVILEGES, (String[])vcPrivileges);
            propValues.add(this.createPropValue(MANAGE_VM_PROFILE, propResult, resourceObject));
        }
    }

    private void processReapply(ArrayList<PropertyValue> propValues, Object resourceObject, Map<ManagedObjectReference, Boolean> reapplyActionAvailabilityMap) {
        boolean isActionAvailable = Boolean.TRUE.equals(reapplyActionAvailabilityMap.get((ManagedObjectReference)resourceObject));
        propValues.add(this.createPropValue(REAPPLY_VM_PROFILE, isActionAvailable, resourceObject));
    }

    private Map<ManagedObjectReference, Boolean> computeReapplyActionAvailability(Map<Object, Map<String, Object>> sourcePropertyValues) {
        Map<ManagedObjectReference, Map<String, Object>> vmsMismatch;
        HashMap<ManagedObjectReference, Boolean> result = new HashMap<ManagedObjectReference, Boolean>(sourcePropertyValues.size());
        boolean arePrivilegesGranted = true;
        for (Map.Entry<Object, Map<String, Object>> sourcePropertyValue : sourcePropertyValues.entrySet()) {
            String[] vcPrivileges = (String[])sourcePropertyValue.getValue().get(VC_GRANTED_PRIVILEGES);
            arePrivilegesGranted = arePrivilegesGranted && AuthorizationUtil.isPrivilegeGranted((String[])REQUIRED_PRIVILEGES, (String[])vcPrivileges);
            result.put((ManagedObjectReference)sourcePropertyValue.getKey(), false);
        }
        if (arePrivilegesGranted && (vmsMismatch = this.retrieveVmsMismatch(result.keySet())) != null) {
            for (Map.Entry<ManagedObjectReference, Map<String, Object>> entry : vmsMismatch.entrySet()) {
                Boolean isOutOfDate = (Boolean)entry.getValue().get(PROFILE_MISMATCH);
                result.put(entry.getKey(), isOutOfDate);
            }
        }
        return result;
    }

    private Map<ManagedObjectReference, Map<String, Object>> retrieveVmsMismatch(Set<ManagedObjectReference> vms) {
        try {
            return QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, vms, (String[])new String[]{PROFILE_MISMATCH});
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Failed to retrieve \"%s\" property", PROFILE_MISMATCH), (Throwable)e);
            return null;
        }
    }

    private static DerivedPropertyInfo newDerivedPropertyInfo(String propertyName, String[] sourcePropertyNames) {
        DerivedPropertyInfo derivedPropertyInfo = new DerivedPropertyInfo();
        derivedPropertyInfo.propertyName = propertyName;
        derivedPropertyInfo.sourcePropertyNames = sourcePropertyNames;
        return derivedPropertyInfo;
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private boolean areOnDistinctVcs(Object[] vms) {
        HashSet<ManagedObjectReference> vmVcs = new HashSet<ManagedObjectReference>();
        for (Object vm : vms) {
            ManagedObjectReference vmRef = (ManagedObjectReference)vm;
            vmVcs.add(ManagedObjectUtil.getRootFolder((String)vmRef.getServerGuid()));
        }
        return vmVcs.size() > 1;
    }
}

