/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.util;

import com.vmware.cis.data.api.QueryService;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SpbmPrivilegeUtil {
    public static List<Boolean> hasRequiredPrivileges(QueryService _queryService, Collection<ManagedObjectReference> vmRefs, String ... privileges) {
        HashSet<ManagedObjectReference> vmVcs = new HashSet<ManagedObjectReference>();
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (ManagedObjectReference vmRef : vmRefs) {
            ManagedObjectReference vcRef = ManagedObjectUtil.getRootFolder((String)vmRef.getServerGuid());
            vmVcs.add(vcRef);
        }
        try {
            Map vcPrivilieges = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)_queryService, vmVcs, (String[])new String[]{"grantedPrivileges"});
            for (ManagedObjectReference vmRef : vmRefs) {
                ManagedObjectReference vcRef = ManagedObjectUtil.getRootFolder((String)vmRef.getServerGuid());
                String[] allPrivileges = (String[])((Map)vcPrivilieges.get(vcRef)).get("grantedPrivileges");
                boolean hasAllRequiredPrivileges = AuthorizationUtil.isPrivilegeGranted((String[])privileges, (String[])allPrivileges);
                result.add(hasAllRequiredPrivileges);
            }
            return result;
        }
        catch (Exception e) {
            return SpbmPrivilegeUtil.getFalseList(vmRefs);
        }
    }

    private static List<Boolean> getFalseList(Collection<ManagedObjectReference> vmRefs) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (int i = 0; i < vmRefs.size(); ++i) {
            result.add(false);
        }
        return result;
    }
}

