/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.codecapture;

import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.vim.interceptors.CodeCaptureService;
import com.vmware.vise.vim.interceptors.record.ServiceInfo;
import com.vmware.vsphere.client.h5.codecapture.CodeCaptureRecordingService;
import java.util.ArrayList;
import java.util.List;

public class CodeCaptureRecordingServiceImpl
implements CodeCaptureRecordingService {
    private final UserSessionService _userSessionService;
    private final CodeCaptureService _codeCaptureService;

    public CodeCaptureRecordingServiceImpl(UserSessionService userSessionService, CodeCaptureService codeCaptureService) {
        this._userSessionService = userSessionService;
        this._codeCaptureService = codeCaptureService;
    }

    @Override
    public boolean startRecording(String clientId) {
        if (this.isRecordingInProgress(clientId)) {
            return false;
        }
        return this._codeCaptureService.start(clientId, this.getServiceInfos());
    }

    @Override
    public boolean stopRecording(String clientId) {
        if (!this.isRecordingInProgress(clientId)) {
            return true;
        }
        return this._codeCaptureService.stop(clientId);
    }

    @Override
    public boolean isRecordingInProgress(String clientId) {
        return this._codeCaptureService.isInProgress(clientId);
    }

    @Override
    public String getRecordedData(String clientId) {
        return this._codeCaptureService.retrieveRecordedData(clientId);
    }

    private List<ServiceInfo> getServiceInfos() {
        ServerInfo[] serverInfos;
        UserSession userSession = this._userSessionService.getUserSession();
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();
        if (userSession != null && (serverInfos = userSession.serversInfo) != null) {
            for (ServerInfo info : serverInfos) {
                if (info.sessionCookie == null || info.serviceGuid == null) continue;
                ServiceInfo serviceInfo = new ServiceInfo();
                serviceInfo.serviceSessionCookie = info.sessionCookie;
                serviceInfo.serviceName = info.name;
                serviceInfo.serviceGuid = info.serviceGuid;
                serviceInfos.add(serviceInfo);
            }
        }
        return serviceInfos;
    }
}

