/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.impl;

import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.provisioning.storage.StoragePolicyNameParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DsClusterListPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(DsClusterListPropertyProviderAdapter.class);
    private static final String DSCLUSTER_STORAGE_POLICY_NAME = "storagePolicyName";

    public DsClusterListPropertyProviderAdapter() {
        _logger.info((Object)"instantiated");
    }

    public void setRegistry(DataServiceExtensionRegistry registry) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = StoragePod.class.getSimpleName();
        ti.properties = new String[]{DSCLUSTER_STORAGE_POLICY_NAME};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        HashSet<String> reqPropSet = new HashSet<String>();
        ArrayList<ParameterSpec> params = new ArrayList<ParameterSpec>();
        for (PropertySpec propSpec : properties) {
            for (String propName : propSpec.propertyNames) {
                reqPropSet.add(propName);
            }
            if (ArrayUtil.isNullOrEmpty((Object[])propSpec.parameters)) continue;
            params.addAll(Arrays.asList(propSpec.parameters));
        }
        ResultSet resultSet = new ResultSet();
        ResultItem[] items = new ResultItem[objects.length];
        for (int index = 0; index < items.length; ++index) {
            ResultItem resItem = new ResultItem();
            resItem.resourceObject = objects[index];
            PropertyValue[] computedValues = this.processResultSet(reqPropSet, resItem, params);
            items[index] = resItem;
            resItem.properties = computedValues;
        }
        resultSet.items = items;
        return resultSet;
    }

    private PropertyValue[] processResultSet(Set<String> reqProps, ResultItem ri, List<ParameterSpec> params) {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>();
        if (this.shouldFetchStoragePolicyName(reqProps, params)) {
            this.processStoragePolicyName(ri, results, params);
        }
        return results.toArray(new PropertyValue[results.size()]);
    }

    private void processStoragePolicyName(ResultItem ri, ArrayList<PropertyValue> propValues, List<ParameterSpec> params) {
        Object[] parameter = this.getParamForProperty(params, DSCLUSTER_STORAGE_POLICY_NAME, StoragePolicyNameParam[].class);
        if (ArrayUtil.isNullOrEmpty((Object[])parameter)) {
            propValues.add(this.createPropValue(DSCLUSTER_STORAGE_POLICY_NAME, null, ri.resourceObject));
            return;
        }
        String uid = QueryUtil.getReferenceUid((Object)ri.resourceObject);
        for (Object param : parameter) {
            String paramObjectUid = QueryUtil.getReferenceUid((Object)((StoragePolicyNameParam)param).storage);
            if (!uid.equals(paramObjectUid)) continue;
            propValues.add(this.createPropValue(DSCLUSTER_STORAGE_POLICY_NAME, ((StoragePolicyNameParam)param).profileNames, ri.resourceObject));
            return;
        }
        propValues.add(this.createPropValue(DSCLUSTER_STORAGE_POLICY_NAME, null, ri.resourceObject));
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private boolean shouldFetchStoragePolicyName(Set<String> reqProps, List<ParameterSpec> params) {
        return reqProps.contains(DSCLUSTER_STORAGE_POLICY_NAME);
    }

    private <T> T getParamForProperty(List<ParameterSpec> params, String propertyName, Class<T> clazz) {
        if (ArrayUtil.isNullOrEmpty(params)) {
            return null;
        }
        Class<?> componentClazz = clazz.isArray() ? clazz.getComponentType() : null;
        for (ParameterSpec param : params) {
            Object[] valueAsArray;
            Object value;
            if (!param.propertyName.equals(propertyName) || (value = param.parameter) == null) continue;
            if (clazz.isInstance(value)) {
                return clazz.cast(value);
            }
            if (componentClazz == null || !value.getClass().isArray() || !componentClazz.isInstance((valueAsArray = (Object[])value)[0])) continue;
            return clazz.cast(ArrayUtil.getTypedArray((Object[])valueAsArray, componentClazz));
        }
        return null;
    }
}

