/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.AntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vsphere.client.drs.model.VmMonitorTargetData;
import com.vmware.vsphere.client.dscluster.model.configuration.SdrsRuleListItemData;
import com.vmware.vsphere.client.dscluster.util.SdrsRulesUtil;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleInfo;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRulesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.LinkedMultiValueMap;

public class DsClusterRulesPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    public static final String SDRS_RULES = "podStorageDrsEntry/storageDrsConfig/podConfig/rule";
    public static final String SDRS_VM_CONFIG = "podStorageDrsEntry/storageDrsConfig/vmConfig";
    static final String COMPUTED_SDRS_RULES = "computedSdrsRules";
    static final String[] VIRTUAL_MACHINES = new String[]{VirtualMachine.class.getSimpleName()};
    private final QueryService _queryService;
    private final QueryBindingService _queryBindingService;

    public DsClusterRulesPropertyProviderAdapter(DataServiceExtensionRegistry registry, QueryService queryService, QueryBindingService queryBindingService) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, DsClusterRulesPropertyProviderAdapter.getTypeInfo());
        this._queryService = queryService;
        this._queryBindingService = queryBindingService;
    }

    private static TypeInfo[] getTypeInfo() {
        DerivedPropertyInfo propInfo = new DerivedPropertyInfo();
        propInfo.propertyName = COMPUTED_SDRS_RULES;
        propInfo.sourcePropertyNames = new String[]{SDRS_RULES, SDRS_VM_CONFIG};
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = StoragePod.class.getSimpleName();
        typeInfo.properties = new String[]{COMPUTED_SDRS_RULES};
        typeInfo.derivedProperties = new DerivedPropertyInfo[]{propInfo};
        return new TypeInfo[]{typeInfo};
    }

    private static ResultItem createResultItem(ManagedObjectReference dsCluster, SdrsRuleListItemData[] value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = COMPUTED_SDRS_RULES;
        propertyValue.value = value;
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = dsCluster;
        resultItem.properties = new PropertyValue[]{propertyValue};
        return resultItem;
    }

    public com.vmware.vise.data.query.ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        DerivedPropertyData derivedData;
        Object[] parameterSpecs = propertyRequest.properties[0].parameters;
        String filterText = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])parameterSpecs)) {
            filterText = (String)((ParameterSpec)parameterSpecs[0]).parameter;
        }
        Map propValues = (derivedData = propertyRequest.derivedPropertyData) != null ? derivedData.getSourcePropertyValuesByObject() : Collections.emptyMap();
        Object[] dsClusters = propertyRequest.objects;
        ResultItem[] resultItems = new ResultItem[dsClusters.length];
        for (int index = 0; index < dsClusters.length; ++index) {
            SdrsRuleListItemData[] value;
            ManagedObjectReference dsCluster = (ManagedObjectReference)dsClusters[index];
            Map sourcePropValues = (Map)propValues.get(dsCluster);
            if (sourcePropValues != null) {
                RuleInfo[] sdrsPodRules = (RuleInfo[])sourcePropValues.get(SDRS_RULES);
                VmConfigInfo[] sdrsVmRules = (VmConfigInfo[])sourcePropValues.get(SDRS_VM_CONFIG);
                value = this.getSdrsRuleListItemsData(dsCluster, filterText, sdrsPodRules, sdrsVmRules);
            } else {
                value = new SdrsRuleListItemData[]{};
            }
            resultItems[index] = DsClusterRulesPropertyProviderAdapter.createResultItem(dsCluster, value);
        }
        com.vmware.vise.data.query.ResultSet result = new com.vmware.vise.data.query.ResultSet();
        result.items = resultItems;
        return result;
    }

    private SdrsRuleListItemData[] getSdrsRuleListItemsData(ManagedObjectReference dsCluster, String filterText, RuleInfo[] sdrsPodRules, VmConfigInfo[] sdrsVmRules) {
        List intraVmAntiAffinityRules;
        if (!StringUtil.isNullOrEmpty((String)filterText)) {
            FilteredRulesData filteredRulesData = this.filterRulesDataByName(filterText, sdrsPodRules, sdrsVmRules);
            sdrsPodRules = filteredRulesData.sdrsPodRules;
            sdrsVmRules = filteredRulesData.sdrsVmRules;
        }
        ArrayList sdrsRuleInfoList = new ArrayList();
        if (sdrsPodRules != null) {
            intraVmAntiAffinityRules = SdrsRulesBuilder.buildVmAntiAffinityRules((ManagedObjectReference)dsCluster, (RuleInfo[])sdrsPodRules);
            sdrsRuleInfoList.addAll(intraVmAntiAffinityRules);
        }
        if (sdrsVmRules != null) {
            intraVmAntiAffinityRules = SdrsRulesBuilder.buildIntraVmAntiAffinityRules((ManagedObjectReference)dsCluster, (VmConfigInfo[])sdrsVmRules);
            sdrsRuleInfoList.addAll(intraVmAntiAffinityRules);
        }
        SdrsRuleInfo[] sdrsRuleInfos = sdrsRuleInfoList.toArray(new SdrsRuleInfo[0]);
        HashSet<ManagedObjectReference> ruleVms = new HashSet<ManagedObjectReference>();
        for (SdrsRuleInfo sdrsRuleInfo : sdrsRuleInfos) {
            if (sdrsRuleInfo.vm == null) continue;
            ruleVms.add(sdrsRuleInfo.vm);
        }
        HashMap<ManagedObjectReference, VmMonitorTargetData> vmsByRef = new HashMap<ManagedObjectReference, VmMonitorTargetData>();
        if (!ruleVms.isEmpty()) {
            Collection vmsResultSet = this._queryBindingService.prepare(VmMonitorTargetData.class).fetch(ruleVms);
            vmsByRef.putAll(SdrsRulesUtil.getVmsMapByRef(vmsResultSet));
        }
        SdrsRuleListItemData[] sdrsRuleListItems = new SdrsRuleListItemData[sdrsRuleInfos.length];
        for (int index = 0; index < sdrsRuleInfos.length; ++index) {
            sdrsRuleListItems[index] = SdrsRulesUtil.createSdrsRuleListItem(sdrsRuleInfos[index], vmsByRef);
        }
        return sdrsRuleListItems;
    }

    private FilteredRulesData filterRulesDataByName(String filterText, RuleInfo[] sdrsPodRules, VmConfigInfo[] sdrsVmRules) {
        LinkedMultiValueMap podRuleMembers = new LinkedMultiValueMap();
        LinkedMultiValueMap vmRuleMembers = new LinkedMultiValueMap();
        HashSet<RuleInfo> filteredRules = new HashSet<RuleInfo>();
        HashSet<RuleInfo> filteredVmRules = new HashSet<RuleInfo>();
        if (sdrsPodRules != null) {
            for (RuleInfo ruleInfo : sdrsPodRules) {
                if (StringUtils.containsIgnoreCase((String)ruleInfo.name, (String)filterText)) {
                    filteredRules.add(ruleInfo);
                    continue;
                }
                if (!(ruleInfo instanceof AntiAffinityRuleSpec)) continue;
                AntiAffinityRuleSpec vmRule = (AntiAffinityRuleSpec)ruleInfo;
                ManagedObjectReference[] vms = vmRule.vm;
                if (vms == null) continue;
                for (ManagedObjectReference vm : vms) {
                    podRuleMembers.add((Object)vm, (Object)ruleInfo);
                }
            }
        }
        if (sdrsVmRules != null) {
            for (RuleInfo ruleInfo : sdrsVmRules) {
                if (ruleInfo.intraVmAntiAffinity != null && StringUtils.containsIgnoreCase((String)ruleInfo.intraVmAntiAffinity.name, (String)filterText)) {
                    filteredVmRules.add(ruleInfo);
                    continue;
                }
                if (ruleInfo.vm == null) continue;
                vmRuleMembers.add((Object)ruleInfo.vm, (Object)ruleInfo);
            }
        }
        if (!podRuleMembers.isEmpty() || !vmRuleMembers.isEmpty()) {
            HashSet<ManagedObjectReference> vmsToFilter = new HashSet<ManagedObjectReference>();
            vmsToFilter.addAll(podRuleMembers.keySet());
            vmsToFilter.addAll(vmRuleMembers.keySet());
            List<ManagedObjectReference> filteredVms = this.filterRuleMembersByName(filterText, vmsToFilter);
            for (ManagedObjectReference managedObjectReference : filteredVms) {
                if (podRuleMembers.containsKey((Object)managedObjectReference)) {
                    filteredRules.addAll((Collection)podRuleMembers.get((Object)managedObjectReference));
                }
                if (!vmRuleMembers.containsKey((Object)managedObjectReference)) continue;
                filteredVmRules.addAll((Collection)vmRuleMembers.get((Object)managedObjectReference));
            }
        }
        FilteredRulesData filterData = new FilteredRulesData();
        filterData.sdrsPodRules = filteredRules.toArray(new RuleInfo[0]);
        filterData.sdrsVmRules = filteredVmRules.toArray(new VmConfigInfo[0]);
        return filterData;
    }

    private List<ManagedObjectReference> filterRuleMembersByName(String filterText, Set<ManagedObjectReference> objects) {
        ResultSet filteredVmsResultSet;
        List resourceItems;
        ArrayList<ManagedObjectReference> filteredObjects = new ArrayList<ManagedObjectReference>();
        if (!CollectionUtil.isNullOrEmpty(objects) && !(resourceItems = (filteredVmsResultSet = this._queryService.select(new String[]{"@modelKey"}).from(VIRTUAL_MACHINES).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, objects), PropertyPredicate.containsIgnoreCase((String)"name", (String)filterText)}).opId("search-sdrs-rules-by-member-names").fetch()).getItems()).isEmpty()) {
            for (ResourceItem vmItem : resourceItems) {
                filteredObjects.add((ManagedObjectReference)vmItem.get("@modelKey"));
            }
        }
        return filteredObjects;
    }

    private final class FilteredRulesData {
        RuleInfo[] sdrsPodRules;
        VmConfigInfo[] sdrsVmRules;

        private FilteredRulesData() {
        }
    }
}

