/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.common.util.ObjectNamesRetriever;
import com.vmware.vsphere.client.dscluster.VmOverrideData;
import com.vmware.vsphere.client.dscluster.util.Util;
import com.vmware.vsphere.client.storagedrs.rules.IntraVmAffinity;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleInfo;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRulesBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DsClusterSerivcePropertyProvider
implements PropertyProviderBean {
    private static final String DATASTORE_TYPE_PROP = "summary.type";
    private static final String DATASTORE_FREE_SPACE_PROP = "summary.freeSpace";
    private static final String DATASTORE_CAPACITY_PROP = "summary.capacity";
    private static final String DATASTORE_RELATION = "datastore";
    private static final String DEFAULT_DS_CLUSTER_NAME = Util.getLocalizedString("dsCluster.defaultName", new String[0]);
    private static final String DS_CLUSTER_TYPE = StoragePod.class.getSimpleName();
    private static final Log _logger = LogFactory.getLog(DsClusterSerivcePropertyProvider.class);
    private DataService _dataService;

    public DsClusterSerivcePropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="StoragePod")
    public String getType(ManagedObjectReference dsClusterRef) throws Exception {
        if (dsClusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        PropertyValue[] types = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)dsClusterRef, (String)DATASTORE_RELATION, (String)Datastore.class.getSimpleName(), (String)DATASTORE_TYPE_PROP);
        if (types == null || types.length == 0) {
            return "";
        }
        return (String)types[0].value;
    }

    @type(value="StoragePod")
    public Long getDsLargestFreeSpace(ManagedObjectReference dsClusterRef) throws Exception {
        if (dsClusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        PropertyValue[] freeSpaces = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)dsClusterRef, (String)DATASTORE_RELATION, (String)Datastore.class.getSimpleName(), (String)DATASTORE_FREE_SPACE_PROP);
        if (freeSpaces == null || freeSpaces.length == 0) {
            return 0L;
        }
        List<PropertyValue> listBridge = Arrays.asList(freeSpaces);
        PropertyValue maxFreeSpace = Collections.max(listBridge, new Comparator<PropertyValue>(){

            @Override
            public int compare(PropertyValue pv1, PropertyValue pv2) {
                if (pv1.value instanceof Long && pv2.value instanceof Long) {
                    return ((Long)pv1.value).compareTo((Long)pv2.value);
                }
                return 0;
            }
        });
        return (Long)maxFreeSpace.value;
    }

    @type(value="StoragePod")
    public Long getSmallestDatastoreCapacityB(ManagedObjectReference dsClusterRef) throws Exception {
        if (dsClusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        PropertyValue[] totalCapacities = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)dsClusterRef, (String)DATASTORE_RELATION, (String)Datastore.class.getSimpleName(), (String)DATASTORE_CAPACITY_PROP);
        if (totalCapacities == null || totalCapacities.length == 0) {
            return 0L;
        }
        List<PropertyValue> listBridge = Arrays.asList(totalCapacities);
        PropertyValue minCapacity = Collections.min(listBridge, new Comparator<PropertyValue>(){

            @Override
            public int compare(PropertyValue pv1, PropertyValue pv2) {
                if (pv1.value instanceof Long && pv2.value instanceof Long) {
                    return ((Long)pv1.value).compareTo((Long)pv2.value);
                }
                return 0;
            }
        });
        return (Long)minCapacity.value;
    }

    @type(value="StoragePod")
    public VmOverrideData[] getVmOverrides(ManagedObjectReference dsClusterRef) throws Exception {
        if (dsClusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        VmOverrideData[] vmOverridesData = null;
        VmConfigInfo[] rawVmConfigInfos = (VmConfigInfo[])QueryUtil.getProperty((DataService)this._dataService, (Object)dsClusterRef, (String)"podStorageDrsEntry.storageDrsConfig.vmConfig");
        VmConfigInfo[] actualVmConfigInfosOverrides = Util.getActualVmOverridesInfos(rawVmConfigInfos);
        if (actualVmConfigInfosOverrides.length > 0) {
            Object[] vmRefs = Util.getVmRefsFromVmConfigInfos(actualVmConfigInfosOverrides);
            PropertyValue[] vmProperties = QueryUtil.getProperties((DataService)this._dataService, (Object[])vmRefs, (String[])new String[]{"name", "ftRole"});
            vmOverridesData = Util.buildVmOverridesData(actualVmConfigInfosOverrides, vmProperties);
        }
        return vmOverridesData;
    }

    @type(value="StoragePod")
    public VmOverrideData.SdrsAutomationLevel getDefaultVmAutomationLevel(ManagedObjectReference dsClusterRef) throws Exception {
        if (dsClusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        VmOverrideData.SdrsAutomationLevel defaultLevel = null;
        String defaultLevelString = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)dsClusterRef, (String)"podStorageDrsEntry.storageDrsConfig.podConfig.defaultVmBehavior");
        defaultLevel = Util.getSdrsAutomationLevel(defaultLevelString);
        return defaultLevel;
    }

    @type(value="StoragePod")
    public SdrsRuleInfo[] getSdrsRulesData(ManagedObjectReference dsClusterRef) throws Exception {
        PropertyValue[] propertiesResult = QueryUtil.getProperties((DataService)this._dataService, (Object)dsClusterRef, (String[])new String[]{"podStorageDrsEntry.storageDrsConfig.podConfig.rule", "podStorageDrsEntry.storageDrsConfig.vmConfig"});
        ArrayList resultAsList = new ArrayList();
        for (PropertyValue propertyValue : propertiesResult) {
            if (propertyValue.value instanceof RuleInfo[]) {
                List itraVmAntiAffinityRules = SdrsRulesBuilder.buildVmAntiAffinityRules((ManagedObjectReference)dsClusterRef, (RuleInfo[])((RuleInfo[])propertyValue.value));
                resultAsList.addAll(itraVmAntiAffinityRules);
            }
            if (!(propertyValue.value instanceof VmConfigInfo[])) continue;
            List intraVmAntiAffinityRules = SdrsRulesBuilder.buildIntraVmAntiAffinityRules((ManagedObjectReference)dsClusterRef, (VmConfigInfo[])((VmConfigInfo[])propertyValue.value));
            resultAsList.addAll(intraVmAntiAffinityRules);
        }
        SdrsRuleInfo[] result = new SdrsRuleInfo[resultAsList.size()];
        return resultAsList.toArray(result);
    }

    @type(value="StoragePod")
    public IntraVmAffinity getDefaultIntraVmAffinity(ManagedObjectReference dsClusterRef) throws Exception {
        if (dsClusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        Boolean intraVmAffinity = (Boolean)QueryUtil.getProperty((DataService)this._dataService, (Object)dsClusterRef, (String)"podStorageDrsEntry.storageDrsConfig.podConfig.defaultIntraVmAffinity");
        return Util.getIntraVmAffinity(intraVmAffinity);
    }

    @type(value="Folder,Datacenter")
    public String getNewUniqueDsClusterName(ManagedObjectReference context) {
        ArrayList<String> existingNames = this.getAllDsClusterNames(context);
        String newUniqueDsClusterName = StringUtil.getIndexedString(existingNames, (String)DEFAULT_DS_CLUSTER_NAME, (String)" ");
        return newUniqueDsClusterName;
    }

    private ArrayList<String> getAllDsClusterNames(ManagedObjectReference context) {
        ArrayList existingNames = null;
        try {
            existingNames = ObjectNamesRetriever.getNamesOfAllObjectsWithinDatacenter((DataService)this._dataService, (ManagedObjectReference)context, (String)DS_CLUSTER_TYPE, (String)DEFAULT_DS_CLUSTER_NAME);
        }
        catch (Exception e) {
            _logger.error((Object)e);
        }
        return existingNames;
    }
}

