/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.drs.model.VmMonitorTargetData;
import com.vmware.vsphere.client.dscluster.model.configuration.SdrsRuleListItemData;
import com.vmware.vsphere.client.dscluster.model.configuration.SdrsRuleVmDatastoreData;
import com.vmware.vsphere.client.dscluster.util.Util;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SdrsRulesUtil {
    public static SdrsRuleListItemData createSdrsRuleListItem(SdrsRuleInfo sdrsRuleInfo, Map<ManagedObjectReference, VmMonitorTargetData> vmsData) {
        SdrsRuleListItemData sdrsRuleListItemData = new SdrsRuleListItemData();
        sdrsRuleListItemData.rule = sdrsRuleInfo.rule;
        sdrsRuleListItemData.ruleType = sdrsRuleInfo.ruleType;
        sdrsRuleListItemData.vm = vmsData.get(sdrsRuleInfo.vm);
        return sdrsRuleListItemData;
    }

    public static Map<ManagedObjectReference, VmMonitorTargetData> getVmsMapByRef(Collection<VmMonitorTargetData> vmsResultSet) {
        HashMap<ManagedObjectReference, VmMonitorTargetData> vmsByRef = new HashMap<ManagedObjectReference, VmMonitorTargetData>();
        for (VmMonitorTargetData resultItem : vmsResultSet) {
            ManagedObjectReference objRef = (ManagedObjectReference)resultItem.getProvider();
            vmsByRef.put(objRef, resultItem);
        }
        return vmsByRef;
    }

    public static String getSdrsRuleVmDatastoreName(SdrsRuleVmDatastoreData[] datastores) {
        if (datastores.length > 1) {
            return Util.getLocalizedString("sdrs.rules.config.multipleDatastores", new String[0]);
        }
        return datastores[0].name;
    }

    public static String getSdrsRuleVmDatastoreHint(SdrsRuleVmDatastoreData[] datastores) {
        if (datastores.length > 1) {
            StringBuilder hintBuilder = new StringBuilder();
            for (int i = 0; i < datastores.length; ++i) {
                if (i == 0) {
                    hintBuilder.append(datastores[i].name);
                    continue;
                }
                hintBuilder.append(Util.getLocalizedString("sdrs.rules.config.multipleFormat", datastores[i].name));
            }
            return hintBuilder.toString();
        }
        return datastores[0].name;
    }
}

