/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.validation.impl;

import com.vmware.vim.binding.vim.cluster.AntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.option.ArrayUpdateSpec;
import com.vmware.vim.binding.vim.storageDrs.VirtualDiskAntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.dscluster.util.SdrsRulesHelper;
import com.vmware.vsphere.client.storagedrs.rules.IntraVmAffinity;
import com.vmware.vsphere.client.storagedrs.rules.RuleType;
import com.vmware.vsphere.client.storagedrs.rules.SdrsIntraVmAffinityData;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleInfo;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleValidationResult;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SdrsRuleValidator {
    private static final Log _logger = LogFactory.getLog(SdrsRuleValidator.class);
    private final SdrsRulesHelper validatorHelper;

    public SdrsRuleValidator(SdrsRulesHelper validatorHelper) {
        this.validatorHelper = validatorHelper;
    }

    public SdrsRuleValidationResult validateRule(SdrsRuleInfo ruleInfo) throws Exception {
        SdrsRuleValidationResult validationResult = new SdrsRuleValidationResult();
        validationResult.ruleName = ruleInfo.rule.name;
        validationResult.ruleType = ruleInfo.ruleType;
        this.validateRuleName(ruleInfo, validationResult, this.validatorHelper);
        if (!ruleInfo.rule.enabled.booleanValue()) {
            return validationResult;
        }
        RuleType ruleType = this.getRuleType(ruleInfo);
        if (RuleType.VIRTUAL_DISK_ANTI_AFFINITY_RULE_TYPE == ruleType) {
            this.validateIntraVMRuleForPod(ruleInfo, validationResult, this.validatorHelper);
        } else if (RuleType.VM_ANTIAFFINITY_RULE_TYPE == ruleType) {
            this.validateInterVMRule(ruleInfo, validationResult, this.validatorHelper);
        }
        return validationResult;
    }

    public SdrsRuleValidationResult validateVMDKAffinityOverride(ManagedObjectReference vm, IntraVmAffinity intraVmAffinity) throws Exception {
        boolean defaultIntraVmAffinity = this.validatorHelper.isDefaultIntraVmAffinity();
        boolean vmdkAffinity = intraVmAffinity == IntraVmAffinity.KeepVmdksTogether || intraVmAffinity == IntraVmAffinity.ClusterDefault && defaultIntraVmAffinity;
        SdrsRuleValidationResult validationResult = new SdrsRuleValidationResult();
        if (vmdkAffinity) {
            RuleInfo vmdkAntiAffinityRule = this.getVmdkAntiAffinityRule(vm);
            if (vmdkAntiAffinityRule != null) {
                validationResult.conflictingRules.add(vmdkAntiAffinityRule);
            }
        } else {
            Collection<RuleInfo> interVmRules = this.getVmAntiAffinityRules(vm);
            validationResult.conflictingRules.addAll(interVmRules);
        }
        return validationResult;
    }

    private void validateRuleName(SdrsRuleInfo ruleInfo, SdrsRuleValidationResult validationResult, SdrsRulesHelper validatorHelper) {
        List<RuleInfo> allDatastoreClusterRules = validatorHelper.getDsClusterRules();
        for (RuleInfo rule : allDatastoreClusterRules) {
            if (!rule.name.equals(ruleInfo.rule.name) || this.isTheSameRule(ruleInfo, rule)) continue;
            validationResult.nameIsDuplicated = true;
            break;
        }
    }

    private boolean isTheSameRule(SdrsRuleInfo ruleInfo, RuleInfo rule) {
        RuleInfo thisRule = ruleInfo.rule;
        if (!thisRule.getClass().equals(rule.getClass())) {
            return false;
        }
        if (thisRule.key == null) {
            return rule.key == null;
        }
        return thisRule.key.equals(rule.key);
    }

    private void validateIntraVMRuleForPod(SdrsRuleInfo ruleInfo, SdrsRuleValidationResult validationResult, SdrsRulesHelper validatorHelper) {
        this.validateConflictWithInterVMAntiAffinityRule(ruleInfo, validationResult, validatorHelper);
        this.validateConflictWithIntraVMAntiAffinityRule(ruleInfo, validationResult, validatorHelper);
        if (validatorHelper.areVmdksKeptTogether(this.getVm(ruleInfo))) {
            ManagedObjectReference ruleVm = this.getVm(ruleInfo);
            SdrsIntraVmAffinityData ruleVmData = this.getVmOverrideData(ruleVm);
            validationResult.conflictingVmsOverrides.add(ruleVmData);
        }
    }

    private void validateInterVMRule(SdrsRuleInfo ruleInfo, SdrsRuleValidationResult valRes, SdrsRulesHelper validatorHelper) {
        Object newVmRef;
        IntraVmAffinity newVmVmIntraAff;
        ManagedObjectReference[] ruleVms = this.getRuleVms(ruleInfo);
        if (ruleVms.length == 0) {
            _logger.error((Object)("No target vms found for rule - " + ruleInfo.ruleType.toString()));
            return;
        }
        _logger.debug((Object)("Cluster's default intra vm affinity rule behavior = " + validatorHelper.isDefaultIntraVmAffinity()));
        if (validatorHelper.isVmProvisionig() && ((newVmVmIntraAff = validatorHelper.getIntraVmAffinity((ManagedObjectReference)(newVmRef = null))) == IntraVmAffinity.DoNotKeepVmdksTogether || newVmVmIntraAff == IntraVmAffinity.ClusterDefault && !validatorHelper.isDefaultIntraVmAffinity())) {
            valRes.conflictingDscDefVmAffVms.add(newVmRef);
        }
        for (ManagedObjectReference vm : ruleVms) {
            ManagedObjectReference ruleVm = this.getVm(ruleInfo);
            if (ruleVm != null && vm.getServerGuid().equals(ruleVm.getServerGuid())) continue;
            if (!validatorHelper.isDefaultIntraVmAffinity()) {
                IntraVmAffinity vmsIntraAff = validatorHelper.getIntraVmAffinity(vm);
                if (vmsIntraAff != IntraVmAffinity.KeepVmdksTogether) {
                    valRes.conflictingDscDefVmAffVms.add(vm);
                }
            } else if (!validatorHelper.areVmdksKeptTogether(vm)) {
                valRes.conflictingVmsOverrides.add(this.getVmOverrideData(vm));
            }
            RuleInfo vmdkAntiAffinityRule = validatorHelper.getVmdkAntiAffinityRule(vm);
            if (vmdkAntiAffinityRule == null) continue;
            valRes.conflictingRules.add(vmdkAntiAffinityRule);
        }
        _logger.debug((Object)("conflictingDscDefVmAffVms count = " + valRes.conflictingDscDefVmAffVms.size()));
    }

    private void validateConflictWithInterVMAntiAffinityRule(SdrsRuleInfo ruleInfo, SdrsRuleValidationResult validationResult, SdrsRulesHelper validatorHelper) {
        Collection<RuleInfo> interVmRules = validatorHelper.getVmAntiAffinityRules(this.getVm(ruleInfo));
        for (RuleInfo sdrsRuleInfo : interVmRules) {
            validationResult.conflictingRules.add(sdrsRuleInfo);
        }
    }

    private void validateConflictWithIntraVMAntiAffinityRule(SdrsRuleInfo ruleInfo, SdrsRuleValidationResult validationResult, SdrsRulesHelper validatorHelper) {
        RuleInfo intraVmAntiAffinityRule = this.getVmdkAntiAffinityRule(this.getVm(ruleInfo));
        if (intraVmAntiAffinityRule != null && ArrayUpdateSpec.Operation.add.equals((Object)ruleInfo.operation)) {
            validationResult.conflictingRules.add(intraVmAntiAffinityRule);
        }
    }

    private ManagedObjectReference[] getRuleVms(SdrsRuleInfo ruleInfo) {
        if (ruleInfo.rule instanceof AntiAffinityRuleSpec) {
            return ((AntiAffinityRuleSpec)ruleInfo.rule).vm;
        }
        return new ManagedObjectReference[0];
    }

    private ManagedObjectReference getVm(SdrsRuleInfo ruleInfo) {
        if (ruleInfo.rule instanceof VirtualDiskAntiAffinityRuleSpec) {
            return ruleInfo.vm;
        }
        return null;
    }

    private RuleType getRuleType(SdrsRuleInfo ruleInfo) {
        return ruleInfo.ruleType;
    }

    private SdrsIntraVmAffinityData getVmOverrideData(ManagedObjectReference vm) {
        if (vm == null) {
            return null;
        }
        SdrsIntraVmAffinityData vmOverrideData = new SdrsIntraVmAffinityData();
        vmOverrideData.vmName = this.validatorHelper.getVmName(vm);
        vmOverrideData.vmSor = vm;
        vmOverrideData.intraVmAffinity = this.validatorHelper.getIntraVmAffinity(vm);
        return vmOverrideData;
    }

    private Collection<RuleInfo> getVmAntiAffinityRules(ManagedObjectReference vm) {
        return this.validatorHelper.getVmAntiAffinityRules(vm);
    }

    private RuleInfo getVmdkAntiAffinityRule(ManagedObjectReference vm) {
        return this.validatorHelper.getVmdkAntiAffinityRule(vm);
    }

    private VmConfigInfo getVmConfigInfo(SdrsRuleInfo ruleInfo) {
        return this.validatorHelper.getVmConfigInfo(ruleInfo.vm);
    }
}

