/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data;

import com.vmware.vise.core.model.data;
import com.vmware.vise.core.model.optional;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import java.util.Arrays;

@data(base="Object")
public class PropertySpec
implements Cloneable {
    @optional
    public String type;
    @optional
    public String relation;
    public String[] propertyNames;
    @optional
    public ParameterSpec[] parameters;

    public String toString() {
        return "[type: " + this.type + ", relation: " + this.relation + ", propertyNames: " + Arrays.toString(this.propertyNames) + ", parameters: " + Arrays.toString(this.parameters) + "]";
    }

    public PropertySpec clone() throws CloneNotSupportedException {
        int i;
        PropertySpec copy = (PropertySpec)super.clone();
        copy.type = this.type;
        copy.relation = this.relation;
        if (this.propertyNames != null) {
            copy.propertyNames = new String[this.propertyNames.length];
            for (i = 0; i < this.propertyNames.length; ++i) {
                copy.propertyNames[i] = this.propertyNames[i];
            }
        }
        if (this.parameters != null) {
            copy.parameters = new ParameterSpec[this.parameters.length];
            for (i = 0; i < this.parameters.length; ++i) {
                copy.parameters[i] = this.parameters[i].clone();
            }
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertySpec)) {
            return false;
        }
        PropertySpec that = (PropertySpec)obj;
        return ObjectUtil.objectsEqual((Object)this.type, (Object)that.type) && ObjectUtil.objectsEqual((Object)PropertySpec.normalizeRelation(this.relation), (Object)PropertySpec.normalizeRelation(that.relation)) && ArrayUtil.areEquivalent((Object[])this.propertyNames, (Object[])that.propertyNames) && ArrayUtil.areEquivalent((Object[])this.parameters, (Object[])that.parameters);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + ObjectUtil.getHashCode((Object)this.type);
        result = 31 * result + ObjectUtil.getHashCode((Object)PropertySpec.normalizeRelation(this.relation));
        result = 31 * result + Arrays.hashCode(this.propertyNames);
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    private static String normalizeRelation(String relation) {
        if ("".equals(relation)) {
            return null;
        }
        return relation;
    }
}

