/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.htmlsample.vim25.services;

import com.vmware.samples.htmlsample.model.Host;
import com.vmware.samples.htmlsample.vim25.services.VimObjectService;
import com.vmware.samples.htmlsample.vim25.ssl.TrustedService;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.HostSystemConnectionState;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import com.vmware.vise.usersession.ServerInfo;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.BindingProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VimObjectServiceImpl
implements VimObjectService {
    private static final Log _logger = LogFactory.getLog(VimObjectServiceImpl.class);
    private static final String SERVICE_INSTANCE = "ServiceInstance";
    private static final String SSL_SOCKET_FACTORY = "com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory";
    private static final String NAME = "name";
    private static final String HOST = "HostSystem";
    private static final String OBJECT_ID_FORMAT = "urn:vmomi:%s:%s:%s";
    private static final String HOST_SUMMARY = "summary.host";
    private static final String HOST_CONNECTION_STATE = "runtime.connectionState";
    private static final String NUM_CPU_CORES = "hardware.cpuInfo.numCpuCores";
    private static final String MEMORY_SIZE = "systemResources.config.memoryAllocation.limit";
    private static final String[] HOST_PROPERTIES = new String[]{"name", "summary.host", "hardware.cpuInfo.numCpuCores", "runtime.connectionState", "systemResources.config.memoryAllocation.limit"};
    private static VimPortType _vimPort = VimObjectServiceImpl.initializeVimPort();

    private static VimPortType initializeVimPort() {
        VimService vimService = new VimService();
        VimPortType vimPort = vimService.getVimPort();
        Map reqContext = ((BindingProvider)vimPort).getRequestContext();
        try {
            SSLSocketFactory sslSocketFactory = TrustedService.getSSLSocketFactory();
            reqContext.put(SSL_SOCKET_FACTORY, sslSocketFactory);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            _logger.error((Object)"Could not setup SSLSocketFactory in the context.", (Throwable)e);
        }
        return vimPort;
    }

    private void destroy() {
        _vimPort = null;
    }

    @Override
    public List<Host> retrieveHosts(ServerInfo serverInfoObject) {
        VimObjectServiceImpl.paramsNotNull(serverInfoObject);
        List<Map<String, Object>> retrievedHosts = this.retrieveObjectProperties(serverInfoObject, HOST, HOST_PROPERTIES);
        List<Host> hosts = this.transformHostsPropertiesToObjects(retrievedHosts, serverInfoObject);
        return hosts;
    }

    @Override
    public List<Map<String, Object>> retrieveObjectProperties(ServerInfo serverInfo, String vSphereObject, String[] vSphereObjectProperties) {
        VimObjectServiceImpl.paramsNotNull(serverInfo, vSphereObject, vSphereObjectProperties);
        ServiceContent serviceContent = null;
        try {
            serviceContent = this.getServiceContentWithSessionCookie(serverInfo);
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            _logger.warn((Object)"Could not retrieve the ServiceContent using sessionCookie", (Throwable)runtimeFaultFaultMsg);
        }
        if (serviceContent == null) {
            return new ArrayList<Map<String, Object>>();
        }
        ManagedObjectReference viewMgrRef = serviceContent.getViewManager();
        ManagedObjectReference propColl = serviceContent.getPropertyCollector();
        ArrayList<String> vObjects = new ArrayList<String>();
        vObjects.add(vSphereObject);
        RetrieveResult props = null;
        try {
            ManagedObjectReference cViewRef = _vimPort.createContainerView(viewMgrRef, serviceContent.getRootFolder(), vObjects, true);
            props = this.retrieveProperties(cViewRef, propColl, vSphereObject, vSphereObjectProperties);
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            _logger.error((Object)("Could not create ContainerView for " + vSphereObject), (Throwable)runtimeFaultFaultMsg);
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            _logger.error((Object)("Could not retrieveProperties for " + vSphereObject), (Throwable)invalidPropertyFaultMsg);
        }
        return this.formatRetrievedProperties(props);
    }

    private List<Host> transformHostsPropertiesToObjects(List<Map<String, Object>> retrievedHosts, ServerInfo serverInfoObject) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (Map<String, Object> retrievedHost : retrievedHosts) {
            String objectId = this.getFormattedObjectId(retrievedHost, serverInfoObject.serviceGuid);
            String connectionState = this.getHostConnectionState(retrievedHost);
            Object numCpuObject = retrievedHost.get(NUM_CPU_CORES);
            Object memSizeObject = retrievedHost.get(MEMORY_SIZE);
            String numCpus = numCpuObject == null ? "" : numCpuObject.toString();
            String memSize = memSizeObject == null ? "" : memSizeObject.toString();
            Host host = new Host(objectId, (String)retrievedHost.get(NAME), connectionState, serverInfoObject.name, memSize, numCpus);
            hosts.add(host);
        }
        return hosts;
    }

    private String getFormattedObjectId(Map<String, Object> host, String serviceGuid) {
        String hostId = ((ManagedObjectReference)host.get(HOST_SUMMARY)).getValue();
        String objectId = String.format(OBJECT_ID_FORMAT, HOST, hostId, serviceGuid);
        return objectId;
    }

    private String getHostConnectionState(Map<String, Object> host) {
        HostSystemConnectionState conState = (HostSystemConnectionState)host.get(HOST_CONNECTION_STATE);
        return conState == null ? "" : conState.value();
    }

    private ServiceContent getServiceContentWithSessionCookie(ServerInfo sInfo) throws RuntimeFaultFaultMsg {
        TrustedService.setThumbprint(sInfo);
        ManagedObjectReference serviceInstanceRef = this.createSvcInstanceRef(sInfo.serviceUrl, sInfo.sessionCookie);
        ServiceContent serviceContent = _vimPort.retrieveServiceContent(serviceInstanceRef);
        return serviceContent;
    }

    private ManagedObjectReference createSvcInstanceRef(String serviceUrl, String sessionCookie) {
        ArrayList<String> values = new ArrayList<String>();
        values.add("vmware_soap_session=" + sessionCookie);
        HashMap<String, ArrayList<String>> reqHeadrs = new HashMap<String, ArrayList<String>>();
        reqHeadrs.put("Cookie", values);
        Map reqContext = ((BindingProvider)_vimPort).getRequestContext();
        reqContext.put("javax.xml.ws.service.endpoint.address", serviceUrl);
        reqContext.put("javax.xml.ws.session.maintain", true);
        reqContext.put("javax.xml.ws.http.request.headers", reqHeadrs);
        ManagedObjectReference svcInstanceRef = new ManagedObjectReference();
        svcInstanceRef.setType(SERVICE_INSTANCE);
        svcInstanceRef.setValue(SERVICE_INSTANCE);
        return svcInstanceRef;
    }

    private RetrieveResult retrieveProperties(ManagedObjectReference cViewRef, ManagedObjectReference propColl, String vSphereObject, String[] vSphereObjectProperties) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        PropertyFilterSpec fSpec = this.createPropertyFilterSpec(cViewRef, vSphereObject, vSphereObjectProperties);
        ArrayList<PropertyFilterSpec> fSpecList = new ArrayList<PropertyFilterSpec>();
        fSpecList.add(fSpec);
        RetrieveOptions ro = new RetrieveOptions();
        RetrieveResult props = _vimPort.retrievePropertiesEx(propColl, fSpecList, ro);
        return props;
    }

    private PropertyFilterSpec createPropertyFilterSpec(ManagedObjectReference cViewRef, String vSphereObject, String[] vSphereObjectProperties) {
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(cViewRef);
        oSpec.setSkip(Boolean.valueOf(true));
        TraversalSpec tSpec = new TraversalSpec();
        tSpec.setName("traverseEntities");
        tSpec.setPath("view");
        tSpec.setSkip(Boolean.valueOf(false));
        tSpec.setType("ContainerView");
        oSpec.getSelectSet().add(tSpec);
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType(vSphereObject);
        pSpec.getPathSet().addAll(Arrays.asList(vSphereObjectProperties));
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        fSpec.getObjectSet().add(oSpec);
        fSpec.getPropSet().add(pSpec);
        return fSpec;
    }

    private List<Map<String, Object>> formatRetrievedProperties(RetrieveResult props) {
        ArrayList<Map<String, Object>> objectsProperties = new ArrayList<Map<String, Object>>();
        if (props != null) {
            for (ObjectContent oc : props.getObjects()) {
                List dps = oc.getPropSet();
                HashMap<String, Object> managedObject = new HashMap<String, Object>(dps.size());
                if (dps != null) {
                    for (DynamicProperty dp : dps) {
                        managedObject.put(dp.getName(), dp.getVal());
                    }
                }
                objectsProperties.add(managedObject);
            }
        }
        return objectsProperties;
    }

    public static void paramsNotNull(Object ... args) {
        if (args == null) {
            throw new IllegalArgumentException("Null argument args");
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            throw new IllegalArgumentException("Null param at index: " + i);
        }
    }
}

