/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.htmlsample.vim25.ssl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThumbprintTrustManager
implements X509TrustManager {
    private static final String ERROR_MSG = "Server certificate chain is not trusted and thumbprint doesn't match";
    private static final Log _logger = LogFactory.getLog(ThumbprintTrustManager.class);
    private static final Set<String> _thumbprints = new CopyOnWriteArraySet<String>();

    public static boolean addThumbprint(String thumbprint) {
        return _thumbprints.add(thumbprint);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        for (X509Certificate cert : certs) {
            ThumbprintTrustManager.checkThumbprint(cert);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
    }

    public static void checkThumbprint(X509Certificate cert) throws CertificateException {
        String thumbprint = ThumbprintTrustManager.getThumbprint(cert);
        if (!_thumbprints.contains(thumbprint)) {
            _logger.error((Object)ERROR_MSG);
            throw new CertificateException(ERROR_MSG);
        }
    }

    private static String getThumbprint(X509Certificate cert) throws CertificateException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] certBytes = cert.getEncoded();
            byte[] bytes = md.digest(certBytes);
            String thumbprint = DatatypeConverter.printHexBinary((byte[])bytes).toLowerCase();
            return thumbprint;
        }
        catch (NoSuchAlgorithmException e) {
            _logger.error((Object)ERROR_MSG);
            throw new CertificateException(ERROR_MSG);
        }
    }
}

