/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.AlarmDefInfoSpec;
import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.alarms.AlarmEventArgsSpec;
import com.vmware.opsmgmt.client.alarms.EventAlarmDetails;
import com.vmware.opsmgmt.client.alarms.ServerCollection;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.action.Action;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.action.MethodActionArgument;
import com.vmware.vim.binding.vim.alarm.AlarmAction;
import com.vmware.vim.binding.vim.alarm.AlarmDescription;
import com.vmware.vim.binding.vim.alarm.AlarmExpression;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmManager;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vim.binding.vim.alarm.AndAlarmExpression;
import com.vmware.vim.binding.vim.alarm.EventAlarmExpression;
import com.vmware.vim.binding.vim.alarm.GroupAlarmAction;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import com.vmware.vim.binding.vim.alarm.OrAlarmExpression;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmDefinitionInfoProvider
implements PropertyProviderBean {
    private static final String BINDING_PACKAGE = "com.vmware.vim.binding.";
    private static final String[] INOPERATIVE_TRIGGERS = new String[]{"vim.event.DatastoreRemovedOnHostEvent", "vim.event.VmRemovedEvent", "VmRemovedEvent", "com.vmware.license.DefaultLicenseKeyChangedEvent"};
    private static final String MIGRATE_ACTION_NAME = "MigrateVM_Task";
    private static final Log _logger = LogFactory.getLog(AlarmDefinitionInfoProvider.class);
    private DataService _dataService;

    public AlarmDefinitionInfoProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="Alarm")
    public AlarmDefinitionInfo getAlarmDefinitionInfo(ManagedObjectReference moRef, Object[] serverCollections) throws Exception {
        return this.getAlarmDefinitionInfoForAlarm(moRef, serverCollections);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Folder,DatacenterFolder,DatastoreFolder,HostFolder,NetworkFolder,VirtualMachineFolder,Datacenter,ComputeResource,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Network,DistributedVirtualPortgroup,Datastore,StoragePod")
    public AlarmDefinitionInfo getAlarmWizardInfo(ManagedObjectReference moRef, AlarmDefInfoSpec spec) throws Exception {
        AlarmDefinitionInfo info = new AlarmDefinitionInfo();
        String serverGuid = moRef.getServerGuid();
        if (spec.serverCollections != null && spec.serverCollections.length != 0) {
            info.states = this.processServerCollections(serverGuid, spec.serverCollections);
        }
        LinkedList<EventAlarmExpression> eventExpressions = new LinkedList<EventAlarmExpression>();
        LinkedList<MetricAlarmExpression> meticExpressions = new LinkedList<MetricAlarmExpression>();
        if (spec.alarm != null) {
            AlarmInfo alarmInfo = this.getAlarmInfo(spec.alarm);
            AlarmExpression alarmExpression = alarmInfo.expression;
            this.extractAlarmExpressions(alarmExpression, eventExpressions, meticExpressions);
        }
        if (spec.getEvents) {
            info.events = this.getEventsInfo(spec.moType, moRef, eventExpressions, spec.includeAllEventArgs);
        }
        info.counters = this.getCounterInfo(meticExpressions, serverGuid, spec.counters);
        return info;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Folder,DatacenterFolder,DatastoreFolder,HostFolder,NetworkFolder,VirtualMachineFolder,Datacenter,ComputeResource,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Network,DistributedVirtualPortgroup,Datastore,StoragePod")
    public EventDescription.EventArgDesc[] getAlarmEventArgs(ManagedObjectReference moRef, AlarmEventArgsSpec spec) throws Exception {
        Validate.notNull((Object)spec);
        Validate.notEmpty((String)spec.eventTypeId, (String)"eventTypeId is required");
        EventManager eventManager = this.getEventManager(moRef.getServerGuid());
        EventDescription.EventArgDesc[] eventArguments = eventManager.retrieveArgumentDescription(spec.eventTypeId);
        if (eventArguments == null) {
            eventArguments = new EventDescription.EventArgDesc[]{};
        }
        return eventArguments;
    }

    private EventAlarmDetails[] getEventsInfo(String moType, ManagedObjectReference moRef, List<EventAlarmExpression> eventExpressions, boolean includeAllEventArgs) throws Exception {
        EventManager eventManager = this.getEventManager(moRef.getServerGuid());
        Map<String, EventDescription.EventDetail> eventDetailsByEventTypeId = this.getEventDescriptions(eventManager);
        Set<String> supportedEvents = this.getSupportedEvents(moType, moRef);
        HashSet<String> currentAlarmEvents = new HashSet<String>();
        for (EventAlarmExpression expression : eventExpressions) {
            String eventTypeId = this.getEventTypeId(expression);
            if (StringUtil.isNullOrEmpty((String)eventTypeId)) continue;
            supportedEvents.add(eventTypeId);
            currentAlarmEvents.add(eventTypeId);
        }
        ArrayList<EventAlarmDetails> events = new ArrayList<EventAlarmDetails>();
        for (String eventTypeId : supportedEvents) {
            if (!this.isOperativeTrigger(eventTypeId)) continue;
            EventDescription.EventDetail detail = eventDetailsByEventTypeId.get(eventTypeId);
            String description = null;
            if (detail != null) {
                description = detail.description;
            }
            EventAlarmDetails details = new EventAlarmDetails();
            details.eventTypeId = eventTypeId;
            details.description = description;
            details.isCustomEvent = this.isCustomEvent(detail);
            if (includeAllEventArgs || currentAlarmEvents.contains(eventTypeId)) {
                details.eventArguments = eventManager.retrieveArgumentDescription(eventTypeId);
            }
            events.add(details);
        }
        return events.toArray(new EventAlarmDetails[events.size()]);
    }

    private PerformanceManager.CounterInfo[] getCounterInfo(List<MetricAlarmExpression> meticExpressions, String serverGuid, String[] counters) throws Exception {
        PerformanceManager.CounterInfo[] counterInfos;
        HashSet<Integer> counterIds = new HashSet<Integer>();
        for (MetricAlarmExpression metricExpression : meticExpressions) {
            counterIds.add(metricExpression.getMetric().getCounterId());
        }
        HashSet<String> counterNames = new HashSet<String>();
        if (counters != null) {
            counterNames.addAll(Arrays.asList(counters));
        }
        HashSet<PerformanceManager.CounterInfo> counterInfoResults = new HashSet<PerformanceManager.CounterInfo>();
        PerformanceManager performanceManager = this.getPerformanceManager(serverGuid);
        for (PerformanceManager.CounterInfo counterInfo : counterInfos = performanceManager.getPerfCounter()) {
            if (counterIds.contains(counterInfo.key)) {
                counterInfoResults.add(counterInfo);
                continue;
            }
            String counterName = counterInfo.groupInfo.key + "." + counterInfo.nameInfo.key + "." + counterInfo.rollupType.toString();
            if (!counterNames.contains(counterName = counterName.toLowerCase())) continue;
            counterInfoResults.add(counterInfo);
        }
        return counterInfoResults.toArray(new PerformanceManager.CounterInfo[counterInfoResults.size()]);
    }

    private AlarmDefinitionInfo getAlarmDefinitionInfoForAlarm(ManagedObjectReference alarmRef, Object[] serverCollections) throws Exception {
        AlarmDefinitionInfo info = null;
        LinkedList<EventAlarmExpression> eventExpressions = new LinkedList<EventAlarmExpression>();
        LinkedList<MetricAlarmExpression> meticExpressions = new LinkedList<MetricAlarmExpression>();
        AlarmInfo alarmInfo = this.getAlarmInfo(alarmRef);
        AlarmExpression alarmExpression = alarmInfo.expression;
        this.extractAlarmExpressions(alarmExpression, eventExpressions, meticExpressions);
        String serverGuid = alarmRef.getServerGuid();
        info = new AlarmDefinitionInfo();
        info.events = this.processEventAlarmExpressions(serverGuid, eventExpressions);
        info.counters = this.processMetricAlarmExpressions(serverGuid, meticExpressions);
        info.states = this.processServerCollections(serverGuid, serverCollections);
        info.migrateActionArgs = this.getMigrateActionMoRefsNames(alarmInfo.action);
        return info;
    }

    private void extractAlarmExpressions(AlarmExpression expression, List<EventAlarmExpression> eventExpressions, List<MetricAlarmExpression> metricExpressions) {
        if (expression instanceof AndAlarmExpression) {
            AndAlarmExpression andAlarmExpression = (AndAlarmExpression)expression;
            for (AlarmExpression exp : andAlarmExpression.expression) {
                this.extractAlarmExpressions(exp, eventExpressions, metricExpressions);
            }
        } else if (expression instanceof OrAlarmExpression) {
            OrAlarmExpression orAlarmExpression = (OrAlarmExpression)expression;
            for (AlarmExpression exp : orAlarmExpression.expression) {
                this.extractAlarmExpressions(exp, eventExpressions, metricExpressions);
            }
        } else if (expression instanceof EventAlarmExpression) {
            eventExpressions.add((EventAlarmExpression)expression);
        } else if (expression instanceof MetricAlarmExpression) {
            metricExpressions.add((MetricAlarmExpression)expression);
        }
    }

    private EventAlarmDetails[] processEventAlarmExpressions(String serverGuid, List<EventAlarmExpression> eventAlarmExpressions) throws Exception {
        if (eventAlarmExpressions == null || eventAlarmExpressions.isEmpty()) {
            return null;
        }
        EventManager eventManager = this.getEventManager(serverGuid);
        Map<String, EventDescription.EventDetail> eventDetailByEventTypeId = this.getEventDescriptions(eventManager);
        HashMap<String, EventAlarmDetails> detailsByEventTypeId = new HashMap<String, EventAlarmDetails>();
        HashMap<String, Set<String>> argumentsByEventTypeId = new HashMap<String, Set<String>>();
        for (EventAlarmExpression expression : eventAlarmExpressions) {
            String eventTypeId = this.getEventTypeId(expression);
            if (StringUtil.isNullOrEmpty((String)eventTypeId)) continue;
            this.cacheEventArguments(argumentsByEventTypeId, eventTypeId, expression);
            if (detailsByEventTypeId.containsKey(eventTypeId)) continue;
            String description = null;
            EventDescription.EventDetail detail = eventDetailByEventTypeId.get(eventTypeId);
            if (detail != null) {
                description = detail.description;
            }
            EventAlarmDetails details = new EventAlarmDetails();
            details.eventTypeId = eventTypeId;
            details.description = description;
            details.eventArguments = eventManager.retrieveArgumentDescription(eventTypeId);
            detailsByEventTypeId.put(eventTypeId, details);
        }
        if (detailsByEventTypeId.isEmpty()) {
            return null;
        }
        this.filterEventArguments(detailsByEventTypeId, argumentsByEventTypeId);
        return detailsByEventTypeId.values().toArray(new EventAlarmDetails[detailsByEventTypeId.size()]);
    }

    private PerformanceManager.CounterInfo[] processMetricAlarmExpressions(String serverGuid, List<MetricAlarmExpression> metricAlarmExpressions) throws Exception {
        if (metricAlarmExpressions == null || metricAlarmExpressions.isEmpty()) {
            return null;
        }
        PerformanceManager performanceManager = this.getPerformanceManager(serverGuid);
        int[] counterIds = new int[metricAlarmExpressions.size()];
        for (int i = 0; i < metricAlarmExpressions.size(); ++i) {
            counterIds[i] = metricAlarmExpressions.get(i).getMetric().getCounterId();
        }
        PerformanceManager.CounterInfo[] counterInfos = performanceManager.queryCounter(counterIds);
        return counterInfos;
    }

    private ServerCollection[] processServerCollections(String serverGuid, Object[] serverCollections) throws Exception {
        if (serverCollections == null || serverCollections.length == 0) {
            return null;
        }
        AlarmManager alarmManager = this.getAlarmManager(serverGuid);
        AlarmDescription description = alarmManager.getDescription();
        ArrayList<ServerCollection> statesList = new ArrayList<ServerCollection>();
        for (Object serverCollection : serverCollections) {
            try {
                String collectionName = (String)serverCollection;
                Field f = description.getClass().getDeclaredField(collectionName);
                ServerCollection collection = new ServerCollection();
                collection.name = collectionName;
                collection.states = (ElementDescription[])f.get(description);
                statesList.add(collection);
            }
            catch (Exception e) {
                _logger.error((Object)"Unable to retrieve AlarmDescription.", (Throwable)e);
            }
        }
        if (statesList.isEmpty()) {
            return null;
        }
        return statesList.toArray(new ServerCollection[statesList.size()]);
    }

    private PropertyValue[] getMigrateActionMoRefsNames(AlarmAction action) throws Exception {
        LinkedList<ManagedObjectReference> migrateActionManageObjects = new LinkedList<ManagedObjectReference>();
        this.retrieveMigrateActionMoArguments(action, migrateActionManageObjects);
        if (migrateActionManageObjects.size() > 0) {
            Object[] arrMo = migrateActionManageObjects.toArray(new ManagedObjectReference[migrateActionManageObjects.size()]);
            PropertyValue[] results = QueryUtil.getProperties((DataService)this._dataService, (Object[])arrMo, (String[])new String[]{"name"});
            return results;
        }
        return new PropertyValue[0];
    }

    private void retrieveMigrateActionMoArguments(AlarmAction alarmAction, List<ManagedObjectReference> moRefs) throws Exception {
        block4: {
            Action action;
            block3: {
                if (!(alarmAction instanceof GroupAlarmAction)) break block3;
                for (AlarmAction action2 : ((GroupAlarmAction)alarmAction).action) {
                    this.retrieveMigrateActionMoArguments(action2, moRefs);
                }
                break block4;
            }
            if (!(alarmAction instanceof AlarmTriggeringAction) || !((action = ((AlarmTriggeringAction)alarmAction).action) instanceof MethodAction)) break block4;
            MethodAction methodAction = (MethodAction)action;
            if (MIGRATE_ACTION_NAME.equals(methodAction.name.toString())) {
                for (MethodActionArgument arg : methodAction.argument) {
                    if (!(arg.value instanceof ManagedObjectReference)) continue;
                    ManagedObjectReference ref = (ManagedObjectReference)arg.value;
                    moRefs.add(ref);
                }
            }
        }
    }

    private EventManager getEventManager(String vcServerGuid) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)vcServerGuid);
        ManagedObjectReference eventMgrRef = vcService.getServiceInstance().getContent().eventManager;
        return (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)eventMgrRef);
    }

    private PerformanceManager getPerformanceManager(String vcServerGuid) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)vcServerGuid);
        ManagedObjectReference performanceMgrRef = vcService.getServiceInstance().getContent().perfManager;
        return (PerformanceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)performanceMgrRef);
    }

    private AlarmManager getAlarmManager(String vcServerGuid) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)vcServerGuid);
        ManagedObjectReference alarmMgrRef = vcService.getServiceInstance().getContent().alarmManager;
        return (AlarmManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)alarmMgrRef);
    }

    private String getEventTypeId(EventDescription.EventDetail detail) {
        String eventTypeId = null;
        String keyName = this.extractName(detail.getKey());
        if (ExtendedEvent.class.getName().equals(keyName) || EventEx.class.getName().equals(keyName)) {
            if (!StringUtil.isNullOrEmpty((String)detail.fullFormat)) {
                int delimiterPosition = detail.fullFormat.indexOf("|");
                eventTypeId = delimiterPosition != -1 ? detail.fullFormat.substring(0, delimiterPosition) : detail.fullFormat;
            }
        } else {
            eventTypeId = keyName.replace(BINDING_PACKAGE, "");
        }
        return eventTypeId;
    }

    private boolean isCustomEvent(EventDescription.EventDetail detail) {
        if (detail == null) {
            return true;
        }
        String keyName = this.extractName(detail.getKey());
        return EventEx.class.getName().equals(keyName);
    }

    private String getEventTypeId(EventAlarmExpression expression) {
        String eventTypeId = expression.getEventTypeId();
        if (eventTypeId == null || eventTypeId.isEmpty()) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)"Returned eventTypeId is null, try determine elementDescription from deprecated eventType property");
            }
            String className = this.extractName(expression.eventType);
            eventTypeId = className.replace(BINDING_PACKAGE, "");
        }
        return eventTypeId;
    }

    private String extractName(TypeName typeName) {
        if (typeName == null) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)"Null TypeName");
            }
            return "";
        }
        String keyName = typeName.getName();
        if (!StringUtil.isNullOrEmpty((String)keyName)) {
            return keyName;
        }
        if (_logger.isWarnEnabled()) {
            _logger.warn((Object)("TypeName#getName() returned null for type " + typeName));
        }
        if (typeName instanceof TypeNameImpl) {
            keyName = ((TypeNameImpl)typeName).getWsdlName();
        }
        return StringUtil.isNullOrEmpty((String)keyName) ? "" : keyName;
    }

    private Map<String, EventDescription.EventDetail> getEventDescriptions(EventManager eventManager) {
        EventDescription.EventDetail[] eventInfo = eventManager.getDescription().eventInfo;
        HashMap<String, EventDescription.EventDetail> descriptionsByEventTypeId = new HashMap<String, EventDescription.EventDetail>();
        for (EventDescription.EventDetail detail : eventInfo) {
            String key = this.getEventTypeId(detail);
            if (StringUtil.isNullOrEmpty((String)key) || !this.isOperativeTrigger(key)) continue;
            descriptionsByEventTypeId.put(key, detail);
        }
        return descriptionsByEventTypeId;
    }

    private Set<String> getSupportedEvents(String moType, ManagedObjectReference moRef) {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = "EventClassification";
        propertyConstraint.propertyName = "objectType";
        propertyConstraint.comparator = Comparator.EQUALS;
        propertyConstraint.comparableValue = moType;
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.parameter = moRef;
        parameterSpec.propertyName = "eventsByObjectType";
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{"eventsByObjectType"};
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = propertyConstraint;
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        Set<String> supportedEvents = this.processEventClassificationResults(response.resultSet);
        return supportedEvents;
    }

    private Set<String> processEventClassificationResults(ResultSet[] results) {
        if (ArrayUtil.isNullOrEmpty((Object[])results)) {
            _logger.error((Object)"Empty result for EventClassification.eventsByObjectType");
            return new HashSet<String>();
        }
        HashSet<String> eventClassification = new HashSet<String>();
        for (ResultSet result : results) {
            if (ArrayUtil.isNullOrEmpty((Object[])result.items)) {
                _logger.warn((Object)"Empty ResultSet.items");
                continue;
            }
            for (ResultItem resultItem : result.items) {
                Object[] properties = resultItem.properties;
                if (ArrayUtil.isNullOrEmpty((Object[])properties)) continue;
                for (Object property : properties) {
                    Set events = (Set)((PropertyValue)property).value;
                    if (events == null) continue;
                    for (String eventId : events) {
                        eventId = eventId.replace(BINDING_PACKAGE, "");
                        eventClassification.add(eventId);
                    }
                }
            }
        }
        return eventClassification;
    }

    private void cacheEventArguments(Map<String, Set<String>> argumentsByEventTypeId, String eventTypeId, EventAlarmExpression expression) {
        if (!argumentsByEventTypeId.containsKey(eventTypeId)) {
            argumentsByEventTypeId.put(eventTypeId, new HashSet());
        }
        if (expression.comparisons == null || expression.comparisons.length == 0) {
            return;
        }
        Set<String> arguments = argumentsByEventTypeId.get(eventTypeId);
        for (EventAlarmExpression.Comparison comparison : expression.comparisons) {
            arguments.add(comparison.attributeName);
        }
    }

    private void filterEventArguments(Map<String, EventAlarmDetails> detailsByEventTypeId, Map<String, Set<String>> argumentsByEventTypeId) {
        for (Map.Entry<String, EventAlarmDetails> entry : detailsByEventTypeId.entrySet()) {
            String eventTypeId = entry.getKey();
            Set<String> usedArguments = argumentsByEventTypeId.get(eventTypeId);
            if (usedArguments.isEmpty()) {
                entry.getValue().eventArguments = null;
                continue;
            }
            ArrayList<EventDescription.EventArgDesc> filteredArgs = new ArrayList<EventDescription.EventArgDesc>();
            EventDescription.EventArgDesc[] eventArguments = entry.getValue().eventArguments;
            if (eventArguments != null) {
                for (EventDescription.EventArgDesc arg : eventArguments) {
                    if (!usedArguments.contains(arg.name)) continue;
                    filteredArgs.add(arg);
                }
            }
            entry.getValue().eventArguments = filteredArgs.toArray(new EventDescription.EventArgDesc[filteredArgs.size()]);
        }
    }

    private AlarmInfo getAlarmInfo(ManagedObjectReference alarmRef) throws Exception {
        Object instance = QueryUtil.getProperty((DataService)this._dataService, (Object)alarmRef, (String)"info");
        if (instance == null) {
            return null;
        }
        if (instance instanceof AlarmInfo) {
            AlarmInfo info = (AlarmInfo)instance;
            return info;
        }
        throw MixedUtil.getInvalidEntityFault();
    }

    private boolean isOperativeTrigger(String eventKey) {
        for (String key : INOPERATIVE_TRIGGERS) {
            if (!key.equals(eventKey)) continue;
            return false;
        }
        return true;
    }
}

