/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.TriggeredAlarmDetails;
import com.vmware.opsmgmt.client.alarms.util.AlarmUtil;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AlarmIssueAbsoluteDataValueProviderBase {
    private static final AtomicLong ISSUES_QUERY_COUNTER = new AtomicLong(0L);
    private static final String ISSUES_QUERY_NAME_PREFIX = "issue-query-";
    private static final String _TOTAL_COUNT_PREFIX_METADATA_KEY = "totalCount_";
    private static final List<QuerySpec> _NO_QUERY_SPECS = new ArrayList<QuerySpec>(0);
    private static final PartialUpdate<AlarmState> _NO_UPDATES = PartialUpdate.empty();
    private final DataService _dataService;
    private final QuerySpecBuilder _querySpecBuilder;

    protected AlarmIssueAbsoluteDataValueProviderBase(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
    }

    protected PartialUpdate<AlarmState> getValues() {
        List<QuerySpec> querySpecs = this.getAlarmIssuesQuerySpecs();
        if (querySpecs.isEmpty()) {
            return _NO_UPDATES;
        }
        Object[] resultSets = this.executeQuery(querySpecs);
        if (ArrayUtil.isNullOrEmpty((Object[])resultSets)) {
            return _NO_UPDATES;
        }
        PartialUpdate<AlarmState> result = this.processQueryResults(querySpecs, (ResultSet[])resultSets);
        result.setDestination("/topic/alarms");
        return result;
    }

    private List<QuerySpec> getAlarmIssuesQuerySpecs() {
        List<ManagedObjectReference> objects = this.getQueryObjects();
        if (objects.isEmpty()) {
            return _NO_QUERY_SPECS;
        }
        ArrayList<QuerySpec> result = new ArrayList<QuerySpec>(objects.size());
        for (int i = 0; i < objects.size(); ++i) {
            ManagedObjectReference object = objects.get(i);
            PropertyConstraint propConstraint = new PropertyConstraint();
            propConstraint.targetType = "AlarmIssue";
            propConstraint.propertyName = "info.entity";
            propConstraint.comparator = Comparator.EQUALS;
            propConstraint.comparableValue = object;
            QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec((Constraint)propConstraint, new String[]{"info"});
            querySpec.resultSpec = new ResultSpec();
            querySpec.resultSpec.maxResultCount = 150;
            querySpec.name = String.format("%s:%s:%s%s", object.getValue(), object.getServerGuid(), ISSUES_QUERY_NAME_PREFIX, ISSUES_QUERY_COUNTER.incrementAndGet());
            result.add(querySpec);
        }
        return result;
    }

    protected abstract List<ManagedObjectReference> getQueryObjects();

    private ResultSet[] executeQuery(List<QuerySpec> querySpecs) {
        ResultSet[] result = null;
        try {
            RequestSpec request = new RequestSpec();
            request.querySpec = (QuerySpec[])ArrayUtil.toArray(querySpecs, QuerySpec.class);
            Response response = this._dataService.getData(request);
            result = response.resultSet;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private PartialUpdate<AlarmState> processQueryResults(List<QuerySpec> querySpecs, ResultSet[] resultSets) {
        PartialUpdate masterUpdate = PartialUpdate.empty();
        for (int i = 0; i < resultSets.length; ++i) {
            PartialUpdate<AlarmState> update = this.processResultSet(querySpecs.get(i), resultSets[i]);
            masterUpdate.updates.addAll(update.updates);
            masterUpdate.deleted.addAll(update.deleted);
            masterUpdate.metadata.putAll(update.metadata);
        }
        masterUpdate.isDelta = false;
        return masterUpdate;
    }

    private PartialUpdate<AlarmState> processResultSet(QuerySpec querySpec, ResultSet resultSet) {
        PartialUpdate result = PartialUpdate.empty();
        ManagedObjectReference mor = AlarmIssueAbsoluteDataValueProviderBase.findQueryObject(querySpec);
        for (ResultItem resultItem : resultSet.items) {
            for (PropertyValue pv : resultItem.properties) {
                IssueInfo issueInfo = (IssueInfo)pv.value;
                if (!(issueInfo.details instanceof TriggeredAlarmDetails)) continue;
                TriggeredAlarmDetails details = (TriggeredAlarmDetails)issueInfo.details;
                ManagedObjectReference alarmStateEntity = details.alarmState.entity;
                PartialUpdateItem update = PartialUpdateItem.of((Object)details.alarmState, (Object)alarmStateEntity);
                AlarmUtil.assignMetadata(update, details.alarmState.key, details.alarmInfo);
                AlarmUtil.assignMetadata(update, "alarmInfoName", issueInfo.entityName);
                AlarmUtil.assignMetadata(update, "showVAMILink", details.showVAMILink);
                AlarmUtil.assignMetadata(update, "issueUri", DefaultUriSchemeUtil.createUri((String)"AlarmIssue", (String)details.alarmState.key));
                AlarmUtil.assignMetadata(update, "issueInfo", issueInfo);
                result.updates.add(update);
            }
        }
        result.deleted.add(ManagedObjectUtil.getRootFolder((String)mor.getServerGuid()));
        result.metadata.put(_TOTAL_COUNT_PREFIX_METADATA_KEY + mor.getServerGuid(), resultSet.totalMatchedObjectCount);
        return result;
    }

    protected static LinkedVcGroup[] getStartupLinkedVcGroup() {
        LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup[] result = registry.getUtils().getStartupLinkedVcGroups();
        return result;
    }

    private static ManagedObjectReference findQueryObject(QuerySpec querySpec) {
        PropertyConstraint propConstraint = (PropertyConstraint)querySpec.resourceSpec.constraint;
        ManagedObjectReference mor = (ManagedObjectReference)propConstraint.comparableValue;
        return mor;
    }
}

