/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.ServiceAlarmInfo;
import com.vmware.opsmgmt.client.alarms.util.AlarmInfoRetriever;
import com.vmware.opsmgmt.client.alarms.util.AlarmStateRetriever;
import com.vmware.opsmgmt.client.alarms.util.EntityNameRetriever;
import com.vmware.opsmgmt.client.alarms.util.IssueInfoBuilder;
import com.vmware.opsmgmt.client.alarms.util.LabelAndIconRetriever;
import com.vmware.opsmgmt.client.alarms.util.ServiceAlarmInfoRetriever;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

@type(value="Issue,AlarmIssue")
public class AlarmIssueAdapter
extends IssueAdapterBase {
    private static final IssueAdapterBase.IssueData[] _EMPTY_ISSUE_DATA = new IssueAdapterBase.IssueData[0];
    private DataService _dataService;
    private final AlarmStateRetriever _alarmStateRetriever;
    private final AlarmInfoRetriever _alarmInfoRetriever;
    private final IssueInfoBuilder _issueInfoBuilder;
    private final EntityNameRetriever _entityNameRetriever;
    private ServiceAlarmInfoRetriever _serviceAlarmInfoRetriever;

    public AlarmIssueAdapter(DataService dataService, QuerySpecBuilder querySpecBuilder, ThreadPoolExecutor executor) {
        super("AlarmIssue", executor);
        this._dataService = dataService;
        this._alarmStateRetriever = new AlarmStateRetriever(dataService, querySpecBuilder);
        this._alarmInfoRetriever = new AlarmInfoRetriever(dataService);
        this._entityNameRetriever = new EntityNameRetriever(dataService);
        this._issueInfoBuilder = new IssueInfoBuilder();
    }

    public void setServiceAlarmInfoRetriever(ServiceAlarmInfoRetriever serviceAlarmInfoRetriever) {
        this._serviceAlarmInfoRetriever = serviceAlarmInfoRetriever;
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        PropertyConstraint propConstraint;
        if (querySpec.resourceSpec.constraint instanceof PropertyConstraint && AlarmIssueAdapter.isForEntity(propConstraint = (PropertyConstraint)querySpec.resourceSpec.constraint)) {
            return this.getIssuesForEntity(querySpec, context);
        }
        return this.getAllIssues(querySpec, context);
    }

    protected ResultSet processResultSet(ResultSet result, QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        if (context.context != null) {
            result.totalMatchedObjectCount = (Integer)context.context;
        }
        return result;
    }

    private IssueAdapterBase.IssueData[] getIssuesForEntity(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        Object entity = this.extractEntityFromQuerySpec(querySpec);
        if (!(entity instanceof ManagedObjectReference)) {
            return _EMPTY_ISSUE_DATA;
        }
        ManagedObjectReference mor = (ManagedObjectReference)entity;
        ArrayList<Object> objects = new ArrayList<Object>(1);
        objects.add(entity);
        return this.getAllIssuesInternal(context, objects, AlarmIssueAdapter.getTargetType(querySpec), AlarmIssueAdapter.getMaxResultCount(querySpec), AlarmIssueAdapter.getPropertySpecs(querySpec), ManagedObjectUtil.isRootFolder((ManagedObjectReference)mor), querySpec.name, AlarmIssueAdapter.getOffset(querySpec));
    }

    private IssueAdapterBase.IssueData[] getAllIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        Object[] vcGroups = AlarmIssueAdapter.getStartupLinkedVcGroup();
        if (ArrayUtil.isNullOrEmpty((Object[])vcGroups)) {
            return _EMPTY_ISSUE_DATA;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object vcGroup : vcGroups) {
            for (VcService vc : vcGroup.getVcServices()) {
                objects.add(ManagedObjectUtil.getRootFolder((String)vc.getServiceGuid()));
            }
        }
        if (objects.isEmpty()) {
            return _EMPTY_ISSUE_DATA;
        }
        return this.getAllIssuesInternal(context, objects, AlarmIssueAdapter.getTargetType(querySpec), AlarmIssueAdapter.getMaxResultCount(querySpec), AlarmIssueAdapter.getPropertySpecs(querySpec), true, querySpec.name, AlarmIssueAdapter.getOffset(querySpec));
    }

    private IssueAdapterBase.IssueData[] getAllIssuesInternal(IssueAdapterBase.RequestContext context, List<Object> objects, String issueType, Integer maxResultCount, PropertySpec[] propertySpecs, boolean isServiceAlarmInfoNeeded, String queryName, Integer offset) {
        boolean isPerformanceLoggerInfoEnabled = _performanceLogger.isInfoEnabled();
        long startTime = 0L;
        long stopTime = 0L;
        if (isPerformanceLoggerInfoEnabled) {
            startTime = System.currentTimeMillis();
        }
        AlarmStateRetriever.Result result = this._alarmStateRetriever.retrieve(true, objects, issueType, maxResultCount, offset);
        if (isPerformanceLoggerInfoEnabled) {
            stopTime = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: AlarmsStates retrieved in %d milliseconds.", queryName, stopTime - startTime));
        }
        Object[] triggeredAlarms = result.alarms;
        int totalAlarms = result.totalAlarms;
        Map<String, ServiceAlarmInfo> serviceAlarmInfosMap = Collections.emptyMap();
        if (!ArrayUtil.isNullOrEmpty((Object[])triggeredAlarms) && isServiceAlarmInfoNeeded) {
            int displayedAlarms = triggeredAlarms.length;
            ArrayList<Object> triggeredAlarmsList = new ArrayList<Object>(Arrays.asList(triggeredAlarms));
            if (isPerformanceLoggerInfoEnabled) {
                startTime = System.currentTimeMillis();
            }
            serviceAlarmInfosMap = this._serviceAlarmInfoRetriever.retrieve(triggeredAlarmsList, queryName);
            if (isPerformanceLoggerInfoEnabled) {
                stopTime = System.currentTimeMillis();
                _performanceLogger.info((Object)String.format("%s: ServiceAlarmInfosMap retrieved in %d ms.", queryName, stopTime - startTime));
            }
            triggeredAlarms = triggeredAlarmsList.toArray(new AlarmState[triggeredAlarmsList.size()]);
            totalAlarms -= displayedAlarms - triggeredAlarms.length;
        }
        context.context = totalAlarms;
        return this.convertToAlarmIssues((AlarmState[])triggeredAlarms, serviceAlarmInfosMap, propertySpecs, queryName);
    }

    private IssueAdapterBase.IssueData[] convertToAlarmIssues(AlarmState[] triggeredAlarms, Map<String, ServiceAlarmInfo> serviceAlarmInfos, PropertySpec[] propertySpecs, String queryName) {
        boolean isPerformanceLoggerInfoEnabled = _performanceLogger.isInfoEnabled();
        long startTime = 0L;
        long stopTime = 0L;
        if (ArrayUtil.isNullOrEmpty((Object[])triggeredAlarms)) {
            return new IssueAdapterBase.IssueData[0];
        }
        LabelAndIconRetriever labelIconRetriever = new LabelAndIconRetriever(this._dataService);
        labelIconRetriever.retrieve(triggeredAlarms, propertySpecs);
        if (isPerformanceLoggerInfoEnabled) {
            startTime = System.currentTimeMillis();
        }
        Map<ManagedObjectReference, AlarmInfo> alarmInfos = this._alarmInfoRetriever.retrieve(triggeredAlarms);
        if (isPerformanceLoggerInfoEnabled) {
            stopTime = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: AlarmInfos retrieved in %d ms.", queryName, stopTime - startTime));
            startTime = stopTime;
        }
        Map<ManagedObjectReference, String> entityNames = this._entityNameRetriever.retrieve(triggeredAlarms, alarmInfos);
        if (isPerformanceLoggerInfoEnabled) {
            stopTime = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: EntityNames retrieved in %d ms.", queryName, stopTime - startTime));
        }
        ArrayList<IssueAdapterBase.IssueData> issues = new ArrayList<IssueAdapterBase.IssueData>();
        for (int i = 0; i < triggeredAlarms.length; ++i) {
            IssueInfo alarmIssueInfo;
            AlarmState alarm = triggeredAlarms[i];
            if (alarm == null || (alarmIssueInfo = this._issueInfoBuilder.build(alarm, alarmInfos, entityNames, labelIconRetriever.getIconIds(), labelIconRetriever.getLabelIds(), serviceAlarmInfos.get(Util.buildAlarmKey(alarm)))) == null) continue;
            IssueAdapterBase.IssueData issue = new IssueAdapterBase.IssueData();
            issue.key = Util.buildAlarmKey(alarm);
            issue.issueInfo = alarmIssueInfo;
            issues.add(issue);
        }
        return issues.toArray(new IssueAdapterBase.IssueData[issues.size()]);
    }

    private static boolean isForEntity(PropertyConstraint propConstraint) {
        return Comparator.EQUALS.equals((Object)propConstraint.comparator) && "info.entity".equals(propConstraint.propertyName);
    }

    private static String getTargetType(QuerySpec querySpec) {
        return querySpec.resourceSpec.constraint.targetType;
    }

    private static Integer getMaxResultCount(QuerySpec querySpec) {
        return querySpec.resultSpec.maxResultCount;
    }

    private static Integer getOffset(QuerySpec querySpec) {
        return querySpec.resultSpec.offset;
    }

    private static PropertySpec[] getPropertySpecs(QuerySpec querySpec) {
        return querySpec.resourceSpec.propertySpecs;
    }

    private static LinkedVcGroup[] getStartupLinkedVcGroup() {
        LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup[] result = registry.getUtils().getStartupLinkedVcGroups();
        return result;
    }
}

