/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.classification;

import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public abstract class EventClassificationAdapterBase
implements DataProviderAdapter {
    public Response getData(RequestSpec request) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{request});
        QuerySpec[] querySpecs = request.querySpec;
        ResultSet[] resultSets = new ResultSet[querySpecs.length];
        for (int i = 0; i < querySpecs.length; ++i) {
            resultSets[i] = this.processQuerySpec(querySpecs[i]);
        }
        Response response = new Response();
        response.resultSet = resultSets;
        return response;
    }

    protected abstract String getUriId();

    protected abstract Map<String, Set<String>> getEventClassification();

    protected abstract Set<String> getEventClassification(String var1);

    private ResultSet processQuerySpec(QuerySpec querySpec) {
        if (querySpec == null || querySpec.resourceSpec == null || querySpec.resourceSpec.constraint == null) {
            throw new IllegalArgumentException("Invalid query spec");
        }
        ResultSet resultSet = this.buildResultSet(querySpec);
        return resultSet;
    }

    private ResultSet buildResultSet(QuerySpec querySpec) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = DefaultUriSchemeUtil.createUri((String)"EventClassification", (String)this.getUriId());
        resultItem.properties = this.buildResultProperties(querySpec);
        ResultSet resultSet = new ResultSet();
        resultSet.queryName = querySpec.name;
        resultSet.totalMatchedObjectCount = 1;
        resultSet.items = new ResultItem[]{resultItem};
        return resultSet;
    }

    private PropertyValue[] buildResultProperties(QuerySpec querySpec) {
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (this.allEventsAreRequested(querySpec)) {
            result.add(this.buildAllEventsProperty());
        }
        if (this.eventsByMoTypeAreRequested(querySpec)) {
            result.add(this.buildEventsByTypeProperty(querySpec));
        }
        return result.toArray(new PropertyValue[result.size()]);
    }

    private boolean allEventsAreRequested(QuerySpec querySpec) {
        if (ArrayUtil.isNullOrEmpty((Object[])querySpec.resourceSpec.propertySpecs)) {
            return false;
        }
        for (PropertySpec propSpec : querySpec.resourceSpec.propertySpecs) {
            for (String property : propSpec.propertyNames) {
                if (!"allEvents".equals(property)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean eventsByMoTypeAreRequested(QuerySpec querySpec) {
        if (ArrayUtil.isNullOrEmpty((Object[])querySpec.resourceSpec.propertySpecs)) {
            return false;
        }
        for (PropertySpec propSpec : querySpec.resourceSpec.propertySpecs) {
            for (String property : propSpec.propertyNames) {
                if (!"eventsByObjectType".equals(property)) continue;
                return true;
            }
        }
        return false;
    }

    private PropertyValue buildAllEventsProperty() {
        Map<String, Set<String>> allEvents = this.getEventClassification();
        PropertyValue pv = new PropertyValue();
        pv.propertyName = "allEvents";
        pv.value = allEvents;
        return pv;
    }

    private PropertyValue buildEventsByTypeProperty(QuerySpec querySpec) {
        Set<String> eventsByType = null;
        String objectType = this.getObjectType(querySpec);
        if (objectType != null) {
            eventsByType = this.getEventClassification(objectType);
        }
        PropertyValue pv = new PropertyValue();
        pv.propertyName = "eventsByObjectType";
        pv.value = eventsByType;
        return pv;
    }

    private String getObjectType(QuerySpec querySpec) {
        if (!(querySpec.resourceSpec.constraint instanceof PropertyConstraint)) {
            return null;
        }
        PropertyConstraint pc = (PropertyConstraint)querySpec.resourceSpec.constraint;
        if (!pc.propertyName.equals("objectType")) {
            throw new IllegalArgumentException("Invalid constraint: property " + pc.propertyName + " not supported");
        }
        if (!Comparator.EQUALS.equals((Object)pc.comparator)) {
            throw new IllegalArgumentException("Invalid constraint: comparator " + pc.comparator + " not supported");
        }
        if (pc.comparableValue == null) {
            throw new IllegalArgumentException("Invalid constraint: null comparable value");
        }
        return pc.comparableValue.toString();
    }
}

