/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.impl.EventFilter;
import com.vmware.opsmgmt.client.event.impl.EventProvider;
import com.vmware.opsmgmt.client.event.util.Util;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseEventProcessor
implements DataProviderAdapter {
    private static final Log _logger = LogFactory.getLog(BaseEventProcessor.class);
    protected static final String EVENT_TYPE = Event.class.getSimpleName();

    protected abstract TypeInfo getTypeInfo();

    public BaseEventProcessor(DataServiceExtensionRegistry registry) {
        registry.registerDataAdapter((DataProviderAdapter)this, this.getProvidedTypes());
    }

    private String[] getProvidedTypes() {
        return new String[]{this.getTypeInfo().type};
    }

    public Response getData(RequestSpec request) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{request});
        QuerySpec[] querySpecs = request.querySpec;
        ResultSet[] resultSets = new ResultSet[querySpecs.length];
        for (int i = 0; i < querySpecs.length; ++i) {
            resultSets[i] = this.getData(querySpecs[i]);
        }
        Response response = new Response();
        response.resultSet = resultSets;
        return response;
    }

    protected ResultSet getData(QuerySpec spec) {
        if (!this.isValidQuery(spec)) {
            return null;
        }
        ResultSet resultSet = new ResultSet();
        resultSet.queryName = spec.name;
        try {
            EventFilter filter = new EventFilter(spec);
            ResultSet previousEvents = null;
            EventProvider.ConsolidatedEvents instances = this.processQuery(filter);
            if (!ArrayUtil.isNullOrEmpty((Object[])filter.migrationHistoryList)) {
                int matchCount = 0;
                for (Map.Entry<ManagedObjectReference, List<Event>> entry : instances.events.entrySet()) {
                    List<Event> serverEvents = entry.getValue();
                    matchCount += serverEvents.size();
                }
                if (filter.count > matchCount) {
                    previousEvents = this.getMigratedResults(spec, filter, filter.count - matchCount);
                }
            }
            ArrayList<MethodFault> postProcessErrors = new ArrayList<MethodFault>();
            List<ResultItem> resultList = this.processEventsResult(instances.events, postProcessErrors, spec);
            Exception processedErrors = this.processErrorResult(instances.errors, postProcessErrors);
            ResultItem[] newResults = resultList.toArray(new ResultItem[resultList.size()]);
            if (previousEvents != null && previousEvents.items != null && previousEvents.items.length > 0) {
                ResultItem[] resultArray = new ResultItem[resultList.size() + previousEvents.items.length];
                System.arraycopy(newResults, 0, resultArray, 0, newResults.length);
                System.arraycopy(previousEvents.items, 0, resultArray, newResults.length, previousEvents.items.length);
                resultSet.items = resultArray;
            } else {
                resultSet.items = newResults;
            }
            resultSet.totalMatchedObjectCount = resultSet.items.length;
            resultSet.error = processedErrors;
        }
        catch (Exception ex) {
            _logger.error((Object)("Error in getData for querySpec: " + spec.name), (Throwable)ex);
            resultSet.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return resultSet;
    }

    private ResultSet getMigratedResults(QuerySpec spec, EventFilter filter, int count) {
        ResultSet migratedEvents = null;
        ManagedObjectReference currentMOR = filter.eventFilterSpec.entity.entity;
        if (filter.requestingPrevPage) {
            for (int index = 0; index < filter.migrationHistoryList.length - 1; ++index) {
                if (!ManagedObjectUtil.areEqual((ManagedObjectReference)currentMOR, (ManagedObjectReference)filter.migrationHistoryList[index]).booleanValue() || index >= filter.migrationHistoryList.length + 1) continue;
                QuerySpec newSpec = Util.makeReplacementQuerySpec(spec, filter.migrationHistoryList[index + 1], count);
                migratedEvents = this.getData(newSpec);
            }
        } else {
            for (int index = filter.migrationHistoryList.length - 1; index >= 1; --index) {
                if (!ManagedObjectUtil.areEqual((ManagedObjectReference)currentMOR, (ManagedObjectReference)filter.migrationHistoryList[index]).booleanValue() || index <= 0) continue;
                QuerySpec newSpec = Util.makeReplacementQuerySpec(spec, filter.migrationHistoryList[index - 1], count);
                migratedEvents = this.getData(newSpec);
            }
        }
        return migratedEvents;
    }

    protected abstract List<ResultItem> processEventsResult(Map<ManagedObjectReference, List<Event>> var1, List<MethodFault> var2, QuerySpec var3);

    private boolean isValidQuery(QuerySpec spec) {
        if (spec.resourceSpec == null) {
            return false;
        }
        PropertySpec[] propertySpecs = spec.resourceSpec.propertySpecs;
        String[] validProperties = this.getTypeInfo().properties;
        for (int i = 0; i < propertySpecs.length; ++i) {
            String[] props = propertySpecs[i].propertyNames;
            for (int j = 0; j < props.length; ++j) {
                for (int k = 0; k < validProperties.length; ++k) {
                    if (!validProperties[k].equals(props[j])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private EventProvider.ConsolidatedEvents processQuery(EventFilter filter) {
        if (filter.eventFilterSpec.eventChainId != null && filter.eventFilterSpec.eventChainId <= 0) {
            return new EventProvider.ConsolidatedEvents(new HashMap<ManagedObjectReference, List<Event>>(), new HashMap<ManagedObjectReference, Exception>());
        }
        List<VcService> services = this.getServices(filter);
        EventProvider eventProvider = new EventProvider(services, filter);
        return eventProvider.collect();
    }

    private Exception processErrorResult(Map<ManagedObjectReference, Exception> errors, List<MethodFault> additionalErrors) {
        if ((errors == null || errors.isEmpty()) && (additionalErrors == null || additionalErrors.isEmpty())) {
            return null;
        }
        int errorsSize = errors != null ? errors.size() : 0;
        int additionalErrorsSize = additionalErrors != null ? additionalErrors.size() : 0;
        ArrayList<MethodFault> faults = new ArrayList<MethodFault>(errorsSize + additionalErrorsSize);
        if (errorsSize > 0) {
            for (Exception exc : errors.values()) {
                faults.add(MixedUtil.getMethodFault((Throwable)exc));
            }
        }
        if (additionalErrorsSize > 0) {
            faults.addAll(additionalErrors);
        }
        return new CompositeException(faults);
    }

    private List<VcService> getServices(EventFilter filter) {
        ArrayList<VcService> services = new ArrayList<VcService>();
        if (!StringUtil.isNullOrEmpty((String)filter.serverGuid)) {
            VcService service = VimSessionUtil.getService((String)filter.serverGuid);
            if (service != null) {
                services.add(service);
            }
        } else {
            LinkedVcGroup[] groups;
            LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry();
            for (LinkedVcGroup vcGroup : groups = registry.getLinkedVcGroups()) {
                Collection vcServices = vcGroup.getVcServices();
                services.addAll(vcServices);
            }
        }
        return services;
    }
}

