/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.EventDetailDescription;
import com.vmware.opsmgmt.client.event.ExportEvent;
import com.vmware.opsmgmt.client.event.impl.BaseEventProcessor;
import com.vmware.opsmgmt.client.event.impl.EventDescriptionCollector;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.vim.commons.MixedUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ExportEventProcessor
extends BaseEventProcessor {
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("[\n\r]");
    private static final String EXPORT_EVENTS_PROPERTY_NAME = "entityExportEvents";
    private final DataService _dataService;

    public ExportEventProcessor(DataService dataService, DataServiceExtensionRegistry registry) {
        super(registry);
        this._dataService = dataService;
    }

    @Override
    protected TypeInfo getTypeInfo() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = BaseEventProcessor.EVENT_TYPE;
        typeInfo.properties = new String[]{EXPORT_EVENTS_PROPERTY_NAME};
        return typeInfo;
    }

    @Override
    protected List<ResultItem> processEventsResult(Map<ManagedObjectReference, List<Event>> events, List<MethodFault> faults, QuerySpec spec) {
        ArrayList<ResultItem> result = new ArrayList<ResultItem>();
        for (Map.Entry<ManagedObjectReference, List<Event>> entry : events.entrySet()) {
            ExportEvent[] clientEvents = new ExportEvent[]{};
            try {
                List<Event> serverEvents = entry.getValue();
                String serverGuild = entry.getKey().getServerGuid();
                clientEvents = this.transformToExportEvents(serverEvents, serverGuild);
            }
            catch (Exception ex) {
                faults.add(MixedUtil.getMethodFault((Throwable)ex));
            }
            PropertyValue property = new PropertyValue();
            property.propertyName = EXPORT_EVENTS_PROPERTY_NAME;
            property.value = clientEvents;
            ResultItem item = new ResultItem();
            item.properties = new PropertyValue[]{property};
            item.resourceObject = entry.getKey();
            result.add(item);
        }
        return result;
    }

    private ExportEvent[] transformToExportEvents(List<Event> serverEvents, String serverGuid) throws Exception {
        if (serverEvents.size() == 0) {
            return new ExportEvent[0];
        }
        EventDescriptionCollector collector = EventDescriptionCollector.getEventDetailDescriptionCollector(serverGuid, this._dataService);
        ExportEvent[] exportEvents = new ExportEvent[serverEvents.size()];
        int index = 0;
        for (Event serverEvent : serverEvents) {
            ExportEvent event = new ExportEvent();
            event.createdTime = serverEvent.createdTime;
            event.eventTypeId = this.getEventTypeId(serverEvent, true);
            event.category = this.getCategory(serverEvent, collector);
            event.fullFormattedMessage = serverEvent.fullFormattedMessage;
            if (event.fullFormattedMessage != null) {
                event.fullFormattedMessage = NEW_LINE_PATTERN.matcher(event.fullFormattedMessage).replaceAll("");
            }
            exportEvents[index++] = event;
        }
        return exportEvents;
    }

    private String getEventTypeId(Event serverEvent, boolean simpleName) {
        String eventTypeId = null;
        eventTypeId = serverEvent instanceof ExtendedEvent ? ((ExtendedEvent)serverEvent).eventTypeId : (serverEvent instanceof EventEx ? ((EventEx)serverEvent).eventTypeId : (simpleName ? serverEvent.getClass().getSimpleName() : serverEvent.getClass().getName()));
        return eventTypeId;
    }

    private String getCategory(Event serverEvent, EventDescriptionCollector collector) {
        EventDescription.EventDetail eventDetail;
        String eventType = this.getEventTypeId(serverEvent, false);
        EventDetailDescription[] descriptions = collector.collectDetails(new String[]{eventType});
        String category = null;
        if (descriptions != null && descriptions.length == 1 && descriptions[0] != null && (eventDetail = descriptions[0].eventDetail) != null) {
            category = eventDetail.category;
        }
        return category;
    }
}

