/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.commons.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.wsdlName;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MorUtil {
    private static final Pattern URI_FORMAT = Pattern.compile("([\\p{Alnum}_-]+):([\\p{Alnum}_-]+)");

    private MorUtil() {
    }

    public static ManagedObjectReference buildMor(String sGuid, String type, String value) {
        ManagedObjectReference mor = new ManagedObjectReference();
        mor.setServerGuid(sGuid);
        mor.setType(type);
        mor.setValue(value);
        return mor;
    }

    public static ManagedObjectReference buildMor(String sGuid, Class<?> type_BindingClass, String value) throws RuntimeException {
        wsdlName wsdlNameAnnotation = type_BindingClass.getAnnotation(wsdlName.class);
        if (wsdlNameAnnotation == null) {
            throw new RuntimeException(type_BindingClass.getName() + " class is not a valid binding");
        }
        String vmodlType = wsdlNameAnnotation.value();
        return MorUtil.buildMor(sGuid, vmodlType, value);
    }

    @Deprecated
    public static ManagedObjectReference buildMor(String sGuid, String uri) {
        Matcher uriFormatter = URI_FORMAT.matcher(uri);
        if (!uriFormatter.matches()) {
            throw new IllegalArgumentException("Uri format is incorrect: " + uri + ". Expected format is: <MO_type>:<MO_value>");
        }
        return MorUtil.buildMor(sGuid, uriFormatter.group(1), uriFormatter.group(2));
    }

    @Deprecated
    public static URI toURI(ManagedObjectReference mor) throws URISyntaxException {
        return new URI(mor.getType() + ":" + mor.getValue());
    }
}

