/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.host.HostAccessManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.host.util.Util;

public class HostAccessPropertyProvider
implements PropertyProviderBean {
    DataService _dataService;

    public HostAccessPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="HostSystem")
    public String getLockdownMode(ManagedObjectReference hostRef) throws Exception {
        HostAccessManager.LockdownMode lockdownMode = HostAccessManager.LockdownMode.lockdownDisabled;
        HostAccessManager hostAccessMgr = Util.getHostAccessManager(hostRef);
        if (hostAccessMgr != null) {
            lockdownMode = hostAccessMgr.getLockdownMode();
        } else {
            Object value = QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"config.adminDisabled");
            if (value != null && ((Boolean)value).booleanValue()) {
                lockdownMode = HostAccessManager.LockdownMode.lockdownNormal;
            }
        }
        return lockdownMode.toString();
    }

    @type(value="HostSystem")
    public String[] getExceptionUsers(ManagedObjectReference hostRef) throws Exception {
        HostAccessManager hostAccessMgr = Util.getHostAccessManager(hostRef);
        if (hostAccessMgr != null) {
            return hostAccessMgr.queryLockdownExceptions();
        }
        return new String[0];
    }

    @type(value="HostSystem")
    public Boolean getIsHostAccessManagerAvailable(ManagedObjectReference hostRef) throws Exception {
        return Util.getHostAccessManager(hostRef) != null;
    }
}

