/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.host.ActiveDirectoryAuthentication;
import com.vmware.vim.binding.vim.host.ActiveDirectoryInfo;
import com.vmware.vim.binding.vim.host.BootDeviceInfo;
import com.vmware.vim.binding.vim.host.BootDeviceSystem;
import com.vmware.vim.binding.vim.host.CpuSchedulerSystem;
import com.vmware.vim.binding.vim.host.DateTimeSystem;
import com.vmware.vim.binding.vim.host.DnsConfig;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.ImageConfigManager;
import com.vmware.vim.binding.vim.host.IscsiManager;
import com.vmware.vim.binding.vim.host.LocalDatastoreInfo;
import com.vmware.vim.binding.vim.host.MemoryManagerSystem;
import com.vmware.vim.binding.vim.host.NasDatastoreInfo;
import com.vmware.vim.binding.vim.host.PowerSystem;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.option.OptionDef;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vim.vm.ConfigTarget;
import com.vmware.vim.binding.vim.vm.DatastoreInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.TypeNodeDescriptor;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreUtil;
import com.vmware.vise.vim.commons.ssl.SslUtil;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.impl.VcServiceImpl;
import com.vmware.vise.vim.data.QueryDataUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vsphere.client.advancedsettings.AdvancedSettingsUtil;
import com.vmware.vsphere.client.host.HostDataRetrieverException;
import com.vmware.vsphere.client.host.HostManifestInfo;
import com.vmware.vsphere.client.host.MemoryConfigInfo;
import com.vmware.vsphere.client.host.StorageCountInfo;
import com.vmware.vsphere.client.host.dsclusterconnectivity.HostDatastoreClusterConnectivityInfo;
import com.vmware.vsphere.client.host.dsclusterconnectivity.HostDatastoreClusterConnectivityInfoService;
import com.vmware.vsphere.client.host.impl.HostDataRetrieverDsImpl;
import com.vmware.vsphere.client.host.perfstats.MemoryAvailableForVmRetriever;
import com.vmware.vsphere.client.host.standbyinfo.HostStandbyInfo;
import com.vmware.vsphere.client.host.util.Util;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.net.util.IPAddressUtil;

public class HostPropertyProvider
implements PropertyProviderBean {
    private static final Log LOG = LogFactory.getLog(HostPropertyProvider.class);
    private static final int DEFAULT_HOST_PORT = 443;
    private static final String HOST_NAME_PROPERTY = "name";
    private static final String HOST_PORT_PROPERTY = "summary.config.port";
    private static final String HOST_THUMBPRINT_PROPERTY = "summary.config.sslThumbprint";
    private static final String HOST_AUTH_CONFIG_PROPERTY = "config.authenticationManagerInfo.authConfig";
    private static final String HOST_VERSION = "config.product.version";
    private static final String VERSION_5_0_0 = "5.0.0";
    private static final String VERSION_6_0_0 = "6.0.0";
    private static final String HOST_DATASTORE_PROPERTY = "datastore";
    private static final String CONN_STATE = "runtime.connectionState";
    private static final String HOST_IS_STANDALONE_PROP = "isStandalone";
    private static final String HOST_URL_PROTOCOL = "https://";
    private static final String IPV6_HOSTNAME_PREFIX = "[";
    private static final String IPV6_HOSTNAME_SUFFIX = "]";
    private static final String LIST_MANIFESTS_SCRIPT = "/cgi-bin/vm-support.cgi?listmanifests=1";
    private static final String AUTH_COOKIE_PREFIX = "vmware_cgi_ticket=";
    private final DataService _dataService;
    private final HostDatastoreClusterConnectivityInfoService _hostDsClusterConnectivityInfoService;
    private final MemoryAvailableForVmRetriever _memoryAvailableForVmRetriever;
    private final QueryExecutor _queryExecutor;

    public HostPropertyProvider(DataService dataService, HostDatastoreClusterConnectivityInfoService hostClusterConnectivityInfoService, MemoryAvailableForVmRetriever memoryAvailableForVmRetriever, QueryExecutor queryExecutor) {
        this._dataService = dataService;
        this._hostDsClusterConnectivityInfoService = hostClusterConnectivityInfoService;
        this._memoryAvailableForVmRetriever = memoryAvailableForVmRetriever;
        this._queryExecutor = queryExecutor;
    }

    @type(value="HostSystem")
    public String getHostSslThumbprint(ManagedObjectReference hostRef) throws Exception {
        String sslThumbprint = "";
        String hostSystemUrl = this.retrieveHostSystemUrl(hostRef);
        if (hostSystemUrl != null) {
            try {
                LoginSpec spec = new LoginSpec();
                spec.serviceUrl = hostSystemUrl;
                VcServiceImpl.newBuilder((LoginSpec)spec).build();
            }
            catch (CertificateValidationException ex) {
                sslThumbprint = ex.getThumbprint();
            }
        }
        return sslThumbprint;
    }

    @type(value="HostSystem")
    public DatastoreInfo[] getConfigTargetDatastoreInfo(ManagedObjectReference hostSystemRef) throws Exception {
        HostDataRetrieverDsImpl hdr = new HostDataRetrieverDsImpl(this._dataService, hostSystemRef);
        try {
            EnvironmentBrowser environmentBrowser = hdr.getEnvironmentBrowser();
            ConfigTarget configTarget = environmentBrowser.queryConfigTarget(hostSystemRef);
            return configTarget.datastore;
        }
        catch (HostDataRetrieverException e) {
            this.logError(hostSystemRef, e);
            return null;
        }
    }

    @type(value="HostSystem")
    public DnsConfig getDnsConfig(ManagedObjectReference hostRef) throws Exception {
        LOG.debug((Object)("Retrieving DnsConfig info for " + hostRef.getValue()));
        HostDataRetrieverDsImpl hdr = new HostDataRetrieverDsImpl(this._dataService, hostRef);
        try {
            DnsConfig dnsConfig = hdr.getDnsConfig();
            return dnsConfig;
        }
        catch (HostDataRetrieverException ex) {
            this.logError(hostRef, ex);
            return null;
        }
    }

    @type(value="HostSystem")
    public CpuSchedulerSystem.HyperThreadScheduleInfo getHyperthreadingInfo(ManagedObjectReference hostRef) throws Exception {
        HostDataRetrieverDsImpl hdr = new HostDataRetrieverDsImpl(this._dataService, hostRef);
        try {
            return hdr.getHyperThreadScheduleInfo();
        }
        catch (Exception ex) {
            this.logError(hostRef, ex);
            return null;
        }
    }

    @type(value="HostSystem")
    public MemoryConfigInfo getMemoryConfigInfo(ManagedObjectReference hostRef) throws Exception {
        MemoryConfigInfo retVal = new MemoryConfigInfo();
        try {
            long memorySizeInBytes = 0L;
            Number memorySizeAsObject = (Number)this._queryExecutor.getProperty((Object)hostRef, "hardware.memorySize");
            if (memorySizeAsObject != null) {
                memorySizeInBytes = memorySizeAsObject.longValue();
            }
            retVal.capacity = memorySizeInBytes / 0x100000L;
            double memoryAvailableForVm = this._memoryAvailableForVmRetriever.getMemoryAvailableForVm(this.getPerformanceManager(hostRef), hostRef);
            if (memoryAvailableForVm != -1.0) {
                retVal.virtualMachines = memoryAvailableForVm;
                retVal.serviceConsole = 0.0;
                retVal.system = 0.0;
                if (retVal.capacity > 0.0) {
                    retVal.system = retVal.capacity - retVal.virtualMachines;
                }
            } else {
                Number virtualMachinesAsObject = (Number)this._queryExecutor.getProperty((Object)hostRef, "systemResources.config.memoryAllocation.reservation");
                retVal.virtualMachines = virtualMachinesAsObject != null ? virtualMachinesAsObject.doubleValue() : 0.0;
                MemoryManagerSystem.ServiceConsoleReservationInfo consoleInfo = this.getConsoleReservationInfo(hostRef);
                double serviceConsoleReservedB = 0.0;
                if (consoleInfo != null) {
                    serviceConsoleReservedB = consoleInfo.getServiceConsoleReserved();
                }
                retVal.serviceConsole = serviceConsoleReservedB / 1048576.0;
                retVal.system = 0.0;
                if (retVal.capacity > 0.0) {
                    retVal.system = retVal.capacity - retVal.serviceConsole - retVal.virtualMachines;
                }
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)("Exception caught when retrieving data for " + hostRef.getValue()), (Throwable)e);
            return null;
        }
        return retVal;
    }

    @type(value="HostSystem")
    public Calendar getCurrentTimeOnHost(ManagedObjectReference hostSystemRef) throws Exception {
        HostDataRetrieverDsImpl hdr = new HostDataRetrieverDsImpl(this._dataService, hostSystemRef);
        try {
            DateTimeSystem dtSystem = hdr.getDateTimeSystem();
            Calendar date = dtSystem.queryDateTime();
            return date;
        }
        catch (Exception ex) {
            LOG.error((Object)("Exception caught when retrieving currentTimeOnHost for " + hostSystemRef.getValue()));
            return null;
        }
    }

    @ModelMetadata(type={"HostSystem"}, property="advancedSettings")
    public DynamicObject getAdvancedSettingsValues(ManagedObjectReference hostRef) {
        DynamicObject result = new DynamicObject();
        try {
            OptionManager optionManager = Util.getHostOptionManager(hostRef);
            if (optionManager == null) {
                return null;
            }
            OptionValue[] optionValues = optionManager.getSetting();
            AdvancedSettingsUtil.sortOptionValues((OptionValue[])optionValues);
            NameValuePair[] nameValuePairs = AdvancedSettingsUtil.createNameValuePairsFromOptionValues((OptionValue[])optionValues);
            result.properties = nameValuePairs;
        }
        catch (Exception ex) {
            LOG.error((Object)("Exception caught when retrieving advancedSettings for " + hostRef.getValue()));
            result.properties = new NameValuePair[0];
        }
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, property="advancedSettings.@info")
    public TypeNodeDescriptor getAdvancedSettingsMetadata(ManagedObjectReference hostRef) {
        TypeNodeDescriptor result = new TypeNodeDescriptor();
        try {
            OptionManager optionManager = Util.getHostOptionManager(hostRef);
            if (optionManager == null) {
                return null;
            }
            OptionDef[] optionDefs = optionManager.getSupportedOption();
            AdvancedSettingsUtil.sortOptionDefs((OptionDef[])optionDefs);
            result.properties = AdvancedSettingsUtil.createMetadataFromOptionDefs((OptionDef[])optionDefs, (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception caught when retrieving advancedSettings.@info for " + hostRef.getValue()));
            result.properties = new PropertyNodeDescriptor[0];
        }
        return result;
    }

    @type(value="HostSystem")
    public HostManifestInfo getManifestArray(ManagedObjectReference hostRef) throws IOException, Exception {
        PropertyValue[] propertyResult = QueryUtil.getProperties((DataService)this._dataService, (Object)hostRef, (String[])new String[]{HOST_NAME_PROPERTY, HOST_VERSION, CONN_STATE, HOST_THUMBPRINT_PROPERTY});
        String hostName = null;
        String version = null;
        String thumbprint = null;
        HostSystem.ConnectionState connectionState = null;
        for (PropertyValue prop : propertyResult) {
            if (prop.propertyName.equals(HOST_NAME_PROPERTY)) {
                hostName = prop.value.toString();
                if (!IPAddressUtil.isIPv6LiteralAddress(hostName)) continue;
                StringBuilder ipv6HostName = new StringBuilder();
                hostName = ipv6HostName.append(IPV6_HOSTNAME_PREFIX).append(hostName).append(IPV6_HOSTNAME_SUFFIX).toString();
                continue;
            }
            if (prop.propertyName.equals(HOST_VERSION)) {
                version = prop.value.toString();
                continue;
            }
            if (prop.propertyName.equals(CONN_STATE)) {
                connectionState = (HostSystem.ConnectionState)prop.value;
                continue;
            }
            if (!prop.propertyName.equals(HOST_THUMBPRINT_PROPERTY)) continue;
            thumbprint = Util.isEsxVersionEqualOrHigher(version, VERSION_6_0_0) ? "" : prop.value.toString();
        }
        if (!Util.isEsxVersionEqualOrHigher(version, VERSION_5_0_0) || !HostSystem.ConnectionState.connected.equals(connectionState)) {
            return new HostManifestInfo();
        }
        StringBuilder remoteURL = new StringBuilder();
        remoteURL.append(HOST_URL_PROTOCOL).append(hostName).append(LIST_MANIFESTS_SCRIPT);
        return this.getManifestArray(hostRef, remoteURL.toString(), thumbprint);
    }

    private HostManifestInfo getManifestArray(ManagedObjectReference hostRef, String remoteURL, String thumbprint) throws IOException, Exception {
        HostManifestInfo hostManifest = new HostManifestInfo();
        SessionManager.GenericServiceTicket ticket = VcServiceUtil.acquireGenericServiceTicket(null, (String)remoteURL, (String)hostRef.getServerGuid());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Cookie", AUTH_COOKIE_PREFIX + ticket.getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("http.protocol.cookie-policy", "rfc2109");
        HttpClient httpClient = null;
        httpClient = StringUtil.isNullOrEmpty((String)thumbprint) ? SslUtil.getHttpClient((KeyStore)KeystoreUtil.getKeyStore()) : SslUtil.getHttpClient((String)thumbprint);
        try {
            String XmlString;
            byte[] xmlBytes = httpClient.executeMethodResponseAsBytes(remoteURL, params, headers);
            hostManifest.manifest = XmlString = new String(xmlBytes);
        }
        catch (Exception ex) {
            LOG.error((Object)("Error fetching manifests from host " + hostRef + " at " + remoteURL), (Throwable)ex);
            return null;
        }
        return hostManifest;
    }

    @type(value="HostSystem")
    public PowerSystem.Capability getPowerSystemCapability(ManagedObjectReference hostRef) throws Exception {
        PowerSystem.PowerPolicy[] availablePolicy = (PowerSystem.PowerPolicy[])QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"config.powerSystemCapability.availablePolicy");
        if (availablePolicy == null || availablePolicy.length == 0) {
            return null;
        }
        PowerSystem.PowerPolicy[] localizedPolicies = new PowerSystem.PowerPolicy[availablePolicy.length];
        for (int i = 0; i < availablePolicy.length; ++i) {
            PowerSystem.PowerPolicy policy = availablePolicy[i];
            PowerSystem.PowerPolicy localizedPolicy = Util.localizePowerPolicy(policy);
            if (localizedPolicy != null) {
                localizedPolicies[i] = localizedPolicy;
                continue;
            }
            if (policy == null) continue;
            localizedPolicies[i] = policy;
        }
        return new PowerSystem.Capability(localizedPolicies);
    }

    @type(value="HostSystem")
    public BootDeviceInfo getBootDeviceInfo(ManagedObjectReference hostSystemRef) throws Exception {
        HostDataRetrieverDsImpl hdr = new HostDataRetrieverDsImpl(this._dataService, hostSystemRef);
        try {
            BootDeviceSystem bds = hdr.getBootDeviceSystem();
            if (bds != null) {
                return bds.queryBootDevices();
            }
        }
        catch (HostDataRetrieverException e) {
            this.logError(hostSystemRef, e);
        }
        BootDeviceInfo blankDevice = new BootDeviceInfo();
        blankDevice.currentBootDeviceKey = "";
        blankDevice.bootDevices = new BootDeviceSystem.BootDevice[0];
        return blankDevice;
    }

    @type(value="HostSystem")
    public StorageCountInfo getStorageCountInfo(ManagedObjectReference hostSystemRef) throws Exception {
        HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostSystemRef);
        Object[] datastores = host.getDatastore();
        StorageCountInfo retVal = new StorageCountInfo();
        ArrayList<String> storagePodList = new ArrayList<String>();
        if (datastores == null || datastores.length == 0) {
            LOG.debug((Object)("GetStorageCountInfo: Host has no attached datastores: " + hostSystemRef));
            return retVal;
        }
        Map _properties = QueryDataUtil.getProperties((DataService)this._dataService, (Object[])datastores, (String[])new String[]{"parent"});
        for (Object dsRef : datastores) {
            String dsString = ManagedObjectUtil.morefToString((ManagedObjectReference)dsRef);
            List dsProps = (List)_properties.get(dsString);
            if (dsProps == null || dsProps.isEmpty()) {
                LOG.error((Object)("No properties received for datastore: " + dsString));
                continue;
            }
            ManagedObjectReference parentRef = (ManagedObjectReference)QueryUtil.findPropertyValueIn((String)"parent", (List)dsProps);
            if (parentRef.getType().equals("StoragePod")) {
                if (storagePodList.contains(parentRef.getValue())) continue;
                storagePodList.add(parentRef.getValue());
                continue;
            }
            ++retVal.standaloneDatastoreCount;
        }
        retVal.storagePodCount = storagePodList.size();
        return retVal;
    }

    @type(value="HostSystem")
    public HostStandbyInfo getHostStandbyInfo(ManagedObjectReference hostRef) throws Exception {
        return Util.getHostStandbyInfo(hostRef);
    }

    @type(value="HostSystem")
    public Boolean getSupportsLockDownMode(ManagedObjectReference hostSystemRef) throws Exception {
        Object productLineId = QueryUtil.getProperty((DataService)this._dataService, (Object)hostSystemRef, (String)"summary.config.product.productLineId");
        if ("embeddedEsx".equals(productLineId)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @type(value="HostSystem")
    public Boolean getFirewallEnabled(ManagedObjectReference hostSystemRef) throws Exception {
        Object fInfo = QueryUtil.getProperty((DataService)this._dataService, (Object)hostSystemRef, (String)"config.firewall");
        if (fInfo == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @type(value="HostSystem")
    public Boolean getServiceEnabled(ManagedObjectReference hostSystemRef) throws Exception {
        Object sInfo = QueryUtil.getProperty((DataService)this._dataService, (Object)hostSystemRef, (String)"config.service");
        if (sInfo == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @type(value="HostSystem")
    public Boolean getImageProfileEnabled(ManagedObjectReference hostSystemRef) throws Exception {
        try {
            boolean icmEnabled = this.getImageConfigManager(hostSystemRef) != null;
            return icmEnabled;
        }
        catch (HostDataRetrieverException e) {
            this.logError(hostSystemRef, e);
            return false;
        }
    }

    @type(value="HostSystem")
    public String getImageProfileName(ManagedObjectReference hostSystemRef) {
        try {
            ImageConfigManager.ImageProfileSummary summary;
            ImageConfigManager icm = this.getImageConfigManager(hostSystemRef);
            if (icm != null && (summary = icm.queryHostImageProfile()) != null) {
                return summary.name;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)" Exception while getting Image profile name", (Throwable)ex);
        }
        return null;
    }

    @type(value="HostSystem")
    public String getImageAcceptanceLevel(ManagedObjectReference hostSystemRef) {
        try {
            ImageConfigManager icm = this.getImageConfigManager(hostSystemRef);
            if (icm != null) {
                String level = icm.queryHostAcceptanceLevel();
                return level;
            }
        }
        catch (Exception e) {
            LOG.error((Object)" Exception while getting Image profile acceptance level", (Throwable)e);
        }
        return null;
    }

    @type(value="HostSystem")
    public Boolean getSupportsAuthServices(ManagedObjectReference hostSystemRef) throws Exception {
        Object productVersion = QueryUtil.getProperty((DataService)this._dataService, (Object)hostSystemRef, (String)HOST_VERSION);
        if (productVersion == null || !Util.isEsxVersion41OrHigher((String)productVersion)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @type(value="HostSystem")
    public Boolean getIsProxyAuthenticationSupported(ManagedObjectReference hostSystemRef) throws Exception {
        ActiveDirectoryAuthentication ada = Util.getActiveDirectoryAuthentication(hostSystemRef, this._queryExecutor);
        return ada != null;
    }

    @type(value="HostSystem")
    public Boolean getIsActiveDirectoryAuthenticationUsed(ManagedObjectReference hostRef) throws Exception {
        Object[] hostAuthenticationStoreInfos = (Object[])QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)HOST_AUTH_CONFIG_PROPERTY);
        if (hostAuthenticationStoreInfos == null) {
            return false;
        }
        for (Object hasi : hostAuthenticationStoreInfos) {
            if (!(hasi instanceof ActiveDirectoryInfo)) continue;
            return ((ActiveDirectoryInfo)hasi).enabled;
        }
        return false;
    }

    @type(value="HostSystem")
    public Boolean getIsSmartCardAuthenticationEnabled(ManagedObjectReference hostRef) throws Exception {
        Object[] hostAuthenticationStoreInfos = (Object[])QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)HOST_AUTH_CONFIG_PROPERTY);
        if (hostAuthenticationStoreInfos == null) {
            return false;
        }
        for (Object hasi : hostAuthenticationStoreInfos) {
            if (!(hasi instanceof ActiveDirectoryInfo)) continue;
            return ((ActiveDirectoryInfo)hasi).smartCardAuthenticationEnabled;
        }
        return false;
    }

    @type(value="HostSystem")
    public X509Spec[] getSmartCardTrustAnchors(ManagedObjectReference hostRef) throws Exception {
        ActiveDirectoryAuthentication activeDirAuth = Util.getActiveDirectoryAuthentication(hostRef, this._queryExecutor);
        if (activeDirAuth == null) {
            LOG.warn((Object)"Unable to retrieve ActiveDirectoryAuthentication instace.");
            return new X509Spec[0];
        }
        String[] tmpArr = activeDirAuth.listSmartCardTrustAnchors();
        if (tmpArr == null) {
            tmpArr = new String[]{};
        }
        X509Spec[] result = new X509Spec[tmpArr.length];
        for (int i = 0; i < result.length; ++i) {
            X509Certificate certificate = CertificateUtil.decodeCertificate((byte[])tmpArr[i].getBytes());
            result[i] = new X509Spec(certificate);
        }
        return result;
    }

    @type(value="HostSystem")
    public FileSystemMountInfo[] getFileSystemMountInfo(ManagedObjectReference hostRef) throws Exception {
        HostDataRetrieverDsImpl hdr = new HostDataRetrieverDsImpl(this._dataService, hostRef);
        FileSystemMountInfo[] fsmi = hdr.getFileSystemMountInfo();
        return fsmi;
    }

    @type(value="HostSystem")
    public String[] getAvailableDatastoreNames(ManagedObjectReference hostMoRef) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            RelationalConstraint dsRelation = QueryUtil.createRelationalConstraint((String)HOST_DATASTORE_PROPERTY, (Constraint)QueryUtil.createObjectIdentityConstraint((Object)hostMoRef), (Boolean)true, (String)"Datastore");
            QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)dsRelation, (String[])new String[]{HOST_NAME_PROPERTY, "info"});
            ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
            if (resultSet.items != null) {
                for (ResultItem resultItem : resultSet.items) {
                    String name = null;
                    Object info = null;
                    for (PropertyValue property : resultItem.properties) {
                        if ("info".equals(property.propertyName)) {
                            info = property.value;
                        }
                        if (!HOST_NAME_PROPERTY.equals(property.propertyName)) continue;
                        name = (String)property.value;
                    }
                    if (!(info instanceof LocalDatastoreInfo) && !(info instanceof VmfsDatastoreInfo) && !(info instanceof NasDatastoreInfo) || name == null) continue;
                    result.add(name);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving host datastores", (Throwable)e);
        }
        return result.toArray(new String[result.size()]);
    }

    @type(value="HostSystem")
    public Boolean getIscsiManagerSupported(ManagedObjectReference hostSystemRef) throws Exception {
        ManagedObjectReference iscsiManagerRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostSystemRef, (String)"configManager.iscsiManager");
        if (iscsiManagerRef == null) {
            return Boolean.FALSE;
        }
        IscsiManager iscsiManager = (IscsiManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)iscsiManagerRef);
        return iscsiManager != null;
    }

    @type(value="ClusterComputeResource")
    public HostDatastoreClusterConnectivityInfo[] getDsClusterDatastoresNotConnectedToHosts(ManagedObjectReference clusterRef, Object[] hostRefs) throws Exception {
        if (this._hostDsClusterConnectivityInfoService == null) {
            return null;
        }
        HostDatastoreClusterConnectivityInfo[] result = this._hostDsClusterConnectivityInfoService.getConnectivityInfoForHosts(clusterRef, hostRefs);
        return result;
    }

    @type(value="HostSystem")
    public boolean getCanEditDefaultHwVersionAction(ManagedObjectReference hostRef) throws Exception {
        PropertyValue[] result = this._queryExecutor.getProperties((Object)hostRef, new String[]{CONN_STATE, HOST_IS_STANDALONE_PROP});
        if (result == null) {
            return false;
        }
        boolean isConnected = true;
        boolean isStandalone = true;
        for (PropertyValue pVal : result) {
            if (pVal.propertyName.equals(CONN_STATE)) {
                isConnected = HostSystem.ConnectionState.connected.equals(pVal.value);
                continue;
            }
            if (!pVal.propertyName.equals(HOST_IS_STANDALONE_PROP)) continue;
            isStandalone = (Boolean)pVal.value;
        }
        return isConnected && isStandalone;
    }

    private String retrieveHostSystemUrl(ManagedObjectReference hostRef) throws Exception {
        String hostSystemUrl = null;
        PropertyValue[] propertyResult = QueryUtil.getProperties((DataService)this._dataService, (Object)hostRef, (String[])new String[]{HOST_NAME_PROPERTY, HOST_PORT_PROPERTY});
        String host = null;
        int port = 0;
        for (PropertyValue prop : propertyResult) {
            if (prop.propertyName.equals(HOST_NAME_PROPERTY)) {
                host = prop.value.toString();
                continue;
            }
            if (!prop.propertyName.equals(HOST_PORT_PROPERTY)) continue;
            port = ((Number)prop.value).intValue();
        }
        if (host != null) {
            hostSystemUrl = host;
            if (port != 0 && port != 443) {
                hostSystemUrl = hostSystemUrl + ":" + port;
            }
        }
        return hostSystemUrl;
    }

    private PerformanceManager getPerformanceManager(ManagedObjectReference hostRef) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)hostRef.getServerGuid());
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        PerformanceManager perfManager = (PerformanceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.getPerfManager());
        return perfManager;
    }

    private MemoryManagerSystem.ServiceConsoleReservationInfo getConsoleReservationInfo(ManagedObjectReference hostRef) throws Exception {
        HostSystem.ConnectionState connectionState = Util.getConnectionStateForHost(hostRef, this._dataService);
        if (connectionState == HostSystem.ConnectionState.connected) {
            HostDataRetrieverDsImpl hdr = new HostDataRetrieverDsImpl(this._dataService, hostRef);
            try {
                hdr.getServiceConsoleReservationInfo();
            }
            catch (HostDataRetrieverException e) {
                this.logError(hostRef, e);
            }
        }
        return null;
    }

    private ImageConfigManager getImageConfigManager(ManagedObjectReference host) throws HostDataRetrieverException {
        return new HostDataRetrieverDsImpl(this._dataService, host).getImageConfigManager();
    }

    private void logError(ManagedObjectReference host, Exception e) {
        LOG.error((Object)("Exception caught when retrieving data for " + host.getValue()), (Throwable)e);
    }
}

