/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.PciPassthruSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.host.config.PciPassthruUpdateSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PciPassthruMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(PciPassthruMutationProvider.class);

    public OperationResult apply(ManagedObjectReference hostSystemRef, PciPassthruUpdateSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostSystemRef;
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostSystemRef);
            if (host == null) {
                throw new NullPointerException("Host could not be found");
            }
            ConfigManager configMgr = host.getConfigManager();
            if (configMgr == null) {
                throw new NullPointerException("Config manager was null");
            }
            PciPassthruSystem system = (PciPassthruSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)configMgr.pciPassthruSystem);
            if (system == null) {
                throw new NullPointerException("PciPassthruSystem was null");
            }
            if (spec == null || spec.configs == null) {
                throw new NullPointerException("PciPassthuUpdateSpec or member was null");
            }
            system.updatePassthruConfig(spec.configs);
            system.refresh();
        }
        catch (Exception e) {
            _logger.error((Object)"Exception when trying to update the PciConfiguration.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }
}

