/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.BIOSInfo;
import com.vmware.vim.binding.vim.host.BootDeviceInfo;
import com.vmware.vim.binding.vim.host.BootDeviceSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.CpuSchedulerSystem;
import com.vmware.vim.binding.vim.host.Summary;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.mutation.MutationMapping;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.host.impl.ProcessorGeneralConfigFormatter;
import com.vmware.vsphere.client.host.impl.ProcessorSystemConfigFormatter;
import com.vmware.vsphere.client.host.util.Util;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessorConfigProvider
implements PropertyProviderBean,
MutationProvider {
    private DataService _dataService;
    private LegacyAuthorizationService _authService;
    private static final Log _logger = LogFactory.getLog(ProcessorConfigProvider.class);

    public ProcessorConfigProvider(DataService dataService, LegacyAuthorizationService authService) {
        this._dataService = dataService;
        this._authService = authService;
    }

    @type(value="HostSystem")
    public DynamicObject getProcessorGeneralConfig(ManagedObjectReference hostRef) throws Exception {
        QuerySpec query = QueryUtil.buildQuerySpec((Object)hostRef, (String[])new String[]{"hardware.cpuPowerManagementInfo", "summary.hardware", "config.hyperThread"});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        Object[] resultItems = resultSet.items;
        if (resultSet.error != null) {
            _logger.error((Object)resultSet.error);
        }
        Summary.HardwareSummary hardware = null;
        CpuSchedulerSystem.HyperThreadScheduleInfo htInfo = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])resultItems)) {
            for (Object resultItem : resultItems) {
                Object[] propValues = ((ResultItem)resultItem).properties;
                if (ArrayUtil.isNullOrEmpty((Object[])propValues)) continue;
                for (Object propValue : propValues) {
                    String propName = ((PropertyValue)propValue).propertyName;
                    if ("summary.hardware".equals(propName)) {
                        hardware = (Summary.HardwareSummary)((PropertyValue)propValue).value;
                        continue;
                    }
                    if (!"config.hyperThread".equals(propName)) continue;
                    htInfo = (CpuSchedulerSystem.HyperThreadScheduleInfo)((PropertyValue)propValue).value;
                }
            }
        }
        DynamicObject result = new DynamicObject();
        ProcessorGeneralConfigFormatter formatter = ProcessorGeneralConfigFormatter.newInstance(hardware, htInfo, this.getIgnoreHtConfig(hostRef));
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        ProcessorConfigProvider.addNonNullValueToList(list, "cpuModel", formatter.cpuModel());
        ProcessorConfigProvider.addNonNullValueToList(list, "processorSpeed", formatter.processorSpeed());
        ProcessorConfigProvider.addNonNullValueToList(list, "processorSockets", formatter.processorSockets());
        ProcessorConfigProvider.addNonNullValueToList(list, "processorCoresPerSocket", formatter.processorCoresPerSocket());
        ProcessorConfigProvider.addNonNullValueToList(list, "logicalProcessors", formatter.logicalProcessors());
        ProcessorConfigProvider.addNonNullValueToList(list, "hyperthreading", formatter.hyperthreading());
        result.properties = new NameValuePair[list.size()];
        result.properties = list.toArray(result.properties);
        return result;
    }

    private boolean getIgnoreHtConfig(ManagedObjectReference hostRef) {
        boolean ignoreHtConfig = false;
        try {
            OptionManager optionManager = Util.getHostOptionManager(hostRef);
            if (optionManager != null) {
                OptionValue[] optionValues = optionManager.getSetting();
                boolean htBoot = false;
                boolean htMitigation = false;
                for (OptionValue optionValue : optionValues) {
                    if ("VMkernel.Boot.hyperthreading".equals(optionValue.key)) {
                        htBoot = Boolean.parseBoolean(optionValue.value.toString());
                        continue;
                    }
                    if (!"VMkernel.Boot.hyperthreadingMitigation".equals(optionValue.key)) continue;
                    htMitigation = Boolean.parseBoolean(optionValue.value.toString());
                }
                ignoreHtConfig = htBoot && htMitigation;
            }
        }
        catch (Exception e) {
            _logger.error((Object)e);
        }
        return ignoreHtConfig;
    }

    @ModelMetadata(type={"HostSystem"}, property="processorGeneralConfig.@info.immutable")
    public boolean getProcessorGeneralConfigImmutable(ManagedObjectReference hostRef) {
        boolean immutable;
        boolean bl = immutable = !Util.checkHostAvailability(hostRef, new String[]{"Host.Config.HyperThreading"}, this._dataService, this._authService);
        if (!immutable) {
            CpuSchedulerSystem.HyperThreadScheduleInfo htInfo = null;
            try {
                htInfo = (CpuSchedulerSystem.HyperThreadScheduleInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"config.hyperThread");
            }
            catch (Exception ex) {
                _logger.fatal((Object)("Exception caught when retrieving data for " + hostRef.getValue()), (Throwable)ex);
            }
            immutable = htInfo == null || !htInfo.available;
        }
        return immutable;
    }

    @type(value="HostSystem")
    public DynamicObject getProcessorSystemConfig(ManagedObjectReference hostRef) throws Exception {
        QuerySpec query = QueryUtil.buildQuerySpec((Object)hostRef, (String[])new String[]{"hardware.biosInfo", "summary.hardware", "configManager.bootDeviceSystem"});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        Object[] resultItems = resultSet.items;
        if (resultSet.error != null) {
            _logger.error((Object)resultSet.error);
        }
        Summary.HardwareSummary hardware = null;
        ManagedObjectReference bdsMor = null;
        BIOSInfo biosInfo = null;
        BootDeviceInfo bootInfo = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])resultItems)) {
            for (Object resultItem : resultItems) {
                Object[] propValues = ((ResultItem)resultItem).properties;
                if (ArrayUtil.isNullOrEmpty((Object[])propValues)) continue;
                for (Object propValue : propValues) {
                    String propName = ((PropertyValue)propValue).propertyName;
                    if ("hardware.biosInfo".equals(propName)) {
                        biosInfo = (BIOSInfo)((PropertyValue)propValue).value;
                        continue;
                    }
                    if ("summary.hardware".equals(propName)) {
                        hardware = (Summary.HardwareSummary)((PropertyValue)propValue).value;
                        continue;
                    }
                    if (!"configManager.bootDeviceSystem".equals(propName)) continue;
                    bdsMor = (ManagedObjectReference)((PropertyValue)propValue).value;
                }
            }
        }
        if (bdsMor != null) {
            BootDeviceSystem bootSystem = (BootDeviceSystem)ManagedObjectUtil.getManagedObject(bdsMor);
            try {
                bootInfo = bootSystem.queryBootDevices();
            }
            catch (Exception ex) {
                _logger.error((Object)("Exception caught when retrieving boot devices for " + hostRef.getValue()), (Throwable)ex);
            }
        }
        DynamicObject result = new DynamicObject();
        ProcessorSystemConfigFormatter formatter = ProcessorSystemConfigFormatter.newInstance(hardware, biosInfo, bootInfo);
        result.properties = new NameValuePair[]{new NameValuePair("manufacturer", (Object)formatter.manufacturer()), new NameValuePair("model", (Object)formatter.model()), new NameValuePair("bootDevice", (Object)formatter.bootDevice()), new NameValuePair("biosVersion", (Object)formatter.biosVersion()), new NameValuePair("releaseDate", (Object)formatter.releaseDate()), new NameValuePair("assetTag", (Object)formatter.assetTag()), new NameValuePair("serviceTag", (Object)formatter.serviceTag())};
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, property="processorSystemConfig.@info.immutable")
    public boolean getProcessorSystemConfigImmutable(ManagedObjectReference hostRef) {
        boolean hostAvailable = Util.checkHostAvailability(hostRef, new String[]{"Host.Config.Maintenance"}, this._dataService, this._authService);
        if (!hostAvailable) {
            return true;
        }
        ManagedObjectReference bootDeviceSystem = null;
        try {
            bootDeviceSystem = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"configManager.bootDeviceSystem");
        }
        catch (Exception ex) {
            _logger.error((Object)("Exception caught when getting BootDeviceSystem of " + hostRef.getValue()), (Throwable)ex);
        }
        return bootDeviceSystem == null;
    }

    @MutationMapping(type="HostSystem", property="processorGeneralConfig")
    public OperationResult applyProcessorGeneralConfig(ManagedObjectReference hostRef, Map<String, Object> args) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            Object hyperthreading = args.get("hyperthreading");
            if (hyperthreading == null) {
                return result;
            }
            if (!(hyperthreading instanceof Map)) {
                return result;
            }
            Map map = (Map)hyperthreading;
            Boolean enable = Boolean.parseBoolean(map.get("htOnRestart").toString());
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            ConfigManager configManager = host.getConfigManager();
            CpuSchedulerSystem scheduler = null;
            if (configManager.cpuScheduler != null) {
                scheduler = (CpuSchedulerSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)configManager.cpuScheduler);
                if (enable.booleanValue()) {
                    scheduler.enableHyperThreading();
                } else {
                    scheduler.disableHyperThreading();
                }
            }
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private static void addNonNullValueToList(ArrayList<NameValuePair> list, String key, Object value) {
        if (value == null) {
            return;
        }
        list.add(new NameValuePair(key, value));
    }
}

