/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.RemoteException;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vsphere.client.common.data.DataProviderAdapterBase;
import com.vmware.vsphere.client.h5.autodeploy.fault.ConnectionFault;
import com.vmware.vsphere.client.h5.autodeploy.impl.DerivedProperty;
import com.vmware.vsphere.client.h5.autodeploy.impl.RelatedProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AdDataProviderAdapterBase
extends DataProviderAdapterBase {
    private static final Log _logger = LogFactory.getLog(AdDataProviderAdapterBase.class);
    private final QueryExecutor _queryExecutor;
    protected ThreadPoolExecutor _threadPoolExecutor = null;
    private Set<String> _baseProperties;
    private Map<String, DerivedProperty> _derivedProperties;
    private Map<String, RelatedProperty> _relatedProperties;

    protected AdDataProviderAdapterBase(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    protected AdDataProviderAdapterBase(QueryExecutor queryExecutor, ThreadPoolExecutor threadPoolExecutor) {
        this._queryExecutor = queryExecutor;
        this._threadPoolExecutor = threadPoolExecutor;
    }

    protected abstract Set<String> initBaseProperties();

    protected abstract Map<String, DerivedProperty> initDerivedProperties();

    protected abstract Map<String, RelatedProperty> initRelatedProperties();

    public final void init() {
        this._baseProperties = this.initBaseProperties();
        this._derivedProperties = this.initDerivedProperties();
        this._relatedProperties = this.initRelatedProperties();
    }

    protected ResultSet processQuery(RelationalConstraint c, QuerySpec q) {
        try {
            ConcurrentHashMap<String, Object> requestContext = new ConcurrentHashMap<String, Object>();
            Object[] targetObjects = this.filterObjects(c, requestContext);
            return this.doProcessQuery(targetObjects, q, requestContext);
        }
        catch (Exception e) {
            MethodFault error = this.transformException(e);
            return this.createErrorResultSet(q.name, error);
        }
    }

    protected ResultSet processQuery(ObjectIdentityConstraint c, QuerySpec q) {
        try {
            ConcurrentHashMap<String, Object> requestContext = new ConcurrentHashMap<String, Object>();
            Object[] targetObjects = this.filterObjects(c, requestContext);
            if (ArrayUtil.isNullOrEmpty((Object[])targetObjects)) {
                return this.createObjectNotFoundResultSet(q.name);
            }
            return this.doProcessQuery(targetObjects, q, requestContext);
        }
        catch (Exception e) {
            MethodFault error = this.transformException(e);
            return this.createErrorResultSet(q.name, error);
        }
    }

    protected ResultSet processQuery(CompositeConstraint c, QuerySpec q) {
        try {
            ConcurrentHashMap<String, Object> requestContext = new ConcurrentHashMap<String, Object>();
            Object[] targetObjects = this.filterObjects(c, requestContext);
            return this.doProcessQuery(targetObjects, q, requestContext);
        }
        catch (Exception e) {
            MethodFault error = this.transformException(e);
            return this.createErrorResultSet(q.name, error);
        }
    }

    private ResultSet doProcessQuery(Object[] targetObjects, QuerySpec q, Map<String, Object> requestContext) {
        assert (targetObjects != null);
        if (targetObjects.length == 0) {
            return ResultUtil.newEmptyResultSet();
        }
        Object[] pagedTargetObjects = q.resultSpec != null && q.resultSpec.maxResultCount != null && q.resultSpec.maxResultCount > -1 ? ArrayUtils.subarray((Object[])targetObjects, (int)q.resultSpec.offset, (int)(q.resultSpec.offset + q.resultSpec.maxResultCount)) : targetObjects;
        String[] propertyNames = this.extractSupportedPropertyNames(q);
        Map<String, Object[]> properties = this.retrieveProperties(pagedTargetObjects, propertyNames, requestContext);
        ResultSet result = this.createResultSet(q.name, pagedTargetObjects, propertyNames, properties, targetObjects.length);
        return result;
    }

    protected abstract Object[] getEmptyResult();

    protected abstract Object[] filterObjects(RelationalConstraint var1, Map<String, Object> var2);

    protected abstract Object[] filterObjects(ObjectIdentityConstraint var1, Map<String, Object> var2);

    protected Object[] filterObjects(CompositeConstraint c, Map<String, Object> requestContext) {
        if (c.nestedConstraints.length == 0) {
            return this.getEmptyResult();
        }
        if (c.nestedConstraints.length == 1) {
            return this.filterByConstraintType(c.nestedConstraints[0], requestContext);
        }
        Object[] resultOfFirst = this.filterByConstraintType(c.nestedConstraints[0], requestContext);
        Set<Object> resultSet = new HashSet<Object>(Arrays.asList(resultOfFirst));
        for (int i = 1; i < c.nestedConstraints.length; ++i) {
            Object[] currentResult = this.filterByConstraintType(c.nestedConstraints[i], requestContext);
            resultSet = AdDataProviderAdapterBase.applySetOperation(resultSet, currentResult, c.conjoiner);
        }
        return resultSet.toArray(this.getEmptyResult());
    }

    protected final Object[] filterByConstraintType(Constraint c, Map<String, Object> requestContext) {
        if (c instanceof ObjectIdentityConstraint) {
            return this.filterObjects((ObjectIdentityConstraint)c, requestContext);
        }
        if (c instanceof RelationalConstraint) {
            return this.filterObjects((RelationalConstraint)c, requestContext);
        }
        if (c instanceof CompositeConstraint) {
            return this.filterObjects((CompositeConstraint)c, requestContext);
        }
        _logger.warn((Object)("Unhandled constraint type: " + c.getClass().getName()));
        return this.getEmptyResult();
    }

    private Map<String, Object[]> retrieveProperties(final Object[] sourceObjects, String[] propertyNames, Map<String, Object> requestContext) {
        if (!AdDataProviderAdapterBase.objectsOnSameServer(sourceObjects)) {
            throw new IllegalStateException("Unexpected query: objects from different servers");
        }
        PropertyNamePartition partitionedProperties = this.extractNeededBaseProperties(propertyNames);
        Map<String, Object[]> valuesByProperty = this.retrieveBaseProperties(partitionedProperties.baseProperties, sourceObjects, requestContext);
        for (String derivedPropertyName : partitionedProperties.derivedProperties) {
            DerivedProperty dp = this._derivedProperties.get(derivedPropertyName);
            Object[] values = dp.getValues(sourceObjects, valuesByProperty);
            valuesByProperty.put(derivedPropertyName, values);
        }
        ArrayList<1> relatedPropertyRequests = new ArrayList<1>();
        final HttpServletRequest threadContext = this._threadPoolExecutor != null ? SessionUtil.getHttpRequest() : null;
        final ConcurrentHashMap relatedValuesByProperty = new ConcurrentHashMap();
        for (final String string : partitionedProperties.relatedProperties) {
            final RelatedProperty relatedPropertyDescriptor = this._relatedProperties.get(string);
            assert (valuesByProperty.containsKey(relatedPropertyDescriptor.relation));
            final Object[] relatedObjects = valuesByProperty.get(relatedPropertyDescriptor.relation);
            final HashSet<Object> relatedObjectsNormalized = new HashSet<Object>();
            for (Object o : relatedObjects) {
                if (o == null) continue;
                assert (o instanceof ManagedObjectReference);
                relatedObjectsNormalized.add(o);
            }
            if (relatedObjectsNormalized.size() == 0) continue;
            relatedPropertyRequests.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        if (threadContext != null) {
                            SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                        }
                        PropertyValue[] resultsOnRelatedObjects = AdDataProviderAdapterBase.this._queryExecutor.getProperties(relatedObjectsNormalized.toArray(new Object[relatedObjectsNormalized.size()]), new String[]{relatedPropertyDescriptor.propertyOnRelatedObject});
                        Object[] values = new Object[sourceObjects.length];
                        for (int i = 0; i < sourceObjects.length; ++i) {
                            if (relatedObjects[i] == null) continue;
                            values[i] = AdDataProviderAdapterBase.findPropertyValueByObject(resultsOnRelatedObjects, relatedObjects[i]);
                        }
                        relatedValuesByProperty.put(string, values);
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Data service exception when retrieving property " + relatedPropertyDescriptor.propertyOnRelatedObject + " on relation " + relatedPropertyDescriptor.relation));
                    }
                    return null;
                }
            });
        }
        if (!relatedPropertyRequests.isEmpty()) {
            try {
                if (this._threadPoolExecutor != null) {
                    this._threadPoolExecutor.invokeAll(relatedPropertyRequests);
                } else {
                    for (Callable callable : relatedPropertyRequests) {
                        callable.call();
                    }
                }
                for (Map.Entry entry : relatedValuesByProperty.entrySet()) {
                    valuesByProperty.put((String)entry.getKey(), (Object[])entry.getValue());
                }
            }
            catch (Exception ex) {
                _logger.error((Object)"Failed to request related properties", (Throwable)ex);
            }
        }
        return valuesByProperty;
    }

    protected abstract Map<String, Object[]> retrieveBaseProperties(Set<String> var1, Object[] var2, Map<String, Object> var3);

    private PropertyNamePartition extractNeededBaseProperties(String[] propertyNames) {
        HashSet<String> baseProperties = new HashSet<String>();
        HashSet<String> derivedProperties = new HashSet<String>();
        HashSet<String> relatedProperties = new HashSet<String>();
        for (String pn : propertyNames) {
            if (this._derivedProperties.containsKey(pn)) {
                this.addDerivedProperty(pn, baseProperties);
                derivedProperties.add(pn);
                continue;
            }
            if (this._relatedProperties.containsKey(pn)) {
                String relationBackingProperty = this._relatedProperties.get((Object)pn).relation;
                if (this._derivedProperties.containsKey(relationBackingProperty)) {
                    this.addDerivedProperty(relationBackingProperty, baseProperties);
                    derivedProperties.add(relationBackingProperty);
                } else {
                    baseProperties.add(relationBackingProperty);
                }
                relatedProperties.add(pn);
                continue;
            }
            baseProperties.add(pn);
        }
        return new PropertyNamePartition(baseProperties, derivedProperties, relatedProperties);
    }

    private void addDerivedProperty(String propertyName, Set<String> basePropertiesOut) {
        assert (this._derivedProperties.containsKey(propertyName));
        for (String bpn : this._derivedProperties.get(propertyName).getInputPropertyNames()) {
            basePropertiesOut.add(bpn);
        }
    }

    private ResultSet createResultSet(String queryName, Object[] objects, String[] propertyNames, Map<String, Object[]> propertyValues, int totalMatchedObjectCount) {
        ResultSet result = new ResultSet();
        result.queryName = queryName;
        result.totalMatchedObjectCount = totalMatchedObjectCount;
        result.items = this.createResultItems(objects, propertyNames, propertyValues);
        return result;
    }

    private ResultItem[] createResultItems(Object[] sourceObjects, String[] propertyNames, Map<String, Object[]> propertyValues) {
        ResultItem[] result = new ResultItem[sourceObjects.length];
        for (int i = 0; i < sourceObjects.length; ++i) {
            ResultItem itemForObject = new ResultItem();
            itemForObject.properties = new PropertyValue[propertyNames.length];
            itemForObject.resourceObject = this.sourceObjectToReference(sourceObjects[i]);
            for (int j = 0; j < propertyNames.length; ++j) {
                if (!propertyValues.containsKey(propertyNames[j])) continue;
                PropertyValue propVal = new PropertyValue();
                propVal.propertyName = propertyNames[j];
                propVal.resourceObject = this.sourceObjectToReference(sourceObjects[i]);
                propVal.value = propertyValues.get(propertyNames[j])[i];
                itemForObject.properties[j] = propVal;
            }
            result[i] = itemForObject;
        }
        return result;
    }

    private ResultSet createErrorResultSet(String queryName, MethodFault error) {
        ResultSet result = new ResultSet();
        result.queryName = queryName;
        result.error = error;
        return result;
    }

    private ResultSet createObjectNotFoundResultSet(String queryName) {
        ResultSet result = new ResultSet();
        result.queryName = queryName;
        result.error = new MethodFault(ResourceUtil.getString((String)"autodeployservice", (String)"objectNotFound.message", (ClassLoader)AdDataProviderAdapterBase.class.getClassLoader()));
        return result;
    }

    protected abstract Object sourceObjectToReference(Object var1);

    private static boolean objectsOnSameServer(Object[] objectRefs) {
        if (!(objectRefs instanceof ManagedObjectReference[])) {
            return true;
        }
        ManagedObjectReference[] objects = (ManagedObjectReference[])objectRefs;
        String serverGuid = objects[0].getServerGuid();
        for (int i = 1; i < objects.length; ++i) {
            if (serverGuid.equals(objects[i].getServerGuid())) continue;
            return false;
        }
        return true;
    }

    private static Set<Object> applySetOperation(Set<Object> lhs, Object[] rhs, Conjoiner op) {
        HashSet<Object> result;
        assert (rhs != null);
        if (op == Conjoiner.AND) {
            result = new HashSet();
            for (Object o : rhs) {
                if (!lhs.contains(o)) continue;
                result.add(o);
            }
        } else if (op == Conjoiner.OR) {
            result = lhs;
            for (Object o : rhs) {
                result.add(o);
            }
        } else if (op == Conjoiner.EXCEPT) {
            result = lhs;
            for (Object o : rhs) {
                result.remove(o);
            }
        } else {
            throw new IllegalStateException("Unexpected conjoiner");
        }
        return result;
    }

    private MethodFault transformException(Exception e) {
        MethodFault result;
        if (e instanceof UnexpectedStatusCodeException || e instanceof RemoteException) {
            String messageToShow = e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage();
            result = new ConnectionFault(ResourceUtil.getString((String)"autodeployservice", (String)"connectionError.message", (String[])new String[]{messageToShow}, (ClassLoader)AdDataProviderAdapterBase.class.getClassLoader()));
        } else {
            result = new MethodFault(e.getMessage());
        }
        return result;
    }

    private String[] extractSupportedPropertyNames(QuerySpec q) {
        HashSet<String> result = new HashSet<String>();
        for (PropertySpec ps : q.resourceSpec.propertySpecs) {
            for (String propName : ps.propertyNames) {
                boolean isPropertySupported;
                boolean bl = isPropertySupported = this._baseProperties.contains(propName) || this._derivedProperties.containsKey(propName) || this._relatedProperties.containsKey(propName);
                if (!isPropertySupported) continue;
                result.add(propName);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private static Object findPropertyValueByObject(PropertyValue[] haystack, Object resource) {
        for (PropertyValue pv : haystack) {
            if (!pv.resourceObject.equals(resource)) continue;
            return pv.value;
        }
        return null;
    }

    private static class PropertyNamePartition {
        final Set<String> baseProperties;
        final Set<String> derivedProperties;
        final Set<String> relatedProperties;

        PropertyNamePartition(Set<String> bp, Set<String> dp, Set<String> rp) {
            this.baseProperties = bp;
            this.derivedProperties = dp;
            this.relatedProperties = rp;
        }
    }
}

