/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.vmware.vim.binding.rbd.PxeProfile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;

public class PxeProfilePropertyProviderAdapter
implements PropertyProviderAdapter {
    private final AutoDeployServiceFactory _autoDeployServiceFactory;
    private static final String NAME = "name";
    private static final String PXE_PROFILE_TYPE = "rbd1:PxeProfile";

    private static ResultItem createResultItem(Object object, String name) {
        PropertyValue value = new PropertyValue();
        value.propertyName = NAME;
        value.value = name;
        value.resourceObject = object;
        ResultItem item = new ResultItem();
        item.resourceObject = object;
        item.properties = new PropertyValue[]{value};
        return item;
    }

    public PxeProfilePropertyProviderAdapter(DataServiceExtensionRegistry registry, AutoDeployServiceFactory autoDeployServiceFactory) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._autoDeployServiceFactory = autoDeployServiceFactory;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = PXE_PROFILE_TYPE;
        typeInfo.properties = new String[]{NAME};
        return new TypeInfo[]{typeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Object[] objects;
        ResultSet result = new ResultSet();
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        HashMap<String, AutoDeployService> autoDeployServices = new HashMap<String, AutoDeployService>();
        AutoDeployService autoDeploy = null;
        for (Object object : objects = propertyRequest.objects) {
            if (!(object instanceof ManagedObjectReference)) continue;
            ManagedObjectReference pxeProfileRef = (ManagedObjectReference)object;
            String serverGuid = pxeProfileRef.getServerGuid();
            if (!autoDeployServices.containsKey(serverGuid)) {
                autoDeployServices.put(serverGuid, this._autoDeployServiceFactory.getService(serverGuid));
            }
            autoDeploy = (AutoDeployService)autoDeployServices.get(pxeProfileRef.getServerGuid());
            PxeProfile pxeprofile = (PxeProfile)autoDeploy.getManagedObject(pxeProfileRef);
            String name = pxeprofile.retrieveImageProfileName();
            ResultItem item = PxeProfilePropertyProviderAdapter.createResultItem(object, name);
            items.add(item);
        }
        result.items = items.toArray(new ResultItem[items.size()]);
        return result;
    }
}

