/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.vmware.vim.binding.rbd.RuleManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.rule.RuleAttributeInfo;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RulePropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(RulePropertyProvider.class);
    AutoDeployServiceFactory _serviceFactory;
    Map<String, String> _knownSupportedAttributes = Collections.emptyMap();

    public RulePropertyProvider(AutoDeployServiceFactory serviceFactory, Map<String, String> knownSupportedAttributes) {
        this._serviceFactory = serviceFactory;
        this._knownSupportedAttributes = knownSupportedAttributes;
    }

    @type(value="Folder")
    public RuleAttributeInfo[] getSupportedAttributes(ManagedObjectReference vcRootFolder) {
        RuleManager.Attribute[] supportedAttributes = new RuleManager.Attribute[]{};
        AutoDeployService autoDeployService = this._serviceFactory.getService(vcRootFolder.getServerGuid());
        RuleManager ruleManager = autoDeployService.getRuleManager();
        if (ruleManager != null) {
            supportedAttributes = ruleManager.retrieveAttributeList();
        }
        return this.localizeAttributes(supportedAttributes);
    }

    private RuleAttributeInfo[] localizeAttributes(RuleManager.Attribute[] attributes) {
        if (attributes == null) {
            return new RuleAttributeInfo[0];
        }
        int attributesLength = attributes.length;
        RuleAttributeInfo[] attributesInfo = new RuleAttributeInfo[attributesLength];
        for (int i = 0; i < attributesLength; ++i) {
            RuleManager.Attribute supportedAttribute = attributes[i];
            attributesInfo[i] = this.createRuleAttributeInfo(supportedAttribute);
        }
        return attributesInfo;
    }

    private RuleAttributeInfo createRuleAttributeInfo(RuleManager.Attribute attribute) {
        RuleAttributeInfo info = new RuleAttributeInfo();
        info.name = attribute.name;
        info.type = attribute.type;
        info.label = this.getLocalizedAttributeName(attribute.name);
        return info;
    }

    private String getLocalizedAttributeName(String attribute) {
        String label;
        if (this._knownSupportedAttributes.containsKey(attribute)) {
            String key = this._knownSupportedAttributes.get(attribute);
            label = ResourceUtil.getString((String)"autodeployservice", (String)key, (ClassLoader)RulePropertyProvider.class.getClassLoader());
        } else {
            label = attribute;
            _logger.warn((Object)String.format("Rule attribute '%s' is unknown to the client.", attribute));
        }
        return label;
    }
}

