/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.CommonReferenceUtil;
import java.net.URI;
import org.apache.commons.lang.StringUtils;

public final class DepotReferenceUtil {
    public static final String DEPOT_TYPE = "imagebuilder:Depot";
    private static final int VC_GUID_SEGMENT_INDEX = 0;
    private static final int DEPOT_URL_SEGMENT_INDEX = 1;
    private static final String URI_ID_SEGMENT_DELIMITER = "/";

    public static ManagedObjectReference getVcRef(URI ref) {
        assert (ref != null);
        String vcGuid = DepotReferenceUtil.getVcGuid(ref);
        if (StringUtils.isEmpty((String)vcGuid)) {
            return null;
        }
        return ManagedObjectUtil.getRootFolder((String)vcGuid);
    }

    public static String getVcGuid(URI ref) {
        return CommonReferenceUtil.getIdSegmentDecoded(ref, 0);
    }

    public static String getDepotUrl(URI ref) {
        return CommonReferenceUtil.getIdSegmentDecodedAsUrl(ref, 1);
    }

    public static URI createRef(String vcGuid, String depotUrl) {
        assert (vcGuid != null);
        assert (depotUrl != null);
        String[] segments = new String[]{CommonReferenceUtil.encodeString(vcGuid), CommonReferenceUtil.encodeUrlString(depotUrl)};
        return DefaultUriSchemeUtil.createUri((String)DEPOT_TYPE, (String[])segments);
    }
}

