/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.CommonReferenceUtil;
import java.net.URI;
import org.apache.commons.lang.StringUtils;

public final class VibPackageReferenceUtil {
    public static final String VIB_PACKAGE_TYPE = "imagebuilder:VibPackage";
    private static final int VC_GUID_SEGMENT_INDEX = 0;
    private static final int VIB_PACKAGE_GUID_SEGMENT_INDEX = 1;

    public static ManagedObjectReference getVcRef(URI ref) {
        assert (ref != null);
        String vcGuid = VibPackageReferenceUtil.getVcGuid(ref);
        if (StringUtils.isEmpty((String)vcGuid)) {
            return null;
        }
        return ManagedObjectUtil.getRootFolder((String)vcGuid);
    }

    public static String getVcGuid(URI ref) {
        return CommonReferenceUtil.getIdSegmentDecoded(ref, 0);
    }

    public static String getVibPackageGuid(URI ref) {
        return CommonReferenceUtil.getIdSegmentDecoded(ref, 1);
    }

    public static URI createRef(String vcGuid, String vibPackageGuid) {
        assert (vcGuid != null);
        assert (vibPackageGuid != null);
        String[] segments = new String[3];
        segments[0] = CommonReferenceUtil.encodeString(vcGuid);
        segments[1] = CommonReferenceUtil.encodeString(vibPackageGuid);
        return DefaultUriSchemeUtil.createUri((String)VIB_PACKAGE_TYPE, (String[])segments);
    }
}

