/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.actionsfw.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.impl.ActionImpl;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.PropertyValueMap;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionsEvaluator {
    private static final Log _logger = LogFactory.getLog(ActionsEvaluator.class);
    private QueryService _queryService;
    private ObjectReferenceService _objectRefService;

    public ActionsEvaluator(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectRefService) {
        this._queryService = queryServiceFactory.getQueryService();
        this._objectRefService = objectRefService;
    }

    public List<ActionEvaluation> evaluate(List<Action> actions, ActionContext context, boolean filterOutNotApplicableActions) throws Exception {
        ActionImpl actionImpl;
        HashSet<String> requiredProperties = new HashSet<String>();
        boolean disabledOpsNeeded = false;
        ListIterator<Action> iter = actions.listIterator();
        while (iter.hasNext()) {
            Action action = iter.next();
            try {
                actionImpl = (ActionImpl)action;
            }
            catch (ClassCastException ex) {
                _logger.error((Object)("ActionsEvaluator asked to evaluate an Action with an unknown implementation: " + action.getUid() + " " + action.getClass()));
                throw ex;
            }
            if (filterOutNotApplicableActions && !actionImpl.evaluateApplicability(context)) {
                iter.remove();
                continue;
            }
            requiredProperties.addAll(actionImpl.getPropsNeededForEvaluation());
            if (actionImpl.getOperationIds() == null) continue;
            disabledOpsNeeded = true;
        }
        PropertyValueMap data = this.getDataForEvaluation(context, new ArrayList<String>(requiredProperties), disabledOpsNeeded);
        ArrayList<ActionEvaluation> evaluations = new ArrayList<ActionEvaluation>(actions.size());
        iter = actions.listIterator();
        while (iter.hasNext()) {
            actionImpl = (ActionImpl)iter.next();
            ActionEvaluation eval = actionImpl.evaluateAvailability(context, data);
            evaluations.add(eval);
        }
        return evaluations;
    }

    private PropertyValueMap getDataForEvaluation(ActionContext context, List<String> propsToFetch, boolean getDisabledMethods) throws Exception {
        List<Object> targetObjects = context.getTargetObjects();
        if (ArrayUtil.isNullOrEmpty(targetObjects)) {
            return null;
        }
        String objectsType = this._objectRefService.getResourceObjectType(targetObjects.get(0));
        if (StringUtil.isNullOrEmpty((String)objectsType)) {
            throw new IllegalArgumentException("Unsupported object type. Object: " + targetObjects.get(0));
        }
        if (this.isContextHeterogeneous(targetObjects, objectsType)) {
            throw new UnsupportedOperationException("Cannot evaluate actions for multiple object types!");
        }
        if (getDisabledMethods) {
            propsToFetch.add("disabledOperations");
        }
        if (objectsType.equals(VirtualMachine.class.getSimpleName())) {
            propsToFetch.add("config/managedBy/extensionKey");
        }
        if (objectsType.equals(VirtualApp.class.getSimpleName())) {
            propsToFetch.add("vAppConfig/managedBy/extensionKey");
        }
        if (ArrayUtil.isNullOrEmpty(propsToFetch)) {
            return null;
        }
        ResultSet resultSet = this._queryService.select(propsToFetch).from(new String[]{objectsType}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, targetObjects).fetch();
        PropertyValueMap result = this.transformResultSetToMap(resultSet);
        return result;
    }

    private boolean isContextHeterogeneous(List<Object> targetObjects, String targetType) {
        for (Object o : targetObjects) {
            if (targetType.equals(this._objectRefService.getResourceObjectType(o))) continue;
            return true;
        }
        return false;
    }

    private PropertyValueMap transformResultSetToMap(ResultSet resultSet) {
        List propertyNames = resultSet.getProperties();
        List resultItems = resultSet.getItems();
        PropertyValueMap pvMap = new PropertyValueMap();
        if (!resultItems.isEmpty()) {
            for (ResourceItem item : resultItems) {
                Object ref = item.getKey();
                String uid = this._objectRefService.getUid(ref);
                for (int i = 0; i < item.getPropertyValues().size(); ++i) {
                    PropertyValue propertyValue = new PropertyValue();
                    propertyValue.propertyName = (String)propertyNames.get(i);
                    propertyValue.value = item.getPropertyValues().get(i);
                    pvMap.putProperty(uid, propertyValue);
                }
            }
        }
        return pvMap;
    }
}

