/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.actionsfw.impl;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.PropertyValueMap;
import java.util.function.BooleanSupplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ActionsServiceUtil {
    private static final Log _logger = LogFactory.getLog(ActionsServiceUtil.class);

    ActionsServiceUtil() {
    }

    static boolean extractBooleanProperty(PropertyValue pv, String propName, String uid, BooleanSupplier negatedPropertyBooleanSupplier) {
        Object propValue = null;
        if (pv != null) {
            propValue = pv.value;
        }
        if (propValue == null) {
            _logger.warn((Object)("Availability property " + propName + " not found on object " + uid + "."));
            return true;
        }
        if (propValue != null && !(propValue instanceof Boolean)) {
            _logger.error((Object)("Availability property " + propName + " is not of type boolean."));
            return true;
        }
        return (Boolean)propValue == !negatedPropertyBooleanSupplier.getAsBoolean();
    }

    static String[] extractStringArrayProperty(Object target, String propName, ObjectReferenceService objRefService, PropertyValueMap data) {
        String uid = objRefService.getUid(target);
        PropertyValue pv = data.getProperty(uid, propName);
        Object propValue = null;
        if (pv != null) {
            propValue = pv.value;
        }
        if (propValue == null) {
            throw new NullPointerException("Property " + propName + " not found on object " + uid + ".");
        }
        if (!(propValue instanceof String[])) {
            throw new ClassCastException("Property " + propName + " is not of type String[].");
        }
        return (String[])propValue;
    }

    static String getTargetType(Object target, ObjectReferenceService objRefService) {
        if (target == null) {
            throw new NullPointerException("ActionContext.targetObjects must not contain null");
        }
        String type = objRefService.getResourceObjectType(target);
        if (type == null) {
            type = target.getClass().getSimpleName();
        }
        return type;
    }

    public static boolean isPrivilegeGranted(String[] privilegeIds, String[] grantedPrivileges) {
        if (privilegeIds == null) {
            return true;
        }
        if (grantedPrivileges == null) {
            return false;
        }
        for (String privilegeId : privilegeIds) {
            Boolean granted = false;
            for (String grantedPrivilege : grantedPrivileges) {
                if (!privilegeId.equals(grantedPrivilege)) continue;
                granted = true;
                break;
            }
            if (granted.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean isOperationAllowed(String[] operationIds, String[] disabledOperations) {
        if (operationIds == null) {
            return true;
        }
        if (disabledOperations == null) {
            return false;
        }
        for (String operationId : operationIds) {
            Boolean allowed = true;
            for (String disabledOperation : disabledOperations) {
                if (!operationId.equals(disabledOperation)) continue;
                allowed = false;
                break;
            }
            if (allowed.booleanValue()) continue;
            return false;
        }
        return true;
    }
}

