/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ad.installer;

import com.vmware.license.client.management.adapter.LicenseInventoryCache;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppDefenseInstallerFilter
implements ExtensionObjectFilter {
    private static final Log _logger = LogFactory.getLog(AppDefenseInstallerFilter.class);
    private static final PropertyInfo[] CONTEXT_PROPS = new PropertyInfo[0];
    private static final PropertyInfo[] FILTER_PROPS;
    private static final String APPDEFENSE_PACKAGE_ID = "com.vmware.appd.appliance.vsphere.plugin";
    private static final String APPDEFENSE_INSTALL_DOCS_VISIBLE = "appdefense.install.docs.visible";
    private final ExtensionService _extensionService;
    private final LicenseInventoryCache _licenseInventoryCache;
    private final ConfigurationService _configurationService;
    private final boolean _appDefenseInstallDocsVisible;

    public AppDefenseInstallerFilter(ExtensionService extensionService, LicenseInventoryCache licenseInventoryCache, ConfigurationService configurationService) {
        this._extensionService = extensionService;
        this._licenseInventoryCache = licenseInventoryCache;
        this._configurationService = configurationService;
        this._appDefenseInstallDocsVisible = PropertyUtil.getBooleanProperty((ConfigurationService)this._configurationService, (String)APPDEFENSE_INSTALL_DOCS_VISIBLE, (boolean)true);
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return CONTEXT_PROPS;
    }

    public PropertyInfo[] getFilterProperties() {
        return FILTER_PROPS;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        if (!this._appDefenseInstallDocsVisible) {
            return Collections.emptyList();
        }
        boolean adInstalled = true;
        try {
            adInstalled = this.isAppDefensePluginInstalled();
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not determine the status of appDefense plugin,assuming installed.", (Throwable)ex);
        }
        if (adInstalled || !this.isAppDefenseFeatureAvailable()) {
            return Collections.emptyList();
        }
        return extensionInfos;
    }

    protected boolean isAppDefensePluginInstalled() throws Exception {
        PluginPackageInfo[] pluginPackages;
        for (PluginPackageInfo pluginPackage : pluginPackages = this._extensionService.getAllPluginPackageInfos()) {
            if (!APPDEFENSE_PACKAGE_ID.equals(pluginPackage.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isAppDefenseFeatureAvailable() {
        return this._licenseInventoryCache.getContainsAppDefenseFeature();
    }

    static {
        PropertyInfo prop = new PropertyInfo();
        prop.name = "appDefenseInstaller";
        prop.type = String.class.getName();
        prop.optional = false;
        FILTER_PROPS = new PropertyInfo[]{prop};
    }
}

