/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.CacheInvalidateCallback;
import com.vmware.cis.license.common.cache.impl.LruCacheImpl;
import com.vmware.cis.license.common.cache.impl.SimpleTimeBasedCacheImpl;
import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseClientUnavailableException;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.scope.ScopeResolver;
import com.vmware.license.client.cis.ls.scope.ScopeResolverException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheLicenseClientProviderWrapperImpl
implements LicenseClientProvider {
    private static final int LOCAL_VC_CACHE_CAPACITY = 1;
    private static final String LOCAL_VC_CACHE_KEY = "localVc";
    private static final int NON_LOCAL_VCS_CACHE_CAPACITY = 100;
    private final Log _logger = LogFactory.getLog(CacheLicenseClientProviderWrapperImpl.class);
    private final LicenseClientProvider _licenseClientProvider;
    private final ScopeResolver _scopeResolver;
    private final Cache<String, LicenseClient> _localVcLsClientCache;
    private final Cache<LicenseScope, LicenseClient> _nonLocalVcScopeToLsClientCache;

    public CacheLicenseClientProviderWrapperImpl(LicenseClientProvider licenseClientProvider, ScopeResolver scopeResolver, long nonLocalVcsCacheInvalidationIntervalInMs) {
        this._licenseClientProvider = licenseClientProvider;
        this._scopeResolver = scopeResolver;
        CacheInvalidateCallback<LicenseClient> invalidateCallback = new CacheInvalidateCallback<LicenseClient>(){

            public void cacheValueInvalidated(LicenseClient licenseClient) {
                CacheLicenseClientProviderWrapperImpl.this._licenseClientProvider.disposeLicenseClient(licenseClient);
            }
        };
        this._localVcLsClientCache = new LruCacheImpl(1, (CacheInvalidateCallback)invalidateCallback);
        this._nonLocalVcScopeToLsClientCache = new SimpleTimeBasedCacheImpl(nonLocalVcsCacheInvalidationIntervalInMs, 100, (CacheInvalidateCallback)invalidateCallback);
    }

    @Override
    public LicenseClient getLicenseClient(LicenseScope scope) throws LicenseClientUnavailableException {
        boolean shouldUseLocalVcCache;
        try {
            shouldUseLocalVcCache = this._scopeResolver.isLocalVcScope(scope);
        }
        catch (ScopeResolverException e) {
            shouldUseLocalVcCache = true;
            this._logger.warn((Object)"Unable to determine whether local VC cache should be used. Using the non-local VCs one, as it gets invalidated on a timer basis and couldn't do much harm.");
        }
        LicenseClient resultLicenseClient = shouldUseLocalVcCache ? this.getLicenseClientUsingLocalVcCache(scope) : this.getLicenseClientUsingNonLocalVcsCache(scope);
        return resultLicenseClient;
    }

    @Override
    public void disposeLicenseClient(LicenseClient licenseClient) {
        this._licenseClientProvider.disposeLicenseClient(licenseClient);
    }

    public void destroy() {
        this._localVcLsClientCache.invalidate();
        this._nonLocalVcScopeToLsClientCache.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenseClient getLicenseClientUsingLocalVcCache(LicenseScope scope) throws LicenseClientUnavailableException {
        LicenseClient licenseClient = (LicenseClient)this._localVcLsClientCache.get((Object)LOCAL_VC_CACHE_KEY);
        if (licenseClient == null) {
            Cache<String, LicenseClient> cache = this._localVcLsClientCache;
            synchronized (cache) {
                licenseClient = (LicenseClient)this._localVcLsClientCache.get((Object)LOCAL_VC_CACHE_KEY);
                if (licenseClient == null) {
                    licenseClient = this._licenseClientProvider.getLicenseClient(scope);
                    this._localVcLsClientCache.put((Object)LOCAL_VC_CACHE_KEY, (Object)licenseClient);
                }
            }
        }
        return licenseClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenseClient getLicenseClientUsingNonLocalVcsCache(LicenseScope scope) throws LicenseClientUnavailableException {
        LicenseClient licenseClient = (LicenseClient)this._nonLocalVcScopeToLsClientCache.get((Object)scope);
        if (licenseClient == null) {
            Cache<LicenseScope, LicenseClient> cache = this._nonLocalVcScopeToLsClientCache;
            synchronized (cache) {
                licenseClient = (LicenseClient)this._nonLocalVcScopeToLsClientCache.get((Object)scope);
                if (licenseClient == null) {
                    licenseClient = this._licenseClientProvider.getLicenseClient(scope);
                    this._nonLocalVcScopeToLsClientCache.put((Object)scope, (Object)licenseClient);
                }
            }
        }
        return licenseClient;
    }
}

