/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.license.client.cis.ls.LicenseServiceDiscoveryException;
import com.vmware.license.client.cis.ls.VpxLicenseServiceLocator;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VpxLicenseServiceLocatorImpl
implements VpxLicenseServiceLocator {
    private final Log _logger = LogFactory.getLog(VpxLicenseServiceLocatorImpl.class);

    @Override
    public URI getLicenseServiceUriForVc(String vcId) throws LicenseServiceDiscoveryException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vcId});
        try {
            VcService vcService = VimSessionUtil.getService((String)vcId);
            if (vcService == null) {
                this._logger.warn((Object)("No VcService found in session for VC ID: " + vcId));
                String errorMessage = ManagementUtil.getLocalizedString("error.lsLocationUnavailable");
                throw new LicenseServiceDiscoveryException(errorMessage);
            }
            ManagedObjectReference lmMor = vcService.getServiceInstanceContent().getLicenseManager();
            LicenseManager lm = (LicenseManager)vcService.getManagedObject(lmMor);
            String lsUrl = lm.getLicensedEdition();
            if (StringUtil.isNullOrEmpty((String)lsUrl)) {
                this._logger.warn((Object)("Null or empty LS URL returned by VC with ID: " + vcId));
                String errorMessage = ManagementUtil.getLocalizedString("error.lsLocationUnavailable");
                throw new LicenseServiceDiscoveryException(errorMessage);
            }
            URI resultLsUri = URI.create(lsUrl);
            return resultLsUri;
        }
        catch (Exception e) {
            this._logger.warn((Object)("Exception occurred while trying to create LS URI.\nVC ID: " + vcId), (Throwable)e);
            String errorMessage = ManagementUtil.getLocalizedString("error.lsLocationUnavailable");
            throw new LicenseServiceDiscoveryException(errorMessage);
        }
    }
}

