/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;

public class LicensePropertyProviderBean
extends BasePropertyProviderBean<License> {
    @type(value="License")
    public License getLicense(URI licenseUri) {
        License license = (License)((Object)this.getDataObject(licenseUri));
        return license;
    }

    @type(value="License")
    public String getName(URI licenseUri) {
        License license = (License)((Object)this.getDataObject(licenseUri));
        return license.getName();
    }

    @type(value="License")
    public boolean getIsRemovable(URI licenseUri) {
        License license = (License)((Object)this.getDataObject(licenseUri));
        return !license.isAssigned() && !license.getIsEvaluation();
    }

    @type(value="License")
    public boolean getIsAssignableToVcs(URI licenseUri) {
        return this.isAssignableToAssetsOfType(licenseUri, AssetType.VC);
    }

    @type(value="License")
    public boolean getIsAssignableToHosts(URI licenseUri) {
        return this.isAssignableToAssetsOfType(licenseUri, AssetType.HOST);
    }

    @type(value="License")
    public boolean getIsAssignableToClusters(URI licenseUri) {
        return this.isAssignableToAssetsOfType(licenseUri, AssetType.CLUSTER);
    }

    @type(value="License")
    public boolean getIsAssignableToSolutions(URI licenseUri) {
        return this.isAssignableToAssetsOfType(licenseUri, AssetType.SOLUTION);
    }

    @type(value="License")
    public boolean getIsMyVMwareLicense(URI licenseUri) {
        License license = (License)((Object)this.getDataObject(licenseUri));
        return license.getMyVMwareInfo() != null;
    }

    @type(value="License")
    public KeyValue[] getPhoneHomeCollectorProperties(URI licenseUri) {
        ProductRestriction firstProductRestriction;
        ProductRestriction[] productRestrictions;
        License license = (License)((Object)this.getDataObject(licenseUri));
        Object firstSerialKey = null;
        String firstProductDisplayName = null;
        String firstProductFirstCostUnitId = null;
        String firstProductFirstCostUnitUsage = null;
        String firstProductFirstCostUnitLimit = null;
        Object[] serialKeys = license.getSerialKeys();
        if (!ArrayUtil.isNullOrEmpty((Object[])serialKeys)) {
            firstSerialKey = serialKeys[0];
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])(productRestrictions = license.getProductRestrictions())) && (firstProductRestriction = productRestrictions[0]) != null) {
            CostUnit firstProductFirstCostUnit;
            Product firstProduct = firstProductRestriction.getProduct();
            firstProductDisplayName = firstProduct.getFormattedName();
            CostUnit[] firstProductCostUnits = firstProduct.getCostUnits();
            if (!ArrayUtil.isNullOrEmpty((Object[])firstProductCostUnits) && (firstProductFirstCostUnit = firstProductCostUnits[0]) != null) {
                firstProductFirstCostUnitId = firstProductFirstCostUnit.getId();
                if (firstProductFirstCostUnit.getUsage() != null) {
                    firstProductFirstCostUnitUsage = firstProductFirstCostUnit.getUsage().toString();
                }
                if (firstProductFirstCostUnit.getLimit() != null) {
                    firstProductFirstCostUnitLimit = firstProductFirstCostUnit.getLimit().toString();
                }
            }
        }
        KeyValue[] keyValues = new KeyValue[]{new KeyValue("serialKey", (String)firstSerialKey), new KeyValue("productDisplayName", firstProductDisplayName), new KeyValue("costUnitId", firstProductFirstCostUnitId), new KeyValue("costUnitUsage", firstProductFirstCostUnitUsage), new KeyValue("costUnitLimit", firstProductFirstCostUnitLimit)};
        return keyValues;
    }

    private boolean isAssignableToAssetsOfType(URI licenseUri, AssetType type2) {
        License license = (License)((Object)this.getDataObject(licenseUri));
        ProductRestriction[] productRestrictions = license.getProductRestrictions();
        if (productRestrictions != null) {
            for (ProductRestriction productRestriction : productRestrictions) {
                if (!type2.equals((Object)productRestriction.getProduct().getAssetsType())) continue;
                return true;
            }
        }
        return false;
    }
}

