/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.vise.data.query.type;
import java.net.URI;

public class ProductPropertyProviderBean
extends BasePropertyProviderBean<ProductAggregation> {
    @type(value="Product")
    public ProductAggregation getProductAggregation(URI productUri) {
        ProductAggregation productAggregation = (ProductAggregation)((Object)this.getDataObject(productUri));
        return productAggregation;
    }

    @type(value="Product")
    public String getName(URI productUri) {
        Product product = this.getProduct(productUri);
        return product.getFormattedName();
    }

    @type(value="Product")
    public boolean getIsForVcs(URI productUri) {
        return this.isForAssetsOfType(productUri, AssetType.VC);
    }

    @type(value="Product")
    public boolean getIsForHosts(URI productUri) {
        return this.isForAssetsOfType(productUri, AssetType.HOST);
    }

    @type(value="Product")
    public boolean getIsForClusters(URI productUri) {
        return this.isForAssetsOfType(productUri, AssetType.CLUSTER);
    }

    @type(value="Product")
    public boolean getIsForSolutions(URI productUri) {
        return this.isForAssetsOfType(productUri, AssetType.SOLUTION);
    }

    private Product getProduct(URI productUri) {
        ProductAggregation productAggregation = (ProductAggregation)((Object)this.getDataObject(productUri));
        return productAggregation.getProduct();
    }

    private boolean isForAssetsOfType(URI productUri, AssetType type2) {
        Product product = this.getProduct(productUri);
        return type2.equals((Object)product.getAssetsType());
    }
}

