/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProvider;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProviderFactory;
import com.vmware.license.client.cis.ls.topology.TopologyInfoRetrievalException;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.impl.ManagementEditorImpl;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.AssetIdentifier;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpec;
import com.vmware.vim.binding.impl.cis.license.AssetIdentifierImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByIdentifiersImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VpxManagementEditorImpl
extends ManagementEditorImpl
implements VpxManagementEditor {
    private static final String HOST_MO_TYPE = "HostSystem";
    private static final String CLUSTER_MO_TYPE = "ClusterComputeResource";
    private static final String VC_MO_VALUE = "group-d1";
    private static final String VC_MO_TYPE = "Folder";
    private final Log _logger = LogFactory.getLog(VpxManagementEditorImpl.class);
    private final SsoSpecificTopologyInfoProviderFactory _topologyInfoProviderFactory;

    public VpxManagementEditorImpl(LicenseClientProvider licenseClientProvider, SsoSpecificTopologyInfoProviderFactory topologyInfoProviderFactory) {
        super(licenseClientProvider);
        this._topologyInfoProviderFactory = topologyInfoProviderFactory;
    }

    private static String getMoRefInstanceId(ManagedObjectReference moRef) {
        String moRefType = moRef.getType();
        if (HOST_MO_TYPE.equals(moRefType) || CLUSTER_MO_TYPE.equals(moRefType)) {
            return moRef.getValue();
        }
        if (VC_MO_TYPE.equals(moRefType)) {
            return moRef.getServerGuid();
        }
        throw new ManagementException("MOR with type: " + moRef.getType() + " passed. The MO types handled by licensing UI are: " + HOST_MO_TYPE + ", " + VC_MO_TYPE + ", " + CLUSTER_MO_TYPE);
    }

    private static List<String> getMoRefsVcIds(ManagedObjectReference[] moRefs) {
        ArrayList<String> result = new ArrayList<String>();
        if (moRefs == null) {
            return result;
        }
        for (ManagedObjectReference moRef : moRefs) {
            String vcId = VpxManagementEditorImpl.getMoRefVcId(moRef);
            if (vcId == null) continue;
            result.add(vcId);
        }
        return result;
    }

    private static String getMoRefVcId(ManagedObjectReference moRef) {
        if (moRef == null) {
            throw new IllegalArgumentException("Null moRef passed");
        }
        return moRef.getServerGuid();
    }

    private static Map<Asset, ManagedObjectReference> getMoRefsByAssets(Asset[] serviceAssets, Map<String, String> vpxAssetScopeIdToVcId) {
        HashMap<Asset, ManagedObjectReference> result = new HashMap<Asset, ManagedObjectReference>();
        for (Asset serviceAsset : serviceAssets) {
            String assetScopeId = serviceAsset.getInfo().getScopeId();
            String vcId = vpxAssetScopeIdToVcId == null ? null : vpxAssetScopeIdToVcId.get(assetScopeId);
            ManagedObjectReference moRef = vcId == null ? null : VpxManagementEditorImpl.buildMoRefForVpxAsset(serviceAsset, vcId);
            result.put(serviceAsset, moRef);
        }
        return result;
    }

    private static ManagedObjectReference buildMoRefForVpxAsset(Asset serviceAsset, String vcId) {
        if (!VpxManagementEditorImpl.isVpxAsset(serviceAsset)) {
            return null;
        }
        AssetType assetType = AssetUtil.getServiceAssetType(serviceAsset);
        String instanceId = serviceAsset.getInfo().getInstanceId();
        ManagedObjectReference result = null;
        if (AssetType.HOST.equals((Object)assetType)) {
            result = new ManagedObjectReference(HOST_MO_TYPE, instanceId, vcId);
        } else if (AssetType.CLUSTER.equals((Object)assetType)) {
            result = new ManagedObjectReference(CLUSTER_MO_TYPE, instanceId, vcId);
        } else if (AssetType.VC.equals((Object)assetType)) {
            result = new ManagedObjectReference(VC_MO_TYPE, VC_MO_VALUE, vcId);
        }
        return result;
    }

    private static List<String> getVpxAssetsScopeIds(Asset[] assets) {
        ArrayList<String> result = new ArrayList<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])assets)) {
            return result;
        }
        for (Asset asset : assets) {
            String assetScopeId = asset.getInfo().getScopeId();
            if (assetScopeId == null || !VpxManagementEditorImpl.isVpxAsset(asset)) continue;
            result.add(assetScopeId);
        }
        return result;
    }

    private static boolean isVpxAsset(Asset serviceAsset) {
        AssetType assetType = AssetUtil.getServiceAssetType(serviceAsset);
        return AssetType.VC.equals((Object)assetType) || AssetType.HOST.equals((Object)assetType) || AssetType.CLUSTER.equals((Object)assetType);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssetsByMoRefs(ManagedObjectReference[] moRefs, LicenseScope scope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{moRefs, scope});
        ValidationUtil.paramsNotNull((Object[])moRefs);
        AssetSearchSpecByIdentifiersImpl searchSpec = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])moRefs)) {
            AssetIdentifier[] assetIdentifiers = this.getAssetIdentifiers(moRefs);
            searchSpec = new AssetSearchSpecByIdentifiersImpl();
            searchSpec.setAssetIdentifiers(assetIdentifiers);
        }
        Asset[] assets = this.searchAssets((AssetSearchSpec)searchSpec, scope);
        return this.createAssets(assets, scope);
    }

    @Override
    protected com.vmware.license.client.cis.management.ds.Asset[] createAssets(Asset[] serviceAssets, LicenseScope scope) {
        if (ArrayUtil.isNullOrEmpty((Object[])serviceAssets)) {
            return new com.vmware.license.client.cis.management.ds.Asset[0];
        }
        Map<Asset, ManagedObjectReference> serviceAssetToMoRef = this.getAssetToMoRef(serviceAssets);
        com.vmware.license.client.cis.management.ds.Asset[] assets = new com.vmware.license.client.cis.management.ds.Asset[serviceAssets.length];
        for (int i = 0; i < assets.length; ++i) {
            com.vmware.license.client.cis.management.ds.Asset asset = AssetUtil.createAsset(serviceAssets[i], scope);
            ManagedObjectReference moRef = serviceAssetToMoRef.get(serviceAssets[i]);
            asset.setRelatedManagedObjectRef(moRef);
            assets[i] = asset;
        }
        return assets;
    }

    private AssetIdentifier[] getAssetIdentifiers(ManagedObjectReference[] moRefs) {
        Map<String, String> vcIdToAssetScopeId = this.getVcIdToAssetScopeId(moRefs);
        AssetIdentifierImpl[] result = new AssetIdentifierImpl[moRefs.length];
        for (int i = 0; i < moRefs.length; ++i) {
            String instanceId = VpxManagementEditorImpl.getMoRefInstanceId(moRefs[i]);
            String vcId = VpxManagementEditorImpl.getMoRefVcId(moRefs[i]);
            String assetScopeIdToVcId = vcIdToAssetScopeId.get(vcId);
            result[i] = new AssetIdentifierImpl(instanceId, assetScopeIdToVcId);
        }
        return result;
    }

    private Map<String, String> getVcIdToAssetScopeId(ManagedObjectReference[] moRefs) {
        Map<String, String> vcIdToAssetScopeId = new HashMap<String, String>();
        List<String> vcIds = VpxManagementEditorImpl.getMoRefsVcIds(moRefs);
        if (vcIds.isEmpty()) {
            return vcIdToAssetScopeId;
        }
        try {
            SsoSpecificTopologyInfoProvider ssoSpecificTopologyInfoProvider = this._topologyInfoProviderFactory.getTopologyInfoProviderForVc(vcIds.get(0));
            if (ssoSpecificTopologyInfoProvider != null) {
                vcIdToAssetScopeId = ssoSpecificTopologyInfoProvider.getVcIdToNodeId(vcIds);
            }
        }
        catch (TopologyInfoRetrievalException e) {
            throw new ManagementException(e);
        }
        return vcIdToAssetScopeId;
    }

    private Map<Asset, ManagedObjectReference> getAssetToMoRef(Asset[] serviceAssets) {
        Map<Asset, ManagedObjectReference> result = new HashMap<Asset, ManagedObjectReference>();
        if (ArrayUtil.isNullOrEmpty((Object[])serviceAssets)) {
            return result;
        }
        List<String> assetScopeIdToVcIds = VpxManagementEditorImpl.getVpxAssetsScopeIds(serviceAssets);
        if (assetScopeIdToVcIds.isEmpty()) {
            return result;
        }
        Map<String, String> assetScopeIdToVcId = null;
        try {
            SsoSpecificTopologyInfoProvider ssoSpecificTopologyInfoProvider = this._topologyInfoProviderFactory.getTopologyInfoProviderForNode(assetScopeIdToVcIds.get(0));
            if (ssoSpecificTopologyInfoProvider != null) {
                assetScopeIdToVcId = ssoSpecificTopologyInfoProvider.getNodeIdToVcId(assetScopeIdToVcIds);
            }
        }
        catch (TopologyInfoRetrievalException e) {
            this._logger.warn((Object)("Topology information cannot be retrieved" + e));
        }
        result = VpxManagementEditorImpl.getMoRefsByAssets(serviceAssets, assetScopeIdToVcId);
        return result;
    }
}

