/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CostUnitUtil {
    public static final Number NO_LIMIT_VALUE = 0;
    public static final String COST_UNIT_CPU_PACKAGE = "cpuPackage";
    private static final String CPU_PACKAGE_CORE_LIMIT_DELIMITER = ":";
    private static final String CPU_PACKAGE_CORE_LIMIT_PREFIX = "cpuPackage:";
    private static final String CPU_PACKAGE_CORE_LIMIT_SUFFIX = "core";
    private static final String COST_UNIT_LOCALIZATION_KEY_FORMAT = "com.vmware.vim.license.CostUnit.%s.label";
    private static final String LEGACY_COST_UNIT_LOCALIZATION_KEY_FORMAT = "costUnit.%s.valueLabel";
    private static final String COST_UNIT_LOCALIZATION_KEY_LONG_FORMAT = "com.vmware.vim.license.CostUnit.%s.longLabel";
    private static final String LEGACY_COST_UNIT_LOCALIZATION_KEY_LONG_FORMAT = "costUnit.%s.longValueLabel";
    private static final String[] COST_UNIT_LOCALIZATION_KEY_FORMATS = new String[]{"com.vmware.vim.license.CostUnit.%s.label", "costUnit.%s.valueLabel"};
    private static final String[] COST_UNIT_LOCALIZATION_KEY_LONG_FORMATS = new String[]{"com.vmware.vim.license.CostUnit.%s.longLabel", "costUnit.%s.longValueLabel"};
    private static Localizer _messageLocalizer = new ManagementUtilLocalizer();

    static void setLocalizer(Localizer localizer) {
        _messageLocalizer = localizer;
    }

    public static void formatCostUnits(CostUnit[] costUnits) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnits)) {
            return;
        }
        for (CostUnit costUnit : costUnits) {
            CostUnitUtil.formatCostUnit(costUnit);
        }
    }

    public static void formatCostUnit(CostUnit costUnit) {
        if (costUnit == null || costUnit.getId() == null) {
            return;
        }
        String formattedId = CostUnitUtil.getShortFormattedCostUnitId(costUnit.getId());
        costUnit.setFormattedId(formattedId);
        String valueFormat = "%s " + formattedId;
        costUnit.setValueFormat(valueFormat);
    }

    public static Set<String> getCostUnitIds(CostUnit[] costUnits) {
        LinkedHashSet<String> costUnitsIds = new LinkedHashSet<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])costUnits)) {
            return costUnitsIds;
        }
        for (CostUnit costUnit : costUnits) {
            costUnitsIds.add(costUnit.getId());
        }
        return costUnitsIds;
    }

    public static void addCostUnitUsages(CostUnit[] sourceCostUnits, CostUnit[] destinationCostUnits) {
        if (ArrayUtil.isNullOrEmpty((Object[])sourceCostUnits) || ArrayUtil.isNullOrEmpty((Object[])destinationCostUnits)) {
            return;
        }
        for (CostUnit sourceCostUnit : sourceCostUnits) {
            if (sourceCostUnit.getUsage() == null) continue;
            for (CostUnit destinationCostUnit : destinationCostUnits) {
                if (destinationCostUnit.getUsage() == null || !destinationCostUnit.getId().equals(sourceCostUnit.getId())) continue;
                Double usage = destinationCostUnit.getUsage() + sourceCostUnit.getUsage();
                destinationCostUnit.setUsage(usage);
            }
        }
    }

    public static String[] getShortFormattedCostUnitIds(CostUnit[] costUnits) {
        String[] result = new String[costUnits.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = CostUnitUtil.getShortFormattedCostUnitId(costUnits[i].getId());
        }
        return result;
    }

    public static String getShortFormattedCostUnitId(String costUnitId) {
        String costUnitIdentifier = CostUnitUtil.isCpuPackageCoreLimitCostUnit(costUnitId) != false ? COST_UNIT_CPU_PACKAGE : costUnitId;
        String result = CostUnitUtil.getCatalogFormattedCostUnitId(costUnitIdentifier, COST_UNIT_LOCALIZATION_KEY_FORMATS, null);
        if (result == null) {
            result = CostUnitUtil.getLocalResourceBundleFormattedCostUnitId(costUnitIdentifier, COST_UNIT_LOCALIZATION_KEY_FORMATS, new String[0]);
        }
        return result == null ? costUnitId : result;
    }

    public static String[] getLongFormattedCostUnitIds(CostUnit[] costUnits) {
        String[] result = new String[costUnits.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = CostUnitUtil.getLongFormattedCostUnitId(costUnits[i].getId());
        }
        return result;
    }

    public static String getLongFormattedCostUnitId(String costUnitId) {
        String result = null;
        if (CostUnitUtil.isCpuPackageCoreLimitCostUnit(costUnitId).booleanValue()) {
            String cores = CostUnitUtil.getCoreLimitValueFromCostUnitId(costUnitId);
            KeyAnyValueImpl coresArg = new KeyAnyValueImpl();
            coresArg.setKey("0");
            coresArg.setValue((Object)cores);
            result = CostUnitUtil.getCatalogFormattedCostUnitId(COST_UNIT_CPU_PACKAGE, COST_UNIT_LOCALIZATION_KEY_LONG_FORMATS, new KeyAnyValue[]{coresArg});
            if (result == null) {
                result = CostUnitUtil.getLocalResourceBundleFormattedCostUnitId(COST_UNIT_CPU_PACKAGE, COST_UNIT_LOCALIZATION_KEY_LONG_FORMATS, cores);
            }
        }
        if (result == null) {
            result = CostUnitUtil.getShortFormattedCostUnitId(costUnitId);
        }
        return result == null ? costUnitId : result;
    }

    private static String getCatalogFormattedCostUnitId(String costUnitIdentifier, String[] costUnitLocalizationKeyFormats, KeyAnyValue[] args) {
        for (String costUnitLocalizationKeyFormat : costUnitLocalizationKeyFormats) {
            String costUnitLocalizationKey = String.format(costUnitLocalizationKeyFormat, costUnitIdentifier);
            String costUnitFormattedId = _messageLocalizer.getCatalogLocalizedString(costUnitLocalizationKey, args);
            if (costUnitFormattedId == null) continue;
            return costUnitFormattedId;
        }
        return null;
    }

    private static String getLocalResourceBundleFormattedCostUnitId(String costUnitIdentifier, String[] costUnitLocalizationKeyFormats, String ... params) {
        for (String costUnitLocalizationKeyFormat : costUnitLocalizationKeyFormats) {
            String costUnitLocalizationKey = String.format(costUnitLocalizationKeyFormat, costUnitIdentifier);
            String costUnitFormattedId = _messageLocalizer.getLocalizedString(costUnitLocalizationKey, params);
            if (costUnitFormattedId == null) continue;
            return costUnitFormattedId;
        }
        return null;
    }

    private static Boolean isCpuPackageCoreLimitCostUnit(String costUnit) {
        if (StringUtil.isNullOrEmpty((String)costUnit)) {
            return false;
        }
        return costUnit.startsWith(CPU_PACKAGE_CORE_LIMIT_PREFIX) && costUnit.endsWith(CPU_PACKAGE_CORE_LIMIT_SUFFIX);
    }

    private static String getCoreLimitValueFromCostUnitId(String costUnitId) {
        return StringUtils.substringBetween((String)costUnitId, (String)CPU_PACKAGE_CORE_LIMIT_DELIMITER, (String)CPU_PACKAGE_CORE_LIMIT_SUFFIX);
    }

    static class ManagementUtilLocalizer
    implements Localizer {
        ManagementUtilLocalizer() {
        }

        @Override
        public String getCatalogLocalizedString(String key, KeyAnyValue[] args) {
            return ManagementUtil.getCatalogLocalizedString(key, args);
        }

        @Override
        public String getLocalizedString(String key, String ... parameters) {
            return ManagementUtil.getLocalizedString(key, parameters);
        }
    }

    static interface Localizer {
        public String getCatalogLocalizedString(String var1, KeyAnyValue[] var2);

        public String getLocalizedString(String var1, String ... var2);
    }
}

