/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ds.LimitEnforcementType;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductFamily;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.CostUnitUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vim.binding.vim.host.ConnectInfo;
import com.vmware.vim.binding.vim.host.Summary;

public class HostConnectionUtil {
    private static final String HOST_LICENSE_DEFAULT_NAME = "License 1";

    public static Asset previewHostAsset(ConnectInfo connectInfo, License[] inventoryLicenses) {
        if (connectInfo == null) {
            return null;
        }
        Asset hostAsset = new Asset();
        hostAsset.setUri(UriUtil.buildExternalAssetUri());
        hostAsset.setType(AssetType.HOST);
        String name = HostConnectionUtil.getHostAssetName(connectInfo);
        hostAsset.setName(name);
        License evaluationInfo = HostConnectionUtil.previewHostEvaluationInfo(connectInfo);
        hostAsset.setEvaluationLicense(evaluationInfo);
        ProductFamily productFamily = HostConnectionUtil.getProductFamily(connectInfo);
        hostAsset.setProductFamily(productFamily);
        String version = HostConnectionUtil.getHostVersion(connectInfo);
        hostAsset.setVersion(version);
        CostUnit[] costUnitUsages = HostConnectionUtil.calculateHostCostUnitUsages(connectInfo);
        License license = HostConnectionUtil.previewHostLicense(connectInfo, inventoryLicenses, costUnitUsages, hostAsset);
        hostAsset.setLicense(license);
        AssetLicenseState licenseState = AssetUtil.getAssetLicenseState(license);
        hostAsset.setLicenseState(licenseState);
        if (AssetLicenseState.UNLICENSED.equals((Object)licenseState) || costUnitUsages == null) {
            costUnitUsages = new CostUnit[]{};
        }
        hostAsset.setCostUnitUsage(costUnitUsages);
        return hostAsset;
    }

    private static String getHostAssetName(ConnectInfo connectInfo) {
        return connectInfo.host.config.name;
    }

    private static License previewHostEvaluationInfo(ConnectInfo connectInfo) {
        ConnectInfo.LicenseInfo hostConnectionLicenseInfo = connectInfo.license;
        if (hostConnectionLicenseInfo == null) {
            return null;
        }
        return LicenseUtil.createEvaluationInfo(hostConnectionLicenseInfo.evaluation);
    }

    private static String getHostVersion(ConnectInfo connectInfo) {
        LicenseManager.LicenseInfo lmLicenseInfo = HostConnectionUtil.getLmLicenseInfo(connectInfo);
        if (lmLicenseInfo == null) {
            return null;
        }
        return (String)ManagementUtil.getKeyAnyValuePropertyValue("FileVersion", lmLicenseInfo.properties);
    }

    private static LicenseManager.LicenseInfo getLmLicenseInfo(ConnectInfo connectInfo) {
        ConnectInfo.LicenseInfo hostConnectionLicenseInfo = connectInfo.license;
        if (hostConnectionLicenseInfo == null) {
            return null;
        }
        return hostConnectionLicenseInfo.license;
    }

    private static CostUnit[] calculateHostCostUnitUsages(ConnectInfo connectInfo) {
        Number usage;
        String costUnitId;
        LicenseManager.LicenseInfo lmLicenseInfo = HostConnectionUtil.getLmLicenseInfo(connectInfo);
        if (lmLicenseInfo == null) {
            return new CostUnit[0];
        }
        if ("00000-00000-00000-00000-00000".equals(lmLicenseInfo.licenseKey)) {
            costUnitId = "cpuPackage";
            usage = HostConnectionUtil.getHostCpuPackages(connectInfo);
        } else {
            costUnitId = lmLicenseInfo.costUnit;
            usage = lmLicenseInfo.used;
        }
        return new CostUnit[]{CostUnitFactory.INSTANCE.createCostUnit(costUnitId, usage, null, null)};
    }

    private static ProductFamily getProductFamily(ConnectInfo connectInfo) {
        AboutInfo aboutInfo = connectInfo.host.config.product;
        if (aboutInfo == null) {
            return null;
        }
        ProductFamily resultProductFamily = ProductUtil.createProductFamily(aboutInfo.licenseProductName, aboutInfo.licenseProductVersion);
        return resultProductFamily;
    }

    private static License previewHostLicense(ConnectInfo connectInfo, License[] inventoryLicenses, CostUnit[] costUnitUsages, Asset hostAsset) {
        ConnectInfo.LicenseInfo hostConnectionLicenseInfo = connectInfo.license;
        if (hostConnectionLicenseInfo == null) {
            return null;
        }
        LicenseManager.LicenseInfo lmLicenseInfo = hostConnectionLicenseInfo.license;
        if (lmLicenseInfo == null) {
            return null;
        }
        License resultLicense = null;
        License matchingInventoryLicense = LicenseUtil.getLicenseBySerialKey(lmLicenseInfo.licenseKey, inventoryLicenses);
        if (matchingInventoryLicense != null) {
            ProductRestriction licenseProductRestriction = AssetUtil.getAssetProductRestrictionFromLicense(hostAsset, matchingInventoryLicense);
            if (licenseProductRestriction != null) {
                CostUnit[] licenseCostUnits = licenseProductRestriction.getProduct().getCostUnits();
                CostUnitUtil.addCostUnitUsages(costUnitUsages, licenseCostUnits);
            }
            resultLicense = matchingInventoryLicense;
        } else {
            resultLicense = HostConnectionUtil.previewHostConnectionLicense(connectInfo);
        }
        if (LicenseUtil.isExpiredLicense(resultLicense)) {
            resultLicense = null;
        }
        return resultLicense;
    }

    private static License previewHostConnectionLicense(ConnectInfo connectInfo) {
        ConnectInfo.LicenseInfo hostConnectionLicenseInfo = connectInfo.license;
        if (hostConnectionLicenseInfo == null) {
            return null;
        }
        License resultLicense = LicenseUtil.createLicense(hostConnectionLicenseInfo.license);
        if (resultLicense == null) {
            return null;
        }
        if (resultLicense.getIsEvaluation()) {
            Number hostCpuPackageUsage = HostConnectionUtil.getHostCpuPackages(connectInfo);
            CostUnit[] hostCostUnits = new CostUnit[]{CostUnitFactory.INSTANCE.createCostUnit("cpuPackage", hostCpuPackageUsage, CostUnitUtil.NO_LIMIT_VALUE, LimitEnforcementType.HARD_ENFORCED)};
            Product hostProduct = resultLicense.getProductRestrictions()[0].getProduct();
            hostProduct.setCostUnits(hostCostUnits);
        } else {
            resultLicense.setName(HOST_LICENSE_DEFAULT_NAME);
        }
        return resultLicense;
    }

    private static Number getHostCpuPackages(ConnectInfo connectInfo) {
        Summary.HardwareSummary hardwareSummary = connectInfo.host.hardware;
        return hardwareSummary != null ? Short.valueOf(hardwareSummary.numCpuPkgs) : null;
    }
}

