/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;

public class ManagementUtil {
    public static final boolean VSAN_LICENSING_ENABLED = true;
    public static final String SCOPE_PROPERTY_NAME = "scope";
    public static final LicenseScope SCOPE_CIS_LICENSING = new LicenseScope("licensing_service_version1");
    private static final String LICENSE_SERVICE_STRINGS = "licenseservice";

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static String getCatalogLocalizedString(String key) {
        return ManagementUtil.getCatalogLocalizedString(key, null);
    }

    public static String getCatalogLocalizedString(String key, KeyAnyValue[] args) {
        String result = LocalizationUtil.getLocalizedMessage((String)key, (KeyAnyValue[])args);
        return ManagementUtil.isStringLocalized(result, key) ? result : null;
    }

    public static String getLocalizedString(String key) {
        return ManagementUtil.getLocalizedString(key, new String[]{null});
    }

    public static String getLocalizedString(String key, String ... parameters) {
        String result = ResourceUtil.getString((String)LICENSE_SERVICE_STRINGS, (String)key, (String[])parameters, (ClassLoader)ManagementUtil.class.getClassLoader());
        return ManagementUtil.isStringLocalized(result, key) ? result : null;
    }

    public static <T> T getKeyAnyValuePropertyValue(String key, KeyAnyValue[] properties) {
        if (key == null || ArrayUtil.isNullOrEmpty((Object[])properties)) {
            return null;
        }
        for (KeyAnyValue property : properties) {
            if (!key.equals(property.getKey())) continue;
            return (T)property.getValue();
        }
        return null;
    }

    public static String getFormattedDate(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormatter = DateFormat.getDateInstance(2, ResourceUtil.getLocale());
        return dateFormatter.format(date);
    }

    private static boolean isStringLocalized(String string, String localizationKey) {
        return !ObjectUtil.objectsEqual((Object)string, (Object)localizationKey);
    }
}

