/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.CostUnitUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.CostUnitUsage;
import com.vmware.vim.binding.cis.license.ProductFamily;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import org.apache.commons.lang.StringUtils;

public class ProductUtil {
    public static final String HOST_PRODUCT_FAMILY_NAME = "VMware ESX Server";
    public static final String VC_PRODUCT_FAMILY_NAME = "VMware VirtualCenter Server";
    public static final String CLUSTER_PRODUCT_FAMILY_NAME = "VMware VSAN";
    private static final String LICENSE_DECODE_FAILED_ERROR = "DecodeError";
    private static final String LICENSE_NOT_FOUND_ERROR = "NotFoundError";

    public static Product createProduct(com.vmware.vim.binding.cis.license.Product serviceProduct, CostUnitUsage[] costUnitsUsage, CostUnitLimit[] costUnitsLimit, LicenseScope scope) {
        if (ProductUtil.isProductCorrupted(serviceProduct)) {
            return null;
        }
        URI uri = scope == null ? null : UriUtil.buildProductUri(serviceProduct.getId(), scope);
        com.vmware.license.client.cis.management.ds.ProductFamily productFamily = ProductUtil.createProductFamily(serviceProduct.getFamily());
        CostUnit[] costUnits = CostUnitFactory.INSTANCE.createCostUnits(costUnitsUsage, costUnitsLimit);
        return ProductUtil.createProduct(uri, serviceProduct.getName(), serviceProduct.getSuiteName(), productFamily, costUnits);
    }

    public static Product createProduct(URI uri, String name, String suiteName, com.vmware.license.client.cis.management.ds.ProductFamily family, CostUnit[] costUnits) {
        Product product = new Product();
        product.setUri(uri);
        product.setName(name);
        product.setSuiteName(suiteName);
        product.setFamily(family);
        product.setCostUnits(costUnits == null ? new CostUnit[]{} : costUnits);
        if (family != null) {
            AssetType assetsType = ProductUtil.getAssetsTypeByProductFamilyName(family.getName());
            product.setAssetsType(assetsType);
        }
        return product;
    }

    public static com.vmware.license.client.cis.management.ds.ProductFamily createProductFamily(ProductFamily serviceProductFamily) {
        if (serviceProductFamily == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.ProductFamily productFamily = ProductUtil.createProductFamily(serviceProductFamily.getName(), serviceProductFamily.getVersion());
        return productFamily;
    }

    public static com.vmware.license.client.cis.management.ds.ProductFamily createProductFamily(String name, String version) {
        com.vmware.license.client.cis.management.ds.ProductFamily productFamily = new com.vmware.license.client.cis.management.ds.ProductFamily();
        productFamily.setName(name);
        productFamily.setVersion(version);
        return productFamily;
    }

    public static AssetType getAssetsTypeByProductFamilyName(String productFamilyName) {
        AssetType assetType = AssetType.SOLUTION;
        boolean vsanLicensingEnabled = true;
        if (productFamilyName == null) {
            assetType = AssetType.UNKNOWN;
        } else if (HOST_PRODUCT_FAMILY_NAME.equals(productFamilyName)) {
            assetType = AssetType.HOST;
        } else if (VC_PRODUCT_FAMILY_NAME.equals(productFamilyName)) {
            assetType = AssetType.VC;
        } else if (vsanLicensingEnabled && CLUSTER_PRODUCT_FAMILY_NAME.equals(productFamilyName)) {
            assetType = AssetType.CLUSTER;
        }
        return assetType;
    }

    public static String getProductFamilyName(AssetType assetType) {
        String result = null;
        if (AssetType.HOST.equals((Object)assetType)) {
            result = HOST_PRODUCT_FAMILY_NAME;
        } else if (AssetType.VC.equals((Object)assetType)) {
            result = VC_PRODUCT_FAMILY_NAME;
        } else if (AssetType.CLUSTER.equals((Object)assetType)) {
            result = CLUSTER_PRODUCT_FAMILY_NAME;
        }
        return result;
    }

    public static boolean areProductFamiliesEqual(com.vmware.license.client.cis.management.ds.ProductFamily productFamily1, com.vmware.license.client.cis.management.ds.ProductFamily productFamily2) {
        if (productFamily1 == null || productFamily2 == null) {
            return false;
        }
        return productFamily1.getName().equals(productFamily2.getName()) && productFamily1.getVersion().equals(productFamily2.getVersion());
    }

    public static String getFormattedName(String productName, CostUnit[] costUnits) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnits)) {
            return productName;
        }
        Object[] formattedCostUnitIds = CostUnitUtil.getLongFormattedCostUnitIds(costUnits);
        String costUnitDelim = ManagementUtil.getLocalizedString("product.costUnitDelim");
        String productNameSuffix = StringUtils.join((Object[])formattedCostUnitIds, (String)costUnitDelim);
        return ManagementUtil.getLocalizedString("product.nameFormat", productName, productNameSuffix);
    }

    public static boolean isProductCorrupted(com.vmware.vim.binding.cis.license.Product serviceProduct) {
        if (serviceProduct == null) {
            return false;
        }
        String serviceProductId = serviceProduct.getId();
        return LICENSE_DECODE_FAILED_ERROR.equals(serviceProductId) || LICENSE_NOT_FOUND_ERROR.equals(serviceProductId);
    }
}

