/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareOnlineSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareOnlineSyncException;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncCheckReportGenerationStatusResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncCredentialsResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncFoldersResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncInitiateReportGenerationResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncCheckReportGenerationStatusSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncCredentialsSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncFoldersSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncInitiateReportGenerationSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncPreviewSpec;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationMyVMwareOnlineSyncEditorWrapperImpl
implements MyVMwareOnlineSyncEditor {
    private final MyVMwareOnlineSyncEditor _myVMwareOnlineSyncEditor;
    private final AuthorizationManager _authorizationManager;
    private final Log _logger = LogFactory.getLog(AuthorizationMyVMwareOnlineSyncEditorWrapperImpl.class);

    public AuthorizationMyVMwareOnlineSyncEditorWrapperImpl(MyVMwareOnlineSyncEditor myVMwareOnlineSyncEditor, AuthorizationManager authorizationManager) {
        this._myVMwareOnlineSyncEditor = myVMwareOnlineSyncEditor;
        this._authorizationManager = authorizationManager;
    }

    @Override
    public MyVMwareOnlineSyncCredentialsResult getUserEntitlementAccounts(MyVMwareOnlineSyncCredentialsSpec credentialsSpec) throws MyVMwareOnlineSyncException {
        MyVMwareOnlineSyncCredentialsResult result = this._myVMwareOnlineSyncEditor.getUserEntitlementAccounts(credentialsSpec);
        return result;
    }

    @Override
    public MyVMwareOnlineSyncFoldersResult getEntitlementAccountFolders(MyVMwareOnlineSyncFoldersSpec foldersSpec) throws MyVMwareOnlineSyncException {
        MyVMwareOnlineSyncFoldersResult result = this._myVMwareOnlineSyncEditor.getEntitlementAccountFolders(foldersSpec);
        return result;
    }

    @Override
    public MyVMwareOnlineSyncInitiateReportGenerationResult initiateReportGeneration(MyVMwareOnlineSyncInitiateReportGenerationSpec initiateReportGenerationSpec) throws MyVMwareOnlineSyncException {
        MyVMwareOnlineSyncInitiateReportGenerationResult result = this._myVMwareOnlineSyncEditor.initiateReportGeneration(initiateReportGenerationSpec);
        return result;
    }

    @Override
    public MyVMwareOnlineSyncCheckReportGenerationStatusResult checkReportGenerationStatus(MyVMwareOnlineSyncCheckReportGenerationStatusSpec checkReportStatusSpec) throws MyVMwareOnlineSyncException {
        MyVMwareOnlineSyncCheckReportGenerationStatusResult result = this._myVMwareOnlineSyncEditor.checkReportGenerationStatus(checkReportStatusSpec);
        return result;
    }

    @Override
    public MyVMwareOnlineSyncPreviewResult previewOnlineSync(MyVMwareOnlineSyncPreviewSpec onlineSyncPreviewSpec) throws MyVMwareOnlineSyncException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{onlineSyncPreviewSpec});
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(onlineSyncPreviewSpec.scope);
        this.validateLicensingPrivilegeGranted(scope);
        MyVMwareOnlineSyncPreviewResult result = this._myVMwareOnlineSyncEditor.previewOnlineSync(onlineSyncPreviewSpec);
        return result;
    }

    private void validateLicensingPrivilegeGranted(LicenseScope scope) throws MyVMwareOnlineSyncException {
        boolean licensingPrivilegeGranted;
        ValidationUtil.paramsNotNull((Object[])new Object[]{scope});
        try {
            licensingPrivilegeGranted = this._authorizationManager.isLicensingAdminPrivilegeGranted(scope);
        }
        catch (Exception e) {
            this._logger.warn((Object)"Unable to retrieve licensing privileges information. Assuming access is not granted.", (Throwable)e);
            licensingPrivilegeGranted = false;
        }
        if (!licensingPrivilegeGranted) {
            throw new MyVMwareOnlineSyncException(ManagementUtil.getLocalizedString("error.lsPrivilegeNotGranted"));
        }
    }
}

