/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.util;

import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.myvmwaresync.ds.EntitlementAccountToFoldersIds;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareLicenseInfo;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSerialKeyInfo;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncContext;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareLicenseCreateSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareLicenseUpdateSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncCommitSpec;
import com.vmware.license.client.cis.util.DateUtil;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.MyVMwareLicenseDetails;
import com.vmware.vim.binding.cis.license.management.LicenseAddSpec;
import com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec;
import com.vmware.vim.binding.cis.license.management.MyVMwareEntitlementAccountFolders;
import com.vmware.vim.binding.cis.license.management.MyVMwareSyncInfo;
import com.vmware.vim.binding.cis.license.management.MyVMwareSyncSpec;
import com.vmware.vim.binding.impl.cis.license.MyVMwareLicenseDetailsImpl;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareEntitlementAccountFoldersImpl;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareSerialKeyLicenseAddSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareSerialKeyLicenseUpdateSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareSyncContextImpl;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareSyncSpecImpl;
import com.vmware.vim.binding.impl.vmodl.BinaryImpl;
import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;

public class MyVMwareSyncUtil {
    public static final String LICENSE_METADATA_KEY = "myVMwareLicenseDetails";

    public static MyVMwareLicenseInfo buildUiMyVMwareLicenseInfo(LicenseInfo serviceLicenseInfo) {
        if (serviceLicenseInfo == null) {
            return null;
        }
        KeyAnyValue[] properties = serviceLicenseInfo.getProperties();
        if (properties == null) {
            Object[] restrictions = serviceLicenseInfo.getRestrictions();
            if (ArrayUtil.isNullOrEmpty((Object[])restrictions)) {
                return null;
            }
            Object[] capabilities = restrictions[0].getCapability();
            if (ArrayUtil.isNullOrEmpty((Object[])capabilities)) {
                return null;
            }
            properties = capabilities[0].getProperties();
        }
        MyVMwareLicenseInfo resultUiMyVMwareLicenseInfo = MyVMwareSyncUtil.buildUiMyVMwareLicenseInfo(properties);
        return resultUiMyVMwareLicenseInfo;
    }

    public static MyVMwareLicenseInfo buildUiMyVMwareLicenseInfo(KeyAnyValue[] serviceLicenseProperties) {
        if (ArrayUtil.isNullOrEmpty((Object[])serviceLicenseProperties)) {
            return null;
        }
        ArrayList<MyVMwareSerialKeyInfo> serialKeysMyVMwareInfo = new ArrayList<MyVMwareSerialKeyInfo>();
        for (KeyAnyValue serviceLicenseProperty : serviceLicenseProperties) {
            if (!LICENSE_METADATA_KEY.equals(serviceLicenseProperty.getKey())) continue;
            MyVMwareLicenseDetails serviceMyVMwareLicenseDetails = (MyVMwareLicenseDetails)serviceLicenseProperty.getValue();
            MyVMwareSerialKeyInfo serialKeyMyVMwareInfo = MyVMwareSyncUtil.buildUiMyVMwareSerialKeyInfo(serviceMyVMwareLicenseDetails);
            serialKeysMyVMwareInfo.add(serialKeyMyVMwareInfo);
        }
        if (serialKeysMyVMwareInfo.isEmpty()) {
            return null;
        }
        MyVMwareLicenseInfo resultMyVMwareLicenseInfo = new MyVMwareLicenseInfo();
        resultMyVMwareLicenseInfo.setSerialKeysInfo(serialKeysMyVMwareInfo.toArray(new MyVMwareSerialKeyInfo[serialKeysMyVMwareInfo.size()]));
        return resultMyVMwareLicenseInfo;
    }

    public static MyVMwareSerialKeyInfo buildUiMyVMwareSerialKeyInfo(MyVMwareLicenseDetails serviceMyVMwareLicenseDetails) {
        if (serviceMyVMwareLicenseDetails == null) {
            throw new IllegalArgumentException("Unable to build UI My VMware metadata from LS My VMware metadata.");
        }
        MyVMwareSerialKeyInfo result = new MyVMwareSerialKeyInfo();
        result.setVersion(serviceMyVMwareLicenseDetails.getVersion());
        result.setData(serviceMyVMwareLicenseDetails.getData().asArray());
        result.setLastUpdateTimestamp(DateUtil.getDate(serviceMyVMwareLicenseDetails.getLastUpdateTimestamp()));
        return result;
    }

    public static MyVMwareLicenseDetails buildServiceMyVMwareLicenseDetails(MyVMwareSerialKeyInfo uiMyVMwareSerialKeyInfo) {
        if (uiMyVMwareSerialKeyInfo == null || uiMyVMwareSerialKeyInfo.getVersion() == null || uiMyVMwareSerialKeyInfo.getData() == null) {
            throw new IllegalArgumentException("Unable to build LS My VMware metadata from UI My VMware metadata.");
        }
        MyVMwareLicenseDetailsImpl result = new MyVMwareLicenseDetailsImpl();
        result.setVersion(uiMyVMwareSerialKeyInfo.getVersion());
        result.setData((Binary)new BinaryImpl(uiMyVMwareSerialKeyInfo.getData()));
        return result;
    }

    public static LicenseUpdateSpec[] buildServiceLicenseUpdateSpecs(MyVMwareLicenseUpdateSpec[] uiLicenseUpdateSpecs) {
        LicenseUpdateSpec[] resultServiceSpecs = new LicenseUpdateSpec[uiLicenseUpdateSpecs.length];
        for (int i = 0; i < resultServiceSpecs.length; ++i) {
            MyVMwareLicenseUpdateSpec uiLicenseUpdateSpec = uiLicenseUpdateSpecs[i];
            URI serviceLicenseId = UriUtil.extractObjectIdAsUri(uiLicenseUpdateSpec.uri);
            MyVMwareLicenseDetails[] serviceLicenseDetails = MyVMwareSyncUtil.buildServiceMyVMwareLicenseDetails(uiLicenseUpdateSpec.myVMwareLicenseInfo);
            MyVMwareSerialKeyLicenseUpdateSpecImpl resultServiceSpec = new MyVMwareSerialKeyLicenseUpdateSpecImpl();
            resultServiceSpec.setLicenseId(serviceLicenseId);
            resultServiceSpec.setSerialKeys(uiLicenseUpdateSpec.serialKeys);
            resultServiceSpec.setLicenseDetails(serviceLicenseDetails);
            resultServiceSpecs[i] = resultServiceSpec;
        }
        return resultServiceSpecs;
    }

    public static LicenseAddSpec[] buildServiceLicenseAddSpecs(MyVMwareLicenseCreateSpec[] uiLicenseCreateSpecs) {
        LicenseAddSpec[] resultServiceSpecs = new LicenseAddSpec[uiLicenseCreateSpecs.length];
        for (int i = 0; i < resultServiceSpecs.length; ++i) {
            MyVMwareLicenseCreateSpec uiLicenseCreateSpec = uiLicenseCreateSpecs[i];
            MyVMwareLicenseDetails[] serviceLicenseDetails = MyVMwareSyncUtil.buildServiceMyVMwareLicenseDetails(uiLicenseCreateSpec.myVMwareLicenseInfo);
            MyVMwareSerialKeyLicenseAddSpecImpl resultServiceSpec = new MyVMwareSerialKeyLicenseAddSpecImpl();
            resultServiceSpec.setName(uiLicenseCreateSpec.name);
            resultServiceSpec.setSerialKeys(uiLicenseCreateSpec.serialKeys);
            resultServiceSpec.setLicenseDetails(serviceLicenseDetails);
            resultServiceSpecs[i] = resultServiceSpec;
        }
        return resultServiceSpecs;
    }

    public static MyVMwareLicenseDetails[] buildServiceMyVMwareLicenseDetails(MyVMwareLicenseInfo uiMyVMwareLicenseInfo) {
        if (uiMyVMwareLicenseInfo == null || uiMyVMwareLicenseInfo.getSerialKeysInfo() == null) {
            return new MyVMwareLicenseDetails[0];
        }
        MyVMwareSerialKeyInfo[] uiMyVMwareSerialKeysInfo = uiMyVMwareLicenseInfo.getSerialKeysInfo();
        MyVMwareLicenseDetails[] resultServiceLicenseDetails = new MyVMwareLicenseDetails[uiMyVMwareSerialKeysInfo.length];
        for (int i = 0; i < uiMyVMwareSerialKeysInfo.length; ++i) {
            resultServiceLicenseDetails[i] = MyVMwareSyncUtil.buildServiceMyVMwareLicenseDetails(uiMyVMwareSerialKeysInfo[i]);
        }
        return resultServiceLicenseDetails;
    }

    public static void updateDefaultNewLicensesNames(License[] newLicenses, int existingInventoryLicensesTotal) {
        if (ArrayUtil.isNullOrEmpty((Object[])newLicenses)) {
            return;
        }
        String[] newLicensesNames = LicenseUtil.getNewLicensesNames(newLicenses.length, existingInventoryLicensesTotal);
        for (int i = 0; i < newLicenses.length; ++i) {
            newLicenses[i].setName(newLicensesNames[i]);
        }
    }

    public static com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo buildUiMyVMwareSyncInfo(MyVMwareSyncInfo serviceSyncInfo) {
        if (serviceSyncInfo == null) {
            return null;
        }
        com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo uiSyncInfo = new com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo();
        uiSyncInfo.setSyncTime(serviceSyncInfo.getInventorySyncTimestamp());
        uiSyncInfo.setUpdatedKeysCount(serviceSyncInfo.getLicensesUpdatedTotal());
        uiSyncInfo.setAddedKeysCount(serviceSyncInfo.getLicensesAddedTotal());
        uiSyncInfo.setRemovedKeysCount(serviceSyncInfo.getLicensesRemovedTotal());
        com.vmware.vim.binding.cis.license.management.MyVMwareSyncContext serviceSyncContext = serviceSyncInfo.getMyVMwareSyncContext();
        if (serviceSyncContext != null) {
            MyVMwareSyncContext uiSyncContext = MyVMwareSyncUtil.buildUiMyVMwareSyncContext(serviceSyncContext);
            uiSyncInfo.setMyVMwareSyncContext(uiSyncContext);
        }
        return uiSyncInfo;
    }

    public static MyVMwareSyncContext buildUiMyVMwareSyncContext(com.vmware.vim.binding.cis.license.management.MyVMwareSyncContext serviceSyncContext) {
        Calendar serviceSyncToDate;
        MyVMwareSyncContext uiSyncContext = new MyVMwareSyncContext();
        uiSyncContext.setMyVMwareUsername(serviceSyncContext.getUsername());
        EntitlementAccountToFoldersIds[] uiEntitlementAccountToFoldersIds = MyVMwareSyncUtil.buildUiEntitlementAccountToFolderIds(serviceSyncContext.getEntitlementAccountFolders());
        uiSyncContext.setEntitlementAccountsToFoldersIds(uiEntitlementAccountToFoldersIds);
        Calendar serviceSyncFromDate = serviceSyncContext.getSyncFromDate();
        if (serviceSyncFromDate != null) {
            uiSyncContext.setFromDate(serviceSyncFromDate.getTime());
        }
        if ((serviceSyncToDate = serviceSyncContext.getSyncToDate()) != null) {
            uiSyncContext.setToDate(serviceSyncToDate.getTime());
        }
        return uiSyncContext;
    }

    public static EntitlementAccountToFoldersIds[] buildUiEntitlementAccountToFolderIds(MyVMwareEntitlementAccountFolders[] serviceEntitlementAccountFolders) {
        if (serviceEntitlementAccountFolders == null) {
            return null;
        }
        EntitlementAccountToFoldersIds[] uiEntitlementAccountToFolderIds = new EntitlementAccountToFoldersIds[serviceEntitlementAccountFolders.length];
        for (int i = 0; i < serviceEntitlementAccountFolders.length; ++i) {
            MyVMwareEntitlementAccountFolders serviceAccountFolders = serviceEntitlementAccountFolders[i];
            EntitlementAccountToFoldersIds uiAccountFolders = new EntitlementAccountToFoldersIds();
            uiAccountFolders.setEntitlementAccountId(serviceAccountFolders.getEaNumber());
            uiAccountFolders.setEntitlementAccountName(serviceAccountFolders.getEaName());
            uiAccountFolders.setFolderIds(serviceAccountFolders.getFolderIds());
            uiEntitlementAccountToFolderIds[i] = uiAccountFolders;
        }
        return uiEntitlementAccountToFolderIds;
    }

    public static com.vmware.vim.binding.cis.license.management.MyVMwareSyncContext buildServiceSyncContext(MyVMwareSyncContext uiSyncContext) {
        if (uiSyncContext == null) {
            return null;
        }
        MyVMwareSyncContextImpl serviceSyncContext = new MyVMwareSyncContextImpl();
        serviceSyncContext.setUsername(uiSyncContext.getMyVMwareUsername());
        MyVMwareEntitlementAccountFolders[] serviceMyVMwareEntitlementAccountsFolders = MyVMwareSyncUtil.buildServiceEntitlementAccountsFolders(uiSyncContext.getEntitlementAccountsToFoldersIds());
        serviceSyncContext.setEntitlementAccountFolders(serviceMyVMwareEntitlementAccountsFolders);
        Calendar serviceFromDateCalendar = null;
        if (uiSyncContext.getFromDate() != null) {
            serviceFromDateCalendar = Calendar.getInstance();
            serviceFromDateCalendar.setTime(uiSyncContext.getFromDate());
        }
        serviceSyncContext.setSyncFromDate(serviceFromDateCalendar);
        Calendar serviceToDateCalendar = null;
        if (uiSyncContext.getToDate() != null) {
            serviceToDateCalendar = Calendar.getInstance();
            serviceToDateCalendar.setTime(uiSyncContext.getToDate());
        }
        serviceSyncContext.setSyncToDate(serviceToDateCalendar);
        return serviceSyncContext;
    }

    public static MyVMwareEntitlementAccountFolders[] buildServiceEntitlementAccountsFolders(EntitlementAccountToFoldersIds[] uiEntitlementAccountsToFoldersIds) {
        if (uiEntitlementAccountsToFoldersIds == null) {
            return null;
        }
        MyVMwareEntitlementAccountFolders[] serviceEntitlementAccountsFolders = new MyVMwareEntitlementAccountFolders[uiEntitlementAccountsToFoldersIds.length];
        for (int i = 0; i < uiEntitlementAccountsToFoldersIds.length; ++i) {
            MyVMwareEntitlementAccountFoldersImpl serviceAccountFolders = new MyVMwareEntitlementAccountFoldersImpl();
            EntitlementAccountToFoldersIds uiAccountToFolderIds = uiEntitlementAccountsToFoldersIds[i];
            serviceAccountFolders.setEaNumber(uiAccountToFolderIds.getEntitlementAccountId());
            serviceAccountFolders.setEaName(uiAccountToFolderIds.getEntitlementAccountName());
            serviceAccountFolders.setFolderIds(uiAccountToFolderIds.getFolderIds());
            serviceEntitlementAccountsFolders[i] = serviceAccountFolders;
        }
        return serviceEntitlementAccountsFolders;
    }

    public static MyVMwareSyncSpec buildServiceMyVMwareSyncSpec(MyVMwareSyncCommitSpec uiSyncCommitSpec) {
        MyVMwareSyncSpecImpl serviceSyncSpec = new MyVMwareSyncSpecImpl();
        LicenseUpdateSpec[] serviceLicenseUpdateSpecs = MyVMwareSyncUtil.buildServiceLicenseUpdateSpecs(uiSyncCommitSpec.myVMwareLicenseUpdateSpecs);
        serviceSyncSpec.setLicensesToUpdate(serviceLicenseUpdateSpecs);
        LicenseAddSpec[] serviceLicenseAddSpecs = MyVMwareSyncUtil.buildServiceLicenseAddSpecs(uiSyncCommitSpec.myVMwareLicenseCreateSpecs);
        serviceSyncSpec.setLicensesToAdd(serviceLicenseAddSpecs);
        URI[] serviceLicenseIds = UriUtil.extractObjectIdsAsUris(uiSyncCommitSpec.licenseUrisForRemoval);
        serviceSyncSpec.setLicensesToRemove(serviceLicenseIds);
        com.vmware.vim.binding.cis.license.management.MyVMwareSyncContext serviceSyncContext = MyVMwareSyncUtil.buildServiceSyncContext(uiSyncCommitSpec.myVMwareSyncContext);
        serviceSyncSpec.setMyVMwareSyncContext(serviceSyncContext);
        return serviceSyncSpec;
    }
}

