/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.impl;

import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.CostUnitUsage;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;

public class CostUnitReportFactory
extends CostUnitFactory {
    public static CostUnitReportFactory INSTANCE = new CostUnitReportFactory();

    @Override
    public CostUnit[] createCostUnits(CostUnitUsage[] costUnitUsages, CostUnitLimit[] costUnitLimits) {
        CostUnitUsage[] costUnitUsagesWithValidIds = this.getCostUnitUsagesWithValidIds(costUnitUsages);
        CostUnitLimit[] costUnitLimitsWithValidIds = this.getCostUnitLimitsWithValidIds(costUnitLimits);
        return super.createCostUnits(costUnitUsagesWithValidIds, costUnitLimitsWithValidIds);
    }

    private CostUnitUsage[] getCostUnitUsagesWithValidIds(CostUnitUsage[] costUnitUsages) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitUsages)) {
            return costUnitUsages;
        }
        ArrayList<CostUnitUsage> costUnitUsagesWithValidIds = new ArrayList<CostUnitUsage>();
        for (CostUnitUsage costUnitUsage : costUnitUsages) {
            com.vmware.vim.binding.cis.license.CostUnit costUnit = costUnitUsage.getUnit();
            if (costUnit == null || StringUtil.isNullOrEmpty((String)costUnit.getId())) continue;
            costUnitUsagesWithValidIds.add(costUnitUsage);
        }
        return costUnitUsagesWithValidIds.toArray(new CostUnitUsage[costUnitUsagesWithValidIds.size()]);
    }

    private CostUnitLimit[] getCostUnitLimitsWithValidIds(CostUnitLimit[] costUnitLimits) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitLimits)) {
            return costUnitLimits;
        }
        ArrayList<CostUnitLimit> costUnitLimitsWithValidIds = new ArrayList<CostUnitLimit>();
        for (CostUnitLimit costUnitLimit : costUnitLimits) {
            com.vmware.vim.binding.cis.license.CostUnit costUnit = costUnitLimit.getUnit();
            if (costUnit == null || StringUtil.isNullOrEmpty((String)costUnit.getId())) continue;
            costUnitLimitsWithValidIds.add(costUnitLimit);
        }
        return costUnitLimitsWithValidIds.toArray(new CostUnitLimit[costUnitLimitsWithValidIds.size()]);
    }
}

