/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.library.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.content.library.Subscriptions;
import com.vmware.content.library.SubscriptionsTypes;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.uri.VapiUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.library.data.SubscriptionsClusterData;
import com.vmware.vsphere.client.library.data.SubscriptionsResourcePoolData;
import com.vmware.vsphere.client.library.data.SusbcriptionsHostData;
import com.vmware.vsphere.client.library.model.ComputeResourceSubscriptionResult;
import com.vmware.vsphere.client.library.specs.ComputeResourceSubscriptionSpec;
import com.vmware.vsphere.client.library.specs.CreateSubscriptionSpec;
import com.vmware.vsphere.client.library.specs.DeleteSubscriptionsSpec;
import com.vmware.vsphere.client.library.specs.EditSubscriptionSpec;
import com.vmware.vsphere.client.library.util.LibraryUtil;
import com.vmware.vsphere.client.vapi.tasks.VapiAsyncCallback;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibrarySubscriptionsMutationProvider
implements MutationProvider {
    private static final String ASSIGN_VM_TO_POOL_PRIVILEGE = "Resource.AssignVMToPool";
    private static final Log _logger = LogFactory.getLog(LibrarySubscriptionsMutationProvider.class);
    private final Subscriptions _subscriptionsService;
    private final QueryBindingService _queryBindingService;
    private final ThreadPoolExecutor _threadPoolExecutor;
    private VapiTaskMonitor _vapiTaskMonitor;

    public void setVapiTaskMonitor(VapiTaskMonitor vapiTaskMonitor) {
        this._vapiTaskMonitor = vapiTaskMonitor;
    }

    public LibrarySubscriptionsMutationProvider(Subscriptions subscriptionsService, QueryBindingServiceFactory queryBindingServiceFactory, ThreadPoolExecutor threadPoolExecutor) {
        this._subscriptionsService = subscriptionsService;
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._threadPoolExecutor = threadPoolExecutor;
    }

    public OperationResult apply(URI libraryUri, EditSubscriptionSpec editSubscriptionSpec) {
        OperationResult result = new OperationResult();
        String libraryId = VapiUriSchemeUtil.getId((URI)libraryUri);
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        SubscriptionsTypes.UpdateSpec updateSpec = new SubscriptionsTypes.UpdateSpec();
        updateSpec.setSubscribedLibraryPlacement(editSubscriptionSpec.updateSpecPlacement);
        _logger.info((Object)("Initiating create subscription library. Client token: " + asyncCallback.getActivationId()));
        try {
            this._subscriptionsService.update(libraryId, editSubscriptionSpec.subscriptionId, updateSpec, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            String errorMsg = "Create library subscription failed: ";
            _logger.error((Object)errorMsg, (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult apply(URI libraryUri, CreateSubscriptionSpec subscriptionSpec) {
        OperationResult result = new OperationResult();
        String libraryId = VapiUriSchemeUtil.getId((URI)libraryUri);
        String clientToken = UUID.randomUUID().toString();
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        SubscriptionsTypes.CreateSpec createSpec = new SubscriptionsTypes.CreateSpec();
        createSpec.setSubscribedLibrary(subscriptionSpec.createSpecSubscribedLibrary);
        _logger.info((Object)("Initiating create subscription library. Client token: " + asyncCallback.getActivationId()));
        try {
            this._subscriptionsService.create(clientToken, libraryId, createSpec, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            String errorMsg = "Create library subscription failed: ";
            _logger.error((Object)errorMsg, (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult[] removeOnMultiEntity(URI[] libraryUris, DeleteSubscriptionsSpec subscriptionsSpec) {
        if (ArrayUtil.isNullOrEmpty((Object[])libraryUris)) {
            return new OperationResult[0];
        }
        OperationResult[] results = null;
        try {
            results = this.invokeTasks(this.buildRequests(libraryUris[0], subscriptionsSpec.subscriptions));
        }
        catch (Exception e) {
            String errorMsg = "Delete library subscription failed: ";
            OperationResult result = new OperationResult();
            _logger.error((Object)errorMsg, (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
            return new OperationResult[]{result};
        }
        return results;
    }

    public ValidationResult validate(ComputeResourceSubscriptionSpec checkSpec) {
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)checkSpec.targetRef, HostSystem.class)) {
            return this.validateHost(checkSpec.targetRef);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)checkSpec.targetRef, ResourcePool.class)) {
            return this.validateRp(checkSpec.targetRef);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)checkSpec.targetRef, ClusterComputeResource.class)) {
            return this.validateCluster(checkSpec.targetRef);
        }
        ValidationResult result = new ValidationResult();
        String errMsg = LibraryUtil.getLocalizedString("destinationValidation.invalidSelection");
        result.error = ErrorTransformUtil.convertError((String)errMsg);
        return result;
    }

    private ValidationResult validateHost(ManagedObjectReference destinationRef) {
        ValidationResult result = new ValidationResult();
        result.result = new ComputeResourceSubscriptionResult();
        SusbcriptionsHostData hostData = (SusbcriptionsHostData)((Object)this._queryBindingService.prepare(SusbcriptionsHostData.class).fetch((Object)destinationRef));
        if (!this.isHostAvailable(hostData)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.HostNotConnected");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        if (!this.hasAssignVmToPoolPrivilige(hostData.privileges)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.HostNoPrivilege");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        ((ComputeResourceSubscriptionResult)result.result).resourcePool = hostData.resourcePool;
        ((ComputeResourceSubscriptionResult)result.result).computeResource = hostData.parent;
        return result;
    }

    private ValidationResult validateRp(ManagedObjectReference destinationRef) {
        ValidationResult result = new ValidationResult();
        result.result = new ComputeResourceSubscriptionResult();
        SubscriptionsResourcePoolData rpData = (SubscriptionsResourcePoolData)this._queryBindingService.prepare(SubscriptionsResourcePoolData.class).fetch((Object)destinationRef);
        if (!this.isAtLeastOneHostConnected(rpData.hostsData)) {
            String key = rpData.cluster != null ? "destinationValidation.ParentClusterNoConnectedHostsFound" : "destinationValidation.ParentHostNotConnected";
            String errMsg = LibraryUtil.getLocalizedString(key);
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        if (!this.hasAssignVmToPoolPrivilige(rpData.privileges)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.ResourcePoolNoPrivilege");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        ((ComputeResourceSubscriptionResult)result.result).resourcePool = destinationRef;
        ((ComputeResourceSubscriptionResult)result.result).computeResource = rpData.owner;
        return result;
    }

    private ValidationResult validateCluster(ManagedObjectReference destinationRef) {
        ValidationResult result = new ValidationResult();
        result.result = new ComputeResourceSubscriptionResult();
        SubscriptionsClusterData clusterData = (SubscriptionsClusterData)this._queryBindingService.prepare(SubscriptionsClusterData.class).fetch((Object)destinationRef);
        if (!ArrayUtil.isNullOrEmpty((Object[])clusterData.hostsData) && !this.isAtLeastOneHostConnected(clusterData.hostsData)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.NoConnectedHostsFound");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        if (!clusterData.drsEnabled) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.nonDrsCluster");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        if (!this.hasAssignVmToPoolPrivilige(clusterData.privileges)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.ClusterNoPrivilege");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        ((ComputeResourceSubscriptionResult)result.result).resourcePool = clusterData.resourcePool;
        ((ComputeResourceSubscriptionResult)result.result).computeResource = destinationRef;
        return result;
    }

    private boolean isAtLeastOneHostConnected(SusbcriptionsHostData[] hostsData) {
        for (SusbcriptionsHostData hostData : hostsData) {
            if (!this.isHostAvailable(hostData)) continue;
            return true;
        }
        return false;
    }

    private boolean isHostAvailable(SusbcriptionsHostData hostData) {
        boolean isHostConnected = hostData.connectionState == null || hostData.connectionState == HostSystem.ConnectionState.connected;
        boolean isHostInMaintenanceMode = hostData.inMaintenanceMode;
        boolean isHostInTransition = false;
        if (hostData.disabledMethods != null) {
            String[] disabledMethods = hostData.disabledMethods;
            List<String> arrayList = Arrays.asList(disabledMethods);
            isHostInTransition = arrayList.contains("EnterMaintenanceMode_Task") && arrayList.contains("ExitMaintenanceMode_Task");
        }
        return isHostConnected && !isHostInMaintenanceMode && !isHostInTransition;
    }

    private List<Callable<OperationResult>> buildRequests(URI libraryUri, String[] subscriptions) {
        ArrayList<Callable<OperationResult>> tasks = new ArrayList<Callable<OperationResult>>();
        HttpServletRequest httpRequest = SessionUtil.getHttpRequest();
        for (String subscription : subscriptions) {
            tasks.add(this.createCallable(httpRequest, libraryUri, subscription));
        }
        return tasks;
    }

    private OperationResult[] invokeTasks(List<Callable<OperationResult>> tasks) throws InterruptedException, ExecutionException {
        List<Future<OperationResult>> tasksResults = null;
        try {
            tasksResults = this._threadPoolExecutor.invokeAll(tasks);
        }
        catch (InterruptedException ex) {
            _logger.error((Object)"Deleting of subscriptions was interrupted.", (Throwable)ex);
            return new OperationResult[0];
        }
        if (ArrayUtil.isNullOrEmpty(tasksResults)) {
            return new OperationResult[0];
        }
        ArrayList<OperationResult> results = new ArrayList<OperationResult>();
        for (Future<OperationResult> taskResult : tasksResults) {
            if (taskResult.isCancelled()) continue;
            results.add(taskResult.get());
        }
        return (OperationResult[])ArrayUtil.toArray(results, OperationResult.class);
    }

    private Callable<OperationResult> createCallable(final HttpServletRequest httpRequest, final URI libraryUri, final String subscription) {
        return new Callable<OperationResult>(){

            @Override
            public OperationResult call() throws Exception {
                OperationResult result = new OperationResult();
                SessionUtil.setHttpRequest((HttpServletRequest)httpRequest);
                String libraryId = VapiUriSchemeUtil.getId((URI)libraryUri);
                VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, LibrarySubscriptionsMutationProvider.this._vapiTaskMonitor);
                try {
                    LibrarySubscriptionsMutationProvider.this._subscriptionsService.delete(libraryId, subscription, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
                    result.task = asyncCallback.waitForActivationTask();
                }
                catch (Exception e) {
                    String errorMsg = "Delete library subscription failed: ";
                    _logger.error((Object)errorMsg, (Throwable)e);
                    result.error = ErrorTransformUtil.convertError((Exception)e);
                }
                return result;
            }
        };
    }

    private boolean hasAssignVmToPoolPrivilige(String[] privileges) {
        return AuthorizationUtil.isPrivilegeGranted((String[])new String[]{ASSIGN_VM_TO_POOL_PRIVILEGE}, (String[])privileges);
    }
}

