/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.impl;

import com.vmware.content.library.Item;
import com.vmware.content.library.ItemModel;
import com.vmware.content.library.item.TransferStatus;
import com.vmware.content.library.item.UpdateSession;
import com.vmware.content.library.item.UpdateSessionModel;
import com.vmware.content.library.item.updatesession.File;
import com.vmware.content.library.item.updatesession.FileTypes;
import com.vmware.content.library.item.updatesession.PreviewInfo;
import com.vmware.content.library.item.updatesession.PreviewWarningInfo;
import com.vmware.content.library.item.updatesession.WarningBehavior;
import com.vmware.vapi.std.errors.NotFound;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.libraryItem.model.FileType;
import com.vmware.vsphere.client.libraryItem.model.LibraryItemEndpointInfo;
import com.vmware.vsphere.client.libraryItem.model.LibraryItemValidationResult;
import com.vmware.vsphere.client.libraryItem.specs.ImportLibraryItemCompleteSpec;
import com.vmware.vsphere.client.libraryItem.specs.ImportLibraryItemProgressSpec;
import com.vmware.vsphere.client.libraryItem.specs.ImportLibraryItemSpec;
import com.vmware.vsphere.client.libraryItem.specs.ImportLibraryItemUpdateSessionSpec;
import com.vmware.vsphere.client.libraryItem.specs.ImportLibraryItemValidateSpec;
import com.vmware.vsphere.client.libraryItem.specs.ImportLibraryOvaItemCompleteSpec;
import com.vmware.vsphere.client.libraryItem.specs.QueryUpdateSessionStateSpec;
import com.vmware.vsphere.client.libraryItem.util.LibraryItemUtil;
import com.vmware.vsphere.client.libraryItem.util.TransferUtil;
import com.vmware.vsphere.client.util.uri.UriSchemeUtil;
import com.vmware.vsphere.client.util.vapi.VapiUtil;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryItemImportMutationProvider
implements MutationProvider {
    private final int MAX_RETRY_COUNT = 100;
    private final int TRANSFER_STATUS_CHECK_INTERVAL = 3000;
    private final String UPDATE_SESSION_NOT_FOUND = "UPDATE_SESSION_NOT_FOUND";
    private static final Log _logger = LogFactory.getLog(LibraryItemImportMutationProvider.class);
    private final Item _libraryItemService;
    private final UpdateSession _updateSession;
    private final File _updateSessionFile;
    private final FeatureStateService _featureStateService;
    private VapiTaskMonitor _vapiTaskMonitor;
    private boolean _isUpdate = false;

    public void setVapiTaskMonitor(VapiTaskMonitor vapiTaskMonitor) {
        this._vapiTaskMonitor = vapiTaskMonitor;
    }

    public LibraryItemImportMutationProvider(Item libraryItemService, UpdateSession updateSession, File updateSessionFile, FeatureStateService featureStateService) {
        this._libraryItemService = libraryItemService;
        this._updateSession = updateSession;
        this._updateSessionFile = updateSessionFile;
        this._featureStateService = featureStateService;
    }

    public OperationResult add(ImportLibraryItemSpec importSpec) {
        OperationResult operationResult = new OperationResult();
        String uriScheme = importSpec.source.getScheme();
        String libraryItemId = null;
        this._isUpdate = importSpec.isUpdate;
        try {
            if (!TransferUtil.isSourceSchemeSupported(importSpec.source)) {
                throw new IllegalArgumentException("Unsupported URI scheme:" + uriScheme);
            }
            libraryItemId = this.createLibraryItem(importSpec);
        }
        catch (Exception e) {
            _logger.error((Object)("Creating library item failed. spec = " + ObjectUtil.prettyPrint((Object)((Object)importSpec))), (Throwable)e);
            operationResult.error = ErrorTransformUtil.convertError((Exception)e);
            return operationResult;
        }
        operationResult = LibraryItemUtil.triggerUploadContents(importSpec, libraryItemId, operationResult, this._libraryItemService, this._updateSession, this._updateSessionFile, this._vapiTaskMonitor);
        return operationResult;
    }

    private String createLibraryItem(ImportLibraryItemSpec importSpec) {
        String libraryId = UriSchemeUtil.getId((URI)importSpec.target);
        ItemModel itemSpec = new ItemModel();
        itemSpec.setDescription(importSpec.itemDescription);
        itemSpec.setName(importSpec.itemName);
        itemSpec.setLibraryId(libraryId);
        FileType sourceType = TransferUtil.getFileType(importSpec.source);
        String itemType = sourceType == FileType.OVA && this.isImportOvaSupportAvailableForVc(importSpec) ? "ovf" : TransferUtil.getLibraryItemType(sourceType);
        itemSpec.setType(itemType);
        String createToken = VapiUtil.newClientToken();
        String libraryItemId = this._libraryItemService.create(createToken, itemSpec);
        return libraryItemId;
    }

    private void deleteSession(String sessionID) {
        try {
            this._updateSession.delete(sessionID);
        }
        catch (Exception sessionDeleteException) {
            _logger.error((Object)"Session delete exception.", (Throwable)sessionDeleteException);
        }
    }

    public ValidationResult validate(ImportLibraryItemValidateSpec spec) {
        ValidationResult result = new ValidationResult();
        boolean isUpdateComplete = false;
        String libraryItemToDelete = null;
        String sessionID = spec.sessionID;
        LibraryItemValidationResult valResult = new LibraryItemValidationResult();
        List<LibraryItemEndpointInfo> endPointList = null;
        this._isUpdate = spec.isUpdate;
        try {
            _logger.info((Object)"Import to CL : Checking to see if Transfer can be validated now");
            boolean okToValidate = this.shouldValidateNow(sessionID);
            if (!okToValidate) {
                _logger.error((Object)"Import to CL: Waited enough for the Transfer Status to be ready. Will let this transfer fail");
            } else {
                _logger.info((Object)"Import to CL: The Transfer Session is ready. Will proceed to Validate");
            }
            FileTypes.ValidationResult validationResult = this._updateSessionFile.validate(sessionID);
            if (validationResult.getHasErrors()) {
                List invalidFiles = validationResult.getInvalidFiles();
                if (!invalidFiles.isEmpty()) {
                    libraryItemToDelete = this._updateSession.get(sessionID).getLibraryItemId();
                    String clientErrorMessage = this.createErrorMessage(invalidFiles);
                    this._updateSession.fail(sessionID, clientErrorMessage);
                    _logger.error((Object)String.format("Session with ID: %s failed with error: %s.", sessionID, clientErrorMessage));
                    isUpdateComplete = true;
                } else {
                    Set missingFiles = validationResult.getMissingFiles();
                    this.addMissingFiles(sessionID, missingFiles, FileTypes.SourceType.PUSH);
                    endPointList = LibraryItemUtil.getLibraryItemEndPointList(this._updateSessionFile, sessionID);
                }
            } else {
                UpdateSessionModel model = this._updateSession.get(sessionID);
                List warnings = model.getPreviewInfo().getWarnings();
                if (warnings != null && warnings.size() > 0) {
                    result.result = model;
                } else {
                    this._updateSession.complete(sessionID);
                    _logger.info((Object)String.format("Session with ID: %s completed successfully.", sessionID));
                    isUpdateComplete = true;
                }
                result.result = model;
                return result;
            }
            valResult.endPointList = endPointList;
            valResult.isComplete = isUpdateComplete;
            result.result = valResult;
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Session with ID: %s failed validation. spec = %s", sessionID, ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            result.error = e;
            libraryItemToDelete = this._updateSession.get(sessionID).getLibraryItemId();
        }
        if (libraryItemToDelete != null && !this._isUpdate) {
            this.deleteSession(sessionID);
            LibraryItemUtil.deleteLibraryItem(libraryItemToDelete, this._libraryItemService, this._vapiTaskMonitor);
        }
        return result;
    }

    private boolean shouldValidateNow(String sessionID) {
        if (this._updateSessionFile == null) {
            return false;
        }
        List files = this._updateSessionFile.list(sessionID);
        _logger.debug((Object)String.format("Import to CL : Validation PreCheck : List received : Total File Count %d", files.size()));
        for (FileTypes.Info file : files) {
            if (file == null) continue;
            TransferStatus trState = file.getStatus();
            String fileName = file.getName();
            _logger.debug((Object)String.format("Import to CL : Status of File [%s] is [%s]", fileName, trState));
            if (trState == TransferStatus.READY) continue;
            _logger.warn((Object)String.format("Import to CL : Not ready to validate yet. will wait for File [%s] state [%s] to become READY", fileName, trState));
            if (this.waitTillReady(sessionID, fileName)) continue;
            _logger.warn((Object)String.format("Import to CL : Not Ready File [%s] never got ready", fileName));
            return false;
        }
        _logger.debug((Object)"Import to CL : All files are READY to Validate");
        return true;
    }

    private boolean waitTillReady(String sessionId, String fileName) {
        try {
            for (int count = 0; count < 100; ++count) {
                FileTypes.Info file = this._updateSessionFile.get(sessionId, fileName);
                TransferStatus trState = file.getStatus();
                if (trState == TransferStatus.READY) {
                    _logger.debug((Object)String.format("Import to CL : File [%s] : State Ready after %d retries", fileName, count));
                    return true;
                }
                if (trState == TransferStatus.ERROR) {
                    _logger.warn((Object)String.format("Import to CL: backend Error in Transfer for File [%s] after %d retries... ", fileName, count));
                    break;
                }
                _logger.debug((Object)String.format("Import to CL : Still waiting to be ready : File [%s] State [%s] @count[%d]", fileName, trState, count));
                Thread.sleep(3000L);
            }
        }
        catch (InterruptedException e) {
            _logger.error((Object)("Import to CL : InterruptedException during pre-Validation : waitTillReady" + e));
            Thread.currentThread().interrupt();
        }
        return false;
    }

    private void addMissingFiles(String sessionID, Set<String> missingFiles, FileTypes.SourceType sourceType) {
        if (!missingFiles.isEmpty()) {
            for (String fileName : missingFiles) {
                FileTypes.AddSpec fileSpec = LibraryItemUtil.createAddFileSpec(fileName, sourceType, null);
                this._updateSessionFile.add(sessionID, fileSpec);
                _logger.info((Object)String.format("Session with ID: %s - added missing file: %s.", sessionID, fileName));
            }
        }
    }

    private String createErrorMessage(List<FileTypes.ValidationError> invalidFiles) {
        StringBuilder errorBuilder = new StringBuilder();
        for (FileTypes.ValidationError error : invalidFiles) {
            errorBuilder.append(error.getName()).append(":");
            errorBuilder.append(System.lineSeparator());
            errorBuilder.append(error.getErrorMessage().getDefaultMessage());
            errorBuilder.append(System.lineSeparator());
        }
        return errorBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult apply(URI libraryItem, ImportLibraryItemCompleteSpec spec) {
        OperationResult operationResult = new OperationResult();
        String sessionID = spec.updateSessionID;
        String libraryItemToDelete = null;
        try {
            if (spec.clientErrorMessage != null) {
                libraryItemToDelete = this._updateSession.get(sessionID).getLibraryItemId();
                this._updateSession.fail(sessionID, spec.clientErrorMessage);
            } else if (!Boolean.TRUE.equals(spec.isCanceled)) {
                this._updateSession.keepAlive(sessionID, Long.valueOf(100L));
                this._updateSession.complete(sessionID);
                _logger.info((Object)String.format("Session with ID: %s completed successfully.", sessionID));
            } else {
                libraryItemToDelete = this._updateSession.get(sessionID).getLibraryItemId();
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Completing file download failed. spec = " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            libraryItemToDelete = this._updateSession.get(sessionID).getLibraryItemId();
            operationResult.error = e;
        }
        finally {
            this.deleteSession(sessionID);
        }
        if (libraryItemToDelete != null && !this._isUpdate) {
            operationResult = LibraryItemUtil.deleteLibraryItem(libraryItemToDelete, this._libraryItemService, this._vapiTaskMonitor);
        }
        return operationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult apply(URI libraryItem, ImportLibraryOvaItemCompleteSpec spec) {
        OperationResult operationResult = new OperationResult();
        String sessionID = spec.updateSessionID;
        String libraryItemToDelete = null;
        UpdateSessionModel updateSpec = null;
        try {
            if (spec.clientErrorMessage != null || Boolean.TRUE.equals(spec.isCanceled)) {
                libraryItemToDelete = this._updateSession.get(sessionID).getLibraryItemId();
                if (spec.clientErrorMessage != null) {
                    this._updateSession.fail(sessionID, spec.clientErrorMessage);
                }
                this._updateSession.cancel(sessionID);
            } else {
                updateSpec = this._updateSession.get(sessionID);
                if (this.isUpdateSessionActive(updateSpec)) {
                    updateSpec.setWarningBehavior(spec.warningBehaviour);
                    this._updateSession.update(sessionID, updateSpec);
                    if (this.isReadyToCompleteOvaUpdateSession(updateSpec, spec.isPullSession)) {
                        this._updateSession.complete(sessionID);
                    }
                    _logger.info((Object)String.format("Session with ID: %s completed successfully.", sessionID));
                } else if (this.isUpdateSessionEnded(updateSpec)) {
                    _logger.info((Object)String.format("Session with ID: %s has ended due to either an ERROR or CANCELLATION.", sessionID));
                    libraryItemToDelete = this._updateSession.get(sessionID).getLibraryItemId();
                }
            }
        }
        catch (Exception e) {
            if (e instanceof NotFound) {
                operationResult.result = "UPDATE_SESSION_NOT_FOUND";
            } else {
                _logger.error((Object)("Completing file download failed. spec = " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
                libraryItemToDelete = this._updateSession.get(sessionID).getLibraryItemId();
                operationResult.error = e;
            }
        }
        finally {
            try {
                if (this.isReadyToCompleteOvaUpdateSession(updateSpec, spec.isPullSession) || Boolean.TRUE.equals(spec.isCanceled)) {
                    this.deleteSession(sessionID);
                }
            }
            catch (Exception e) {
                _logger.error((Object)("Deleting session failed. " + e));
                operationResult.error = e;
            }
        }
        if (libraryItemToDelete != null && !this._isUpdate) {
            operationResult = LibraryItemUtil.deleteLibraryItem(libraryItemToDelete, this._libraryItemService, this._vapiTaskMonitor);
            _logger.info((Object)String.format("Session with ID: %s completed successfully.", sessionID));
        }
        return operationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult validate(URI libraryUri, QueryUpdateSessionStateSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        String sessionID = spec.updateSessionID;
        UpdateSessionModel updateSpec = null;
        try {
            updateSpec = this._updateSession.get(sessionID);
        }
        catch (Exception e) {
            try {
                _logger.error((Object)("Error while retrieving current state of Update Session: " + e));
            }
            catch (Throwable throwable) {
                if (updateSpec != null && updateSpec.getState() == UpdateSessionModel.State.ACTIVE) {
                    validationResult.result = false;
                    _logger.debug((Object)String.format("Update Session: %s is still active", updateSpec.getId()));
                } else {
                    validationResult.result = true;
                }
                throw throwable;
            }
            if (updateSpec != null && updateSpec.getState() == UpdateSessionModel.State.ACTIVE) {
                validationResult.result = false;
                _logger.debug((Object)String.format("Update Session: %s is still active", updateSpec.getId()));
            } else {
                validationResult.result = true;
            }
        }
        if (updateSpec != null && updateSpec.getState() == UpdateSessionModel.State.ACTIVE) {
            validationResult.result = false;
            _logger.debug((Object)String.format("Update Session: %s is still active", updateSpec.getId()));
        } else {
            validationResult.result = true;
        }
        return validationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult validate(ImportLibraryItemCompleteSpec spec) {
        ValidationResult operationResult = new ValidationResult();
        String sessionID = spec.updateSessionID;
        String libraryItemToDelete = null;
        List previewWarningList = null;
        List warningBehaviorList = null;
        try {
            if (spec.clientErrorMessage != null) {
                libraryItemToDelete = this._updateSession.get(sessionID).getLibraryItemId();
                this._updateSession.fail(sessionID, spec.clientErrorMessage);
            } else if (!Boolean.TRUE.equals(spec.isCanceled)) {
                this._updateSession.keepAlive(sessionID, Long.valueOf(100L));
                UpdateSessionModel result = this._updateSession.get(sessionID);
                PreviewInfo pInfo = result.getPreviewInfo();
                if (pInfo != null) {
                    previewWarningList = pInfo.getWarnings();
                }
                operationResult.result = result;
                warningBehaviorList = result.getWarningBehavior();
                if (this.isReadyToCompleteUpateSession(previewWarningList, warningBehaviorList)) {
                    this._updateSession.complete(sessionID);
                }
            } else {
                libraryItemToDelete = this._updateSession.get(sessionID).getLibraryItemId();
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Completing file download failed. spec = " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            libraryItemToDelete = this._updateSession.get(sessionID).getLibraryItemId();
            operationResult.error = e;
        }
        finally {
            if (this.isReadyToCompleteUpateSession(previewWarningList, warningBehaviorList)) {
                this.deleteSession(sessionID);
            }
        }
        if (libraryItemToDelete != null && !this._isUpdate) {
            LibraryItemUtil.deleteLibraryItem(libraryItemToDelete, this._libraryItemService, this._vapiTaskMonitor);
        }
        return operationResult;
    }

    public ValidationResult validate(URI libraryUri, ImportLibraryItemUpdateSessionSpec spec) {
        ValidationResult operationResult = new ValidationResult();
        String sessionID = spec.updateSessionID;
        try {
            UpdateSessionModel result = this._updateSession.get(sessionID);
            operationResult.result = result;
        }
        catch (Exception e) {
            _logger.error((Object)("Retrieving the update session failed for spec = " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            operationResult.error = e;
        }
        return operationResult;
    }

    public ValidationResult validate(ImportLibraryItemProgressSpec spec) {
        try {
            this._updateSession.keepAlive(spec.sessionID, Long.valueOf(spec.transferProgress));
            _logger.info((Object)String.format("Session with ID: %s reported progress: %s.", spec.sessionID, spec.transferProgress));
        }
        catch (Exception e) {
            _logger.error((Object)("Reporting transfer progress failed. spec = " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
        }
        return new ValidationResult();
    }

    private boolean isReadyToCompleteUpateSession(List<PreviewWarningInfo> previewWarnings, List<WarningBehavior> acceptedWarnings) {
        if (previewWarnings == null || previewWarnings.isEmpty()) {
            return true;
        }
        if (acceptedWarnings == null || acceptedWarnings.isEmpty()) {
            return false;
        }
        for (WarningBehavior warning : acceptedWarnings) {
            if (warning.getIgnored()) continue;
            return false;
        }
        return true;
    }

    private boolean isReadyToCompleteOvaUpdateSession(UpdateSessionModel updateSpec, Boolean isPullSession) {
        if (updateSpec != null) {
            return updateSpec.getState().toString().equals("ACTIVE") && (updateSpec.getClientProgress() == 100L || isPullSession != false);
        }
        return false;
    }

    private boolean isUpdateSessionActive(UpdateSessionModel updateSpec) {
        if (updateSpec != null) {
            return updateSpec.getState() == UpdateSessionModel.State.ACTIVE;
        }
        return false;
    }

    private boolean isUpdateSessionEnded(UpdateSessionModel updateSpec) {
        if (updateSpec != null) {
            return updateSpec.getState() == UpdateSessionModel.State.ERROR || updateSpec.getState() == UpdateSessionModel.State.CANCELED;
        }
        return false;
    }

    private boolean isImportOvaSupportAvailableForVc(ImportLibraryItemSpec importSpec) {
        return this._featureStateService.isEnabled(Feature.CL_OVA_Support) && VcServiceUtil.is671VcOrLaterByServerGuid((String)importSpec.serverGuid, (boolean)true);
    }
}

