/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.config;

import com.vmware.h5.sdk.plugin.migration.utils.PluginMigrationUtils;
import com.vmware.h5.sdk.plugin.migration.version.ManifestVersion;
import com.vmware.h5.sdk.plugin.migration.version.ManifestVersionValidator;

public class Configuration {
    private String projectDir;
    private String outputDir;
    private String sdkVersion;
    private boolean isHelp;

    public Configuration(String[] args) {
        this.processArgs(args);
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    public void setProjectDir(String projectDir) {
        this.projectDir = projectDir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public boolean isHelp() {
        return this.isHelp;
    }

    public void setHelp(boolean help) {
        this.isHelp = help;
    }

    private void processArgs(String[] args) {
        this.isHelp = this.isHelpOptionPresent(args);
        if (!this.isHelp) {
            this.projectDir = this.getOptionValue(args, "--projectDir", "-p", true, "");
            this.outputDir = this.getOptionValue(args, "--outputDir", "-o", false, "");
            this.sdkVersion = this.getOptionValue(args, "--sdkVersion", "-v", false, ManifestVersion.VERSION_1_0_0.getVersion());
            if (!PluginMigrationUtils.isStringEmpty(this.sdkVersion) && !ManifestVersionValidator.validate(this.sdkVersion)) {
                System.out.println(String.format("The specified target sdk version %s is not supported", this.sdkVersion));
                System.exit(1);
            }
            if (PluginMigrationUtils.isStringEmpty(this.outputDir)) {
                this.outputDir = this.projectDir;
            }
        }
    }

    private boolean isHelpOptionPresent(String[] args) {
        for (String arg : args) {
            if (!"--help".equalsIgnoreCase(arg) && !"-h".equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    private String getOptionValue(String[] args, String option, String optionAlias, boolean isRequired, String defaultValue) {
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            if (!args[i].equalsIgnoreCase(option) && !args[i].equalsIgnoreCase(optionAlias)) continue;
            if (i + 1 > len - 1 || PluginMigrationUtils.isStringEmpty(args[i + 1])) {
                System.out.println(String.format("Option value is not present for option : %s", args[i]));
                System.exit(1);
            }
            return args[i + 1];
        }
        if (isRequired) {
            System.out.println(String.format("Required option is not present : %s or %s", option, optionAlias));
            System.exit(1);
        }
        return defaultValue;
    }
}

