/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.error;

import com.vmware.h5.sdk.plugin.migration.version.ManifestVersion;

public enum PluginManifestError {
    GENERAL_UNSUPPORTED_ERR("ERR_1001", ErrorMessage.access$000()),
    GLOBAL_VIEWS_UNSUPPORTED_ERR("ERR_1002", ErrorMessage.access$100()),
    ACTION_SPECS_UNSUPPORTED_ERR("ERR_1003", "The following extensions are not supported for the extension type - %s and object type - %s. Reason: Unsupported action spec with class name %s"),
    CONSTRAINTS_UNSUPPORTED_ERR("ERR_1004", ErrorMessage.access$200()),
    EXTENSIONS_UNSUPPORTED_ERR("ERR_1005", ErrorMessage.access$300()),
    OBJECT_EXTENSIONS_UNSUPPORTED_ERR("ERR_1006", "The following extensions are not supported for the object type %s");

    private final String errorCode;
    private final String message;

    private PluginManifestError(String errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    private static class ErrorMessage {
        private static final String GENERAL_UNSUPPORTED_MSG = "The following extensions are not supported in the plugin manifest version " + ManifestVersion.VERSION_1_0_0.getVersion() + " for the extension type - %s.";
        private static final String GLOBAL_VIEWS_UNSUPPORTED_MSG = GENERAL_UNSUPPORTED_MSG + " Reason: since the current plugin manifest version " + ManifestVersion.VERSION_1_0_0.getVersion() + " supports only one global extension Also, multiple global UI screens should be implemented in the plugin UI and nested into the single global view.";
        private static final String ACTION_SPECS_UNSUPPORTED_MSG = "The following extensions are not supported for the extension type - %s and object type - %s. Reason: Unsupported action spec with class name %s";
        private static final String CONSTRAINTS_UNSUPPORTED_MSG = "The following extension contains property conditions or privilege constraints in the metadata which are not supported in the plugin manifest version " + ManifestVersion.VERSION_1_0_0.getVersion();
        private static final String EXTENSIONS_UNSUPPORTED_MSG = "The following extensions are not supported in the plugin manifest version " + ManifestVersion.VERSION_1_0_0.getVersion();
        private static final String OBJECT_EXTENSIONS_UNSUPPORTED_MSG = "The following extensions are not supported for the object type %s";

        private ErrorMessage() {
        }

        static /* synthetic */ String access$000() {
            return GENERAL_UNSUPPORTED_MSG;
        }

        static /* synthetic */ String access$100() {
            return GLOBAL_VIEWS_UNSUPPORTED_MSG;
        }

        static /* synthetic */ String access$200() {
            return CONSTRAINTS_UNSUPPORTED_MSG;
        }

        static /* synthetic */ String access$300() {
            return EXTENSIONS_UNSUPPORTED_MSG;
        }
    }
}

